# -*- coding: utf-8 -*-

# Soya 3D
# Copyright (C) 2001-2014 Jean-Baptiste LAMY
# http://www.lesfleursdunormal.fr/static/informatique/soya3d/index_en.html

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


cdef class _OpenGL

cdef _OpenGL _opengl

cdef class _OpenGL:
  cdef void _init_consts(self):
    self.GL_FALSE = GL_FALSE
    self.GL_TRUE = GL_TRUE
    self.GL_BYTE = GL_BYTE
    self.GL_UNSIGNED_BYTE = GL_UNSIGNED_BYTE
    self.GL_SHORT = GL_SHORT
    self.GL_UNSIGNED_SHORT = GL_UNSIGNED_SHORT
    self.GL_INT = GL_INT
    self.GL_UNSIGNED_INT = GL_UNSIGNED_INT
    self.GL_FLOAT = GL_FLOAT
    self.GL_DOUBLE = GL_DOUBLE
    self.GL_2_BYTES = GL_2_BYTES
    self.GL_3_BYTES = GL_3_BYTES
    self.GL_4_BYTES = GL_4_BYTES
    self.GL_POINTS = GL_POINTS
    self.GL_LINES = GL_LINES
    self.GL_LINE_LOOP = GL_LINE_LOOP
    self.GL_LINE_STRIP = GL_LINE_STRIP
    self.GL_TRIANGLES = GL_TRIANGLES
    self.GL_TRIANGLE_STRIP = GL_TRIANGLE_STRIP
    self.GL_TRIANGLE_FAN = GL_TRIANGLE_FAN
    self.GL_QUADS = GL_QUADS
    self.GL_QUAD_STRIP = GL_QUAD_STRIP
    self.GL_POLYGON = GL_POLYGON
    self.GL_VERTEX_ARRAY = GL_VERTEX_ARRAY
    self.GL_NORMAL_ARRAY = GL_NORMAL_ARRAY
    self.GL_COLOR_ARRAY = GL_COLOR_ARRAY
    self.GL_INDEX_ARRAY = GL_INDEX_ARRAY
    self.GL_TEXTURE_COORD_ARRAY = GL_TEXTURE_COORD_ARRAY
    self.GL_EDGE_FLAG_ARRAY = GL_EDGE_FLAG_ARRAY
    self.GL_VERTEX_ARRAY_SIZE = GL_VERTEX_ARRAY_SIZE
    self.GL_VERTEX_ARRAY_TYPE = GL_VERTEX_ARRAY_TYPE
    self.GL_VERTEX_ARRAY_STRIDE = GL_VERTEX_ARRAY_STRIDE
    self.GL_NORMAL_ARRAY_TYPE = GL_NORMAL_ARRAY_TYPE
    self.GL_NORMAL_ARRAY_STRIDE = GL_NORMAL_ARRAY_STRIDE
    self.GL_COLOR_ARRAY_SIZE = GL_COLOR_ARRAY_SIZE
    self.GL_COLOR_ARRAY_TYPE = GL_COLOR_ARRAY_TYPE
    self.GL_COLOR_ARRAY_STRIDE = GL_COLOR_ARRAY_STRIDE
    self.GL_INDEX_ARRAY_TYPE = GL_INDEX_ARRAY_TYPE
    self.GL_INDEX_ARRAY_STRIDE = GL_INDEX_ARRAY_STRIDE
    self.GL_TEXTURE_COORD_ARRAY_SIZE = GL_TEXTURE_COORD_ARRAY_SIZE
    self.GL_TEXTURE_COORD_ARRAY_TYPE = GL_TEXTURE_COORD_ARRAY_TYPE
    self.GL_TEXTURE_COORD_ARRAY_STRIDE = GL_TEXTURE_COORD_ARRAY_STRIDE
    self.GL_EDGE_FLAG_ARRAY_STRIDE = GL_EDGE_FLAG_ARRAY_STRIDE
    self.GL_VERTEX_ARRAY_POINTER = GL_VERTEX_ARRAY_POINTER
    self.GL_NORMAL_ARRAY_POINTER = GL_NORMAL_ARRAY_POINTER
    self.GL_COLOR_ARRAY_POINTER = GL_COLOR_ARRAY_POINTER
    self.GL_INDEX_ARRAY_POINTER = GL_INDEX_ARRAY_POINTER
    self.GL_TEXTURE_COORD_ARRAY_POINTER = GL_TEXTURE_COORD_ARRAY_POINTER
    self.GL_EDGE_FLAG_ARRAY_POINTER = GL_EDGE_FLAG_ARRAY_POINTER
    self.GL_V2F = GL_V2F
    self.GL_V3F = GL_V3F
    self.GL_C4UB_V2F = GL_C4UB_V2F
    self.GL_C4UB_V3F = GL_C4UB_V3F
    self.GL_C3F_V3F = GL_C3F_V3F
    self.GL_N3F_V3F = GL_N3F_V3F
    self.GL_C4F_N3F_V3F = GL_C4F_N3F_V3F
    self.GL_T2F_V3F = GL_T2F_V3F
    self.GL_T4F_V4F = GL_T4F_V4F
    self.GL_T2F_C4UB_V3F = GL_T2F_C4UB_V3F
    self.GL_T2F_C3F_V3F = GL_T2F_C3F_V3F
    self.GL_T2F_N3F_V3F = GL_T2F_N3F_V3F
    self.GL_T2F_C4F_N3F_V3F = GL_T2F_C4F_N3F_V3F
    self.GL_T4F_C4F_N3F_V4F = GL_T4F_C4F_N3F_V4F
    self.GL_MATRIX_MODE = GL_MATRIX_MODE
    self.GL_MODELVIEW = GL_MODELVIEW
    self.GL_PROJECTION = GL_PROJECTION
    self.GL_TEXTURE = GL_TEXTURE
    self.GL_POINT_SMOOTH = GL_POINT_SMOOTH
    self.GL_POINT_SIZE = GL_POINT_SIZE
    self.GL_POINT_SIZE_GRANULARITY = GL_POINT_SIZE_GRANULARITY
    self.GL_POINT_SIZE_RANGE = GL_POINT_SIZE_RANGE
    self.GL_LINE_SMOOTH = GL_LINE_SMOOTH
    self.GL_LINE_STIPPLE = GL_LINE_STIPPLE
    self.GL_LINE_STIPPLE_PATTERN = GL_LINE_STIPPLE_PATTERN
    self.GL_LINE_STIPPLE_REPEAT = GL_LINE_STIPPLE_REPEAT
    self.GL_LINE_WIDTH = GL_LINE_WIDTH
    self.GL_LINE_WIDTH_GRANULARITY = GL_LINE_WIDTH_GRANULARITY
    self.GL_LINE_WIDTH_RANGE = GL_LINE_WIDTH_RANGE
    self.GL_POINT = GL_POINT
    self.GL_LINE = GL_LINE
    self.GL_FILL = GL_FILL
    self.GL_CW = GL_CW
    self.GL_CCW = GL_CCW
    self.GL_FRONT = GL_FRONT
    self.GL_BACK = GL_BACK
    self.GL_POLYGON_MODE = GL_POLYGON_MODE
    self.GL_POLYGON_SMOOTH = GL_POLYGON_SMOOTH
    self.GL_POLYGON_STIPPLE = GL_POLYGON_STIPPLE
    self.GL_EDGE_FLAG = GL_EDGE_FLAG
    self.GL_CULL_FACE = GL_CULL_FACE
    self.GL_CULL_FACE_MODE = GL_CULL_FACE_MODE
    self.GL_FRONT_FACE = GL_FRONT_FACE
    self.GL_POLYGON_OFFSET_FACTOR = GL_POLYGON_OFFSET_FACTOR
    self.GL_POLYGON_OFFSET_UNITS = GL_POLYGON_OFFSET_UNITS
    self.GL_POLYGON_OFFSET_POINT = GL_POLYGON_OFFSET_POINT
    self.GL_POLYGON_OFFSET_LINE = GL_POLYGON_OFFSET_LINE
    self.GL_POLYGON_OFFSET_FILL = GL_POLYGON_OFFSET_FILL
    self.GL_COMPILE = GL_COMPILE
    self.GL_COMPILE_AND_EXECUTE = GL_COMPILE_AND_EXECUTE
    self.GL_LIST_BASE = GL_LIST_BASE
    self.GL_LIST_INDEX = GL_LIST_INDEX
    self.GL_LIST_MODE = GL_LIST_MODE
    self.GL_NEVER = GL_NEVER
    self.GL_LESS = GL_LESS
    self.GL_EQUAL = GL_EQUAL
    self.GL_LEQUAL = GL_LEQUAL
    self.GL_GREATER = GL_GREATER
    self.GL_NOTEQUAL = GL_NOTEQUAL
    self.GL_GEQUAL = GL_GEQUAL
    self.GL_ALWAYS = GL_ALWAYS
    self.GL_DEPTH_TEST = GL_DEPTH_TEST
    self.GL_DEPTH_BITS = GL_DEPTH_BITS
    self.GL_DEPTH_CLEAR_VALUE = GL_DEPTH_CLEAR_VALUE
    self.GL_DEPTH_FUNC = GL_DEPTH_FUNC
    self.GL_DEPTH_RANGE = GL_DEPTH_RANGE
    self.GL_DEPTH_WRITEMASK = GL_DEPTH_WRITEMASK
    self.GL_DEPTH_COMPONENT = GL_DEPTH_COMPONENT
    self.GL_LIGHTING = GL_LIGHTING
    self.GL_LIGHT0 = GL_LIGHT0
    self.GL_LIGHT1 = GL_LIGHT1
    self.GL_LIGHT2 = GL_LIGHT2
    self.GL_LIGHT3 = GL_LIGHT3
    self.GL_LIGHT4 = GL_LIGHT4
    self.GL_LIGHT5 = GL_LIGHT5
    self.GL_LIGHT6 = GL_LIGHT6
    self.GL_LIGHT7 = GL_LIGHT7
    self.GL_SPOT_EXPONENT = GL_SPOT_EXPONENT
    self.GL_SPOT_CUTOFF = GL_SPOT_CUTOFF
    self.GL_CONSTANT_ATTENUATION = GL_CONSTANT_ATTENUATION
    self.GL_LINEAR_ATTENUATION = GL_LINEAR_ATTENUATION
    self.GL_QUADRATIC_ATTENUATION = GL_QUADRATIC_ATTENUATION
    self.GL_AMBIENT = GL_AMBIENT
    self.GL_DIFFUSE = GL_DIFFUSE
    self.GL_SPECULAR = GL_SPECULAR
    self.GL_SHININESS = GL_SHININESS
    self.GL_EMISSION = GL_EMISSION
    self.GL_POSITION = GL_POSITION
    self.GL_SPOT_DIRECTION = GL_SPOT_DIRECTION
    self.GL_AMBIENT_AND_DIFFUSE = GL_AMBIENT_AND_DIFFUSE
    self.GL_COLOR_INDEXES = GL_COLOR_INDEXES
    self.GL_LIGHT_MODEL_TWO_SIDE = GL_LIGHT_MODEL_TWO_SIDE
    self.GL_LIGHT_MODEL_LOCAL_VIEWER = GL_LIGHT_MODEL_LOCAL_VIEWER
    self.GL_LIGHT_MODEL_AMBIENT = GL_LIGHT_MODEL_AMBIENT
    self.GL_FRONT_AND_BACK = GL_FRONT_AND_BACK
    self.GL_SHADE_MODEL = GL_SHADE_MODEL
    self.GL_FLAT = GL_FLAT
    self.GL_SMOOTH = GL_SMOOTH
    self.GL_COLOR_MATERIAL = GL_COLOR_MATERIAL
    self.GL_COLOR_MATERIAL_FACE = GL_COLOR_MATERIAL_FACE
    self.GL_COLOR_MATERIAL_PARAMETER = GL_COLOR_MATERIAL_PARAMETER
    self.GL_NORMALIZE = GL_NORMALIZE
    self.GL_CLIP_PLANE0 = GL_CLIP_PLANE0
    self.GL_CLIP_PLANE1 = GL_CLIP_PLANE1
    self.GL_CLIP_PLANE2 = GL_CLIP_PLANE2
    self.GL_CLIP_PLANE3 = GL_CLIP_PLANE3
    self.GL_CLIP_PLANE4 = GL_CLIP_PLANE4
    self.GL_CLIP_PLANE5 = GL_CLIP_PLANE5
    self.GL_ACCUM_RED_BITS = GL_ACCUM_RED_BITS
    self.GL_ACCUM_GREEN_BITS = GL_ACCUM_GREEN_BITS
    self.GL_ACCUM_BLUE_BITS = GL_ACCUM_BLUE_BITS
    self.GL_ACCUM_ALPHA_BITS = GL_ACCUM_ALPHA_BITS
    self.GL_ACCUM_CLEAR_VALUE = GL_ACCUM_CLEAR_VALUE
    self.GL_ACCUM = GL_ACCUM
    self.GL_ADD = GL_ADD
    self.GL_LOAD = GL_LOAD
    self.GL_MULT = GL_MULT
    self.GL_RETURN = GL_RETURN
    self.GL_ALPHA_TEST = GL_ALPHA_TEST
    self.GL_ALPHA_TEST_REF = GL_ALPHA_TEST_REF
    self.GL_ALPHA_TEST_FUNC = GL_ALPHA_TEST_FUNC
    self.GL_BLEND = GL_BLEND
    self.GL_BLEND_SRC = GL_BLEND_SRC
    self.GL_BLEND_DST = GL_BLEND_DST
    self.GL_ZERO = GL_ZERO
    self.GL_ONE = GL_ONE
    self.GL_SRC_COLOR = GL_SRC_COLOR
    self.GL_ONE_MINUS_SRC_COLOR = GL_ONE_MINUS_SRC_COLOR
    self.GL_SRC_ALPHA = GL_SRC_ALPHA
    self.GL_ONE_MINUS_SRC_ALPHA = GL_ONE_MINUS_SRC_ALPHA
    self.GL_DST_ALPHA = GL_DST_ALPHA
    self.GL_ONE_MINUS_DST_ALPHA = GL_ONE_MINUS_DST_ALPHA
    self.GL_DST_COLOR = GL_DST_COLOR
    self.GL_ONE_MINUS_DST_COLOR = GL_ONE_MINUS_DST_COLOR
    self.GL_SRC_ALPHA_SATURATE = GL_SRC_ALPHA_SATURATE
    self.GL_CONSTANT_COLOR = GL_CONSTANT_COLOR
    self.GL_ONE_MINUS_CONSTANT_COLOR = GL_ONE_MINUS_CONSTANT_COLOR
    self.GL_CONSTANT_ALPHA = GL_CONSTANT_ALPHA
    self.GL_ONE_MINUS_CONSTANT_ALPHA = GL_ONE_MINUS_CONSTANT_ALPHA
    self.GL_FEEDBACK = GL_FEEDBACK
    self.GL_RENDER = GL_RENDER
    self.GL_SELECT = GL_SELECT
    self.GL_2D = GL_2D
    self.GL_3D = GL_3D
    self.GL_3D_COLOR = GL_3D_COLOR
    self.GL_3D_COLOR_TEXTURE = GL_3D_COLOR_TEXTURE
    self.GL_4D_COLOR_TEXTURE = GL_4D_COLOR_TEXTURE
    self.GL_POINT_TOKEN = GL_POINT_TOKEN
    self.GL_LINE_TOKEN = GL_LINE_TOKEN
    self.GL_LINE_RESET_TOKEN = GL_LINE_RESET_TOKEN
    self.GL_POLYGON_TOKEN = GL_POLYGON_TOKEN
    self.GL_BITMAP_TOKEN = GL_BITMAP_TOKEN
    self.GL_DRAW_PIXEL_TOKEN = GL_DRAW_PIXEL_TOKEN
    self.GL_COPY_PIXEL_TOKEN = GL_COPY_PIXEL_TOKEN
    self.GL_PASS_THROUGH_TOKEN = GL_PASS_THROUGH_TOKEN
    self.GL_FEEDBACK_BUFFER_POINTER = GL_FEEDBACK_BUFFER_POINTER
    self.GL_FEEDBACK_BUFFER_SIZE = GL_FEEDBACK_BUFFER_SIZE
    self.GL_FEEDBACK_BUFFER_TYPE = GL_FEEDBACK_BUFFER_TYPE
    self.GL_SELECTION_BUFFER_POINTER = GL_SELECTION_BUFFER_POINTER
    self.GL_SELECTION_BUFFER_SIZE = GL_SELECTION_BUFFER_SIZE
    self.GL_FOG = GL_FOG
    self.GL_FOG_MODE = GL_FOG_MODE
    self.GL_FOG_DENSITY = GL_FOG_DENSITY
    self.GL_FOG_COLOR = GL_FOG_COLOR
    self.GL_FOG_INDEX = GL_FOG_INDEX
    self.GL_FOG_START = GL_FOG_START
    self.GL_FOG_END = GL_FOG_END
    self.GL_LINEAR = GL_LINEAR
    self.GL_EXP = GL_EXP
    self.GL_EXP2 = GL_EXP2
    self.GL_LOGIC_OP = GL_LOGIC_OP
    self.GL_INDEX_LOGIC_OP = GL_INDEX_LOGIC_OP
    self.GL_COLOR_LOGIC_OP = GL_COLOR_LOGIC_OP
    self.GL_LOGIC_OP_MODE = GL_LOGIC_OP_MODE
    self.GL_CLEAR = GL_CLEAR
    self.GL_SET = GL_SET
    self.GL_COPY = GL_COPY
    self.GL_COPY_INVERTED = GL_COPY_INVERTED
    self.GL_NOOP = GL_NOOP
    self.GL_INVERT = GL_INVERT
    self.GL_AND = GL_AND
    self.GL_NAND = GL_NAND
    self.GL_OR = GL_OR
    self.GL_NOR = GL_NOR
    self.GL_XOR = GL_XOR
    self.GL_EQUIV = GL_EQUIV
    self.GL_AND_REVERSE = GL_AND_REVERSE
    self.GL_AND_INVERTED = GL_AND_INVERTED
    self.GL_OR_REVERSE = GL_OR_REVERSE
    self.GL_OR_INVERTED = GL_OR_INVERTED
    self.GL_STENCIL_TEST = GL_STENCIL_TEST
    self.GL_STENCIL_WRITEMASK = GL_STENCIL_WRITEMASK
    self.GL_STENCIL_BITS = GL_STENCIL_BITS
    self.GL_STENCIL_FUNC = GL_STENCIL_FUNC
    self.GL_STENCIL_VALUE_MASK = GL_STENCIL_VALUE_MASK
    self.GL_STENCIL_REF = GL_STENCIL_REF
    self.GL_STENCIL_FAIL = GL_STENCIL_FAIL
    self.GL_STENCIL_PASS_DEPTH_PASS = GL_STENCIL_PASS_DEPTH_PASS
    self.GL_STENCIL_PASS_DEPTH_FAIL = GL_STENCIL_PASS_DEPTH_FAIL
    self.GL_STENCIL_CLEAR_VALUE = GL_STENCIL_CLEAR_VALUE
    self.GL_STENCIL_INDEX = GL_STENCIL_INDEX
    self.GL_KEEP = GL_KEEP
    self.GL_REPLACE = GL_REPLACE
    self.GL_INCR = GL_INCR
    self.GL_DECR = GL_DECR
    self.GL_NONE = GL_NONE
    self.GL_LEFT = GL_LEFT
    self.GL_RIGHT = GL_RIGHT
    self.GL_FRONT_LEFT = GL_FRONT_LEFT
    self.GL_FRONT_RIGHT = GL_FRONT_RIGHT
    self.GL_BACK_LEFT = GL_BACK_LEFT
    self.GL_BACK_RIGHT = GL_BACK_RIGHT
    self.GL_AUX0 = GL_AUX0
    self.GL_AUX1 = GL_AUX1
    self.GL_AUX2 = GL_AUX2
    self.GL_AUX3 = GL_AUX3
    self.GL_COLOR_INDEX = GL_COLOR_INDEX
    self.GL_RED = GL_RED
    self.GL_GREEN = GL_GREEN
    self.GL_BLUE = GL_BLUE
    self.GL_ALPHA = GL_ALPHA
    self.GL_LUMINANCE = GL_LUMINANCE
    self.GL_LUMINANCE_ALPHA = GL_LUMINANCE_ALPHA
    self.GL_ALPHA_BITS = GL_ALPHA_BITS
    self.GL_RED_BITS = GL_RED_BITS
    self.GL_GREEN_BITS = GL_GREEN_BITS
    self.GL_BLUE_BITS = GL_BLUE_BITS
    self.GL_INDEX_BITS = GL_INDEX_BITS
    self.GL_SUBPIXEL_BITS = GL_SUBPIXEL_BITS
    self.GL_AUX_BUFFERS = GL_AUX_BUFFERS
    self.GL_READ_BUFFER = GL_READ_BUFFER
    self.GL_DRAW_BUFFER = GL_DRAW_BUFFER
    self.GL_DOUBLEBUFFER = GL_DOUBLEBUFFER
    self.GL_STEREO = GL_STEREO
    self.GL_BITMAP = GL_BITMAP
    self.GL_COLOR = GL_COLOR
    self.GL_DEPTH = GL_DEPTH
    self.GL_STENCIL = GL_STENCIL
    self.GL_DITHER = GL_DITHER
    self.GL_RGB = GL_RGB
    self.GL_RGBA = GL_RGBA
    self.GL_MAX_LIST_NESTING = GL_MAX_LIST_NESTING
    self.GL_MAX_ATTRIB_STACK_DEPTH = GL_MAX_ATTRIB_STACK_DEPTH
    self.GL_MAX_MODELVIEW_STACK_DEPTH = GL_MAX_MODELVIEW_STACK_DEPTH
    self.GL_MAX_NAME_STACK_DEPTH = GL_MAX_NAME_STACK_DEPTH
    self.GL_MAX_PROJECTION_STACK_DEPTH = GL_MAX_PROJECTION_STACK_DEPTH
    self.GL_MAX_TEXTURE_STACK_DEPTH = GL_MAX_TEXTURE_STACK_DEPTH
    self.GL_MAX_EVAL_ORDER = GL_MAX_EVAL_ORDER
    self.GL_MAX_LIGHTS = GL_MAX_LIGHTS
    self.GL_MAX_CLIP_PLANES = GL_MAX_CLIP_PLANES
    self.GL_MAX_TEXTURE_SIZE = GL_MAX_TEXTURE_SIZE
    self.GL_MAX_PIXEL_MAP_TABLE = GL_MAX_PIXEL_MAP_TABLE
    self.GL_MAX_VIEWPORT_DIMS = GL_MAX_VIEWPORT_DIMS
    self.GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = GL_MAX_CLIENT_ATTRIB_STACK_DEPTH
    self.GL_ATTRIB_STACK_DEPTH = GL_ATTRIB_STACK_DEPTH
    self.GL_CLIENT_ATTRIB_STACK_DEPTH = GL_CLIENT_ATTRIB_STACK_DEPTH
    self.GL_COLOR_CLEAR_VALUE = GL_COLOR_CLEAR_VALUE
    self.GL_COLOR_WRITEMASK = GL_COLOR_WRITEMASK
    self.GL_CURRENT_INDEX = GL_CURRENT_INDEX
    self.GL_CURRENT_COLOR = GL_CURRENT_COLOR
    self.GL_CURRENT_NORMAL = GL_CURRENT_NORMAL
    self.GL_CURRENT_RASTER_COLOR = GL_CURRENT_RASTER_COLOR
    self.GL_CURRENT_RASTER_DISTANCE = GL_CURRENT_RASTER_DISTANCE
    self.GL_CURRENT_RASTER_INDEX = GL_CURRENT_RASTER_INDEX
    self.GL_CURRENT_RASTER_POSITION = GL_CURRENT_RASTER_POSITION
    self.GL_CURRENT_RASTER_TEXTURE_COORDS = GL_CURRENT_RASTER_TEXTURE_COORDS
    self.GL_CURRENT_RASTER_POSITION_VALID = GL_CURRENT_RASTER_POSITION_VALID
    self.GL_CURRENT_TEXTURE_COORDS = GL_CURRENT_TEXTURE_COORDS
    self.GL_INDEX_CLEAR_VALUE = GL_INDEX_CLEAR_VALUE
    self.GL_INDEX_MODE = GL_INDEX_MODE
    self.GL_INDEX_WRITEMASK = GL_INDEX_WRITEMASK
    self.GL_MODELVIEW_MATRIX = GL_MODELVIEW_MATRIX
    self.GL_MODELVIEW_STACK_DEPTH = GL_MODELVIEW_STACK_DEPTH
    self.GL_NAME_STACK_DEPTH = GL_NAME_STACK_DEPTH
    self.GL_PROJECTION_MATRIX = GL_PROJECTION_MATRIX
    self.GL_PROJECTION_STACK_DEPTH = GL_PROJECTION_STACK_DEPTH
    self.GL_RENDER_MODE = GL_RENDER_MODE
    self.GL_RGBA_MODE = GL_RGBA_MODE
    self.GL_TEXTURE_MATRIX = GL_TEXTURE_MATRIX
    self.GL_TEXTURE_STACK_DEPTH = GL_TEXTURE_STACK_DEPTH
    self.GL_VIEWPORT = GL_VIEWPORT
    self.GL_AUTO_NORMAL = GL_AUTO_NORMAL
    self.GL_MAP1_COLOR_4 = GL_MAP1_COLOR_4
    self.GL_MAP1_GRID_DOMAIN = GL_MAP1_GRID_DOMAIN
    self.GL_MAP1_GRID_SEGMENTS = GL_MAP1_GRID_SEGMENTS
    self.GL_MAP1_INDEX = GL_MAP1_INDEX
    self.GL_MAP1_NORMAL = GL_MAP1_NORMAL
    self.GL_MAP1_TEXTURE_COORD_1 = GL_MAP1_TEXTURE_COORD_1
    self.GL_MAP1_TEXTURE_COORD_2 = GL_MAP1_TEXTURE_COORD_2
    self.GL_MAP1_TEXTURE_COORD_3 = GL_MAP1_TEXTURE_COORD_3
    self.GL_MAP1_TEXTURE_COORD_4 = GL_MAP1_TEXTURE_COORD_4
    self.GL_MAP1_VERTEX_3 = GL_MAP1_VERTEX_3
    self.GL_MAP1_VERTEX_4 = GL_MAP1_VERTEX_4
    self.GL_MAP2_COLOR_4 = GL_MAP2_COLOR_4
    self.GL_MAP2_GRID_DOMAIN = GL_MAP2_GRID_DOMAIN
    self.GL_MAP2_GRID_SEGMENTS = GL_MAP2_GRID_SEGMENTS
    self.GL_MAP2_INDEX = GL_MAP2_INDEX
    self.GL_MAP2_NORMAL = GL_MAP2_NORMAL
    self.GL_MAP2_TEXTURE_COORD_1 = GL_MAP2_TEXTURE_COORD_1
    self.GL_MAP2_TEXTURE_COORD_2 = GL_MAP2_TEXTURE_COORD_2
    self.GL_MAP2_TEXTURE_COORD_3 = GL_MAP2_TEXTURE_COORD_3
    self.GL_MAP2_TEXTURE_COORD_4 = GL_MAP2_TEXTURE_COORD_4
    self.GL_MAP2_VERTEX_3 = GL_MAP2_VERTEX_3
    self.GL_MAP2_VERTEX_4 = GL_MAP2_VERTEX_4
    self.GL_COEFF = GL_COEFF
    self.GL_DOMAIN = GL_DOMAIN
    self.GL_ORDER = GL_ORDER
    self.GL_FOG_HINT = GL_FOG_HINT
    self.GL_LINE_SMOOTH_HINT = GL_LINE_SMOOTH_HINT
    self.GL_PERSPECTIVE_CORRECTION_HINT = GL_PERSPECTIVE_CORRECTION_HINT
    self.GL_POINT_SMOOTH_HINT = GL_POINT_SMOOTH_HINT
    self.GL_POLYGON_SMOOTH_HINT = GL_POLYGON_SMOOTH_HINT
    self.GL_DONT_CARE = GL_DONT_CARE
    self.GL_FASTEST = GL_FASTEST
    self.GL_NICEST = GL_NICEST
    self.GL_SCISSOR_TEST = GL_SCISSOR_TEST
    self.GL_SCISSOR_BOX = GL_SCISSOR_BOX
    self.GL_MAP_COLOR = GL_MAP_COLOR
    self.GL_MAP_STENCIL = GL_MAP_STENCIL
    self.GL_INDEX_SHIFT = GL_INDEX_SHIFT
    self.GL_INDEX_OFFSET = GL_INDEX_OFFSET
    self.GL_RED_SCALE = GL_RED_SCALE
    self.GL_RED_BIAS = GL_RED_BIAS
    self.GL_GREEN_SCALE = GL_GREEN_SCALE
    self.GL_GREEN_BIAS = GL_GREEN_BIAS
    self.GL_BLUE_SCALE = GL_BLUE_SCALE
    self.GL_BLUE_BIAS = GL_BLUE_BIAS
    self.GL_ALPHA_SCALE = GL_ALPHA_SCALE
    self.GL_ALPHA_BIAS = GL_ALPHA_BIAS
    self.GL_DEPTH_SCALE = GL_DEPTH_SCALE
    self.GL_DEPTH_BIAS = GL_DEPTH_BIAS
    self.GL_PIXEL_MAP_S_TO_S_SIZE = GL_PIXEL_MAP_S_TO_S_SIZE
    self.GL_PIXEL_MAP_I_TO_I_SIZE = GL_PIXEL_MAP_I_TO_I_SIZE
    self.GL_PIXEL_MAP_I_TO_R_SIZE = GL_PIXEL_MAP_I_TO_R_SIZE
    self.GL_PIXEL_MAP_I_TO_G_SIZE = GL_PIXEL_MAP_I_TO_G_SIZE
    self.GL_PIXEL_MAP_I_TO_B_SIZE = GL_PIXEL_MAP_I_TO_B_SIZE
    self.GL_PIXEL_MAP_I_TO_A_SIZE = GL_PIXEL_MAP_I_TO_A_SIZE
    self.GL_PIXEL_MAP_R_TO_R_SIZE = GL_PIXEL_MAP_R_TO_R_SIZE
    self.GL_PIXEL_MAP_G_TO_G_SIZE = GL_PIXEL_MAP_G_TO_G_SIZE
    self.GL_PIXEL_MAP_B_TO_B_SIZE = GL_PIXEL_MAP_B_TO_B_SIZE
    self.GL_PIXEL_MAP_A_TO_A_SIZE = GL_PIXEL_MAP_A_TO_A_SIZE
    self.GL_PIXEL_MAP_S_TO_S = GL_PIXEL_MAP_S_TO_S
    self.GL_PIXEL_MAP_I_TO_I = GL_PIXEL_MAP_I_TO_I
    self.GL_PIXEL_MAP_I_TO_R = GL_PIXEL_MAP_I_TO_R
    self.GL_PIXEL_MAP_I_TO_G = GL_PIXEL_MAP_I_TO_G
    self.GL_PIXEL_MAP_I_TO_B = GL_PIXEL_MAP_I_TO_B
    self.GL_PIXEL_MAP_I_TO_A = GL_PIXEL_MAP_I_TO_A
    self.GL_PIXEL_MAP_R_TO_R = GL_PIXEL_MAP_R_TO_R
    self.GL_PIXEL_MAP_G_TO_G = GL_PIXEL_MAP_G_TO_G
    self.GL_PIXEL_MAP_B_TO_B = GL_PIXEL_MAP_B_TO_B
    self.GL_PIXEL_MAP_A_TO_A = GL_PIXEL_MAP_A_TO_A
    self.GL_PACK_ALIGNMENT = GL_PACK_ALIGNMENT
    self.GL_PACK_LSB_FIRST = GL_PACK_LSB_FIRST
    self.GL_PACK_ROW_LENGTH = GL_PACK_ROW_LENGTH
    self.GL_PACK_SKIP_PIXELS = GL_PACK_SKIP_PIXELS
    self.GL_PACK_SKIP_ROWS = GL_PACK_SKIP_ROWS
    self.GL_PACK_SWAP_BYTES = GL_PACK_SWAP_BYTES
    self.GL_UNPACK_ALIGNMENT = GL_UNPACK_ALIGNMENT
    self.GL_UNPACK_LSB_FIRST = GL_UNPACK_LSB_FIRST
    self.GL_UNPACK_ROW_LENGTH = GL_UNPACK_ROW_LENGTH
    self.GL_UNPACK_SKIP_PIXELS = GL_UNPACK_SKIP_PIXELS
    self.GL_UNPACK_SKIP_ROWS = GL_UNPACK_SKIP_ROWS
    self.GL_UNPACK_SWAP_BYTES = GL_UNPACK_SWAP_BYTES
    self.GL_ZOOM_X = GL_ZOOM_X
    self.GL_ZOOM_Y = GL_ZOOM_Y
    self.GL_TEXTURE_ENV = GL_TEXTURE_ENV
    self.GL_TEXTURE_ENV_MODE = GL_TEXTURE_ENV_MODE
    self.GL_TEXTURE_1D = GL_TEXTURE_1D
    self.GL_TEXTURE_2D = GL_TEXTURE_2D
    self.GL_TEXTURE_WRAP_S = GL_TEXTURE_WRAP_S
    self.GL_TEXTURE_WRAP_T = GL_TEXTURE_WRAP_T
    self.GL_TEXTURE_MAG_FILTER = GL_TEXTURE_MAG_FILTER
    self.GL_TEXTURE_MIN_FILTER = GL_TEXTURE_MIN_FILTER
    self.GL_TEXTURE_ENV_COLOR = GL_TEXTURE_ENV_COLOR
    self.GL_TEXTURE_GEN_S = GL_TEXTURE_GEN_S
    self.GL_TEXTURE_GEN_T = GL_TEXTURE_GEN_T
    self.GL_TEXTURE_GEN_MODE = GL_TEXTURE_GEN_MODE
    self.GL_TEXTURE_BORDER_COLOR = GL_TEXTURE_BORDER_COLOR
    self.GL_TEXTURE_WIDTH = GL_TEXTURE_WIDTH
    self.GL_TEXTURE_HEIGHT = GL_TEXTURE_HEIGHT
    self.GL_TEXTURE_BORDER = GL_TEXTURE_BORDER
    self.GL_TEXTURE_COMPONENTS = GL_TEXTURE_COMPONENTS
    self.GL_TEXTURE_RED_SIZE = GL_TEXTURE_RED_SIZE
    self.GL_TEXTURE_GREEN_SIZE = GL_TEXTURE_GREEN_SIZE
    self.GL_TEXTURE_BLUE_SIZE = GL_TEXTURE_BLUE_SIZE
    self.GL_TEXTURE_ALPHA_SIZE = GL_TEXTURE_ALPHA_SIZE
    self.GL_TEXTURE_LUMINANCE_SIZE = GL_TEXTURE_LUMINANCE_SIZE
    self.GL_TEXTURE_INTENSITY_SIZE = GL_TEXTURE_INTENSITY_SIZE
    self.GL_NEAREST_MIPMAP_NEAREST = GL_NEAREST_MIPMAP_NEAREST
    self.GL_NEAREST_MIPMAP_LINEAR = GL_NEAREST_MIPMAP_LINEAR
    self.GL_LINEAR_MIPMAP_NEAREST = GL_LINEAR_MIPMAP_NEAREST
    self.GL_LINEAR_MIPMAP_LINEAR = GL_LINEAR_MIPMAP_LINEAR
    self.GL_OBJECT_LINEAR = GL_OBJECT_LINEAR
    self.GL_OBJECT_PLANE = GL_OBJECT_PLANE
    self.GL_EYE_LINEAR = GL_EYE_LINEAR
    self.GL_EYE_PLANE = GL_EYE_PLANE
    self.GL_SPHERE_MAP = GL_SPHERE_MAP
    self.GL_DECAL = GL_DECAL
    self.GL_MODULATE = GL_MODULATE
    self.GL_NEAREST = GL_NEAREST
    self.GL_REPEAT = GL_REPEAT
    self.GL_CLAMP = GL_CLAMP
    self.GL_S = GL_S
    self.GL_T = GL_T
    self.GL_R = GL_R
    self.GL_Q = GL_Q
    self.GL_TEXTURE_GEN_R = GL_TEXTURE_GEN_R
    self.GL_TEXTURE_GEN_Q = GL_TEXTURE_GEN_Q
    self.GL_VENDOR = GL_VENDOR
    self.GL_RENDERER = GL_RENDERER
    self.GL_VERSION = GL_VERSION
    self.GL_EXTENSIONS = GL_EXTENSIONS
    self.GL_NO_ERROR = GL_NO_ERROR
    self.GL_INVALID_VALUE = GL_INVALID_VALUE
    self.GL_INVALID_ENUM = GL_INVALID_ENUM
    self.GL_INVALID_OPERATION = GL_INVALID_OPERATION
    self.GL_STACK_OVERFLOW = GL_STACK_OVERFLOW
    self.GL_STACK_UNDERFLOW = GL_STACK_UNDERFLOW
    self.GL_OUT_OF_MEMORY = GL_OUT_OF_MEMORY
    self.GL_CURRENT_BIT = GL_CURRENT_BIT
    self.GL_POINT_BIT = GL_POINT_BIT
    self.GL_LINE_BIT = GL_LINE_BIT
    self.GL_POLYGON_BIT = GL_POLYGON_BIT
    self.GL_POLYGON_STIPPLE_BIT = GL_POLYGON_STIPPLE_BIT
    self.GL_PIXEL_MODE_BIT = GL_PIXEL_MODE_BIT
    self.GL_LIGHTING_BIT = GL_LIGHTING_BIT
    self.GL_FOG_BIT = GL_FOG_BIT
    self.GL_DEPTH_BUFFER_BIT = GL_DEPTH_BUFFER_BIT
    self.GL_ACCUM_BUFFER_BIT = GL_ACCUM_BUFFER_BIT
    self.GL_STENCIL_BUFFER_BIT = GL_STENCIL_BUFFER_BIT
    self.GL_VIEWPORT_BIT = GL_VIEWPORT_BIT
    self.GL_TRANSFORM_BIT = GL_TRANSFORM_BIT
    self.GL_ENABLE_BIT = GL_ENABLE_BIT
    self.GL_COLOR_BUFFER_BIT = GL_COLOR_BUFFER_BIT
    self.GL_HINT_BIT = GL_HINT_BIT
    self.GL_EVAL_BIT = GL_EVAL_BIT
    self.GL_LIST_BIT = GL_LIST_BIT
    self.GL_TEXTURE_BIT = GL_TEXTURE_BIT
    self.GL_SCISSOR_BIT = GL_SCISSOR_BIT
    self.GL_ALL_ATTRIB_BITS = GL_ALL_ATTRIB_BITS
    self.GL_PROXY_TEXTURE_1D = GL_PROXY_TEXTURE_1D
    self.GL_PROXY_TEXTURE_2D = GL_PROXY_TEXTURE_2D
    self.GL_TEXTURE_PRIORITY = GL_TEXTURE_PRIORITY
    self.GL_TEXTURE_RESIDENT = GL_TEXTURE_RESIDENT
    self.GL_TEXTURE_BINDING_1D = GL_TEXTURE_BINDING_1D
    self.GL_TEXTURE_BINDING_2D = GL_TEXTURE_BINDING_2D
    self.GL_TEXTURE_INTERNAL_FORMAT = GL_TEXTURE_INTERNAL_FORMAT
    self.GL_ALPHA4 = GL_ALPHA4
    self.GL_ALPHA8 = GL_ALPHA8
    self.GL_ALPHA12 = GL_ALPHA12
    self.GL_ALPHA16 = GL_ALPHA16
    self.GL_LUMINANCE4 = GL_LUMINANCE4
    self.GL_LUMINANCE8 = GL_LUMINANCE8
    self.GL_LUMINANCE12 = GL_LUMINANCE12
    self.GL_LUMINANCE16 = GL_LUMINANCE16
    self.GL_LUMINANCE4_ALPHA4 = GL_LUMINANCE4_ALPHA4
    self.GL_LUMINANCE6_ALPHA2 = GL_LUMINANCE6_ALPHA2
    self.GL_LUMINANCE8_ALPHA8 = GL_LUMINANCE8_ALPHA8
    self.GL_LUMINANCE12_ALPHA4 = GL_LUMINANCE12_ALPHA4
    self.GL_LUMINANCE12_ALPHA12 = GL_LUMINANCE12_ALPHA12
    self.GL_LUMINANCE16_ALPHA16 = GL_LUMINANCE16_ALPHA16
    self.GL_INTENSITY = GL_INTENSITY
    self.GL_INTENSITY4 = GL_INTENSITY4
    self.GL_INTENSITY8 = GL_INTENSITY8
    self.GL_INTENSITY12 = GL_INTENSITY12
    self.GL_INTENSITY16 = GL_INTENSITY16
    self.GL_R3_G3_B2 = GL_R3_G3_B2
    self.GL_RGB4 = GL_RGB4
    self.GL_RGB5 = GL_RGB5
    self.GL_RGB8 = GL_RGB8
    self.GL_RGB10 = GL_RGB10
    self.GL_RGB12 = GL_RGB12
    self.GL_RGB16 = GL_RGB16
    self.GL_RGBA2 = GL_RGBA2
    self.GL_RGBA4 = GL_RGBA4
    self.GL_RGB5_A1 = GL_RGB5_A1
    self.GL_RGBA8 = GL_RGBA8
    self.GL_RGB10_A2 = GL_RGB10_A2
    self.GL_RGBA12 = GL_RGBA12
    self.GL_RGBA16 = GL_RGBA16
    self.GL_CLIENT_PIXEL_STORE_BIT = GL_CLIENT_PIXEL_STORE_BIT
    self.GL_CLIENT_VERTEX_ARRAY_BIT = GL_CLIENT_VERTEX_ARRAY_BIT
    self.GL_CLIENT_ALL_ATTRIB_BITS = GL_CLIENT_ALL_ATTRIB_BITS
    self.GL_RESCALE_NORMAL = GL_RESCALE_NORMAL
    self.GL_CLAMP_TO_EDGE = GL_CLAMP_TO_EDGE
    self.GL_MAX_ELEMENTS_VERTICES = GL_MAX_ELEMENTS_VERTICES
    self.GL_MAX_ELEMENTS_INDICES = GL_MAX_ELEMENTS_INDICES
    self.GL_BGR = GL_BGR
    self.GL_BGRA = GL_BGRA
    self.GL_UNSIGNED_BYTE_3_3_2 = GL_UNSIGNED_BYTE_3_3_2
    self.GL_UNSIGNED_BYTE_2_3_3_REV = GL_UNSIGNED_BYTE_2_3_3_REV
    self.GL_UNSIGNED_SHORT_5_6_5 = GL_UNSIGNED_SHORT_5_6_5
    self.GL_UNSIGNED_SHORT_5_6_5_REV = GL_UNSIGNED_SHORT_5_6_5_REV
    self.GL_UNSIGNED_SHORT_4_4_4_4 = GL_UNSIGNED_SHORT_4_4_4_4
    self.GL_UNSIGNED_SHORT_4_4_4_4_REV = GL_UNSIGNED_SHORT_4_4_4_4_REV
    self.GL_UNSIGNED_SHORT_5_5_5_1 = GL_UNSIGNED_SHORT_5_5_5_1
    self.GL_UNSIGNED_SHORT_1_5_5_5_REV = GL_UNSIGNED_SHORT_1_5_5_5_REV
    self.GL_UNSIGNED_INT_8_8_8_8 = GL_UNSIGNED_INT_8_8_8_8
    self.GL_UNSIGNED_INT_8_8_8_8_REV = GL_UNSIGNED_INT_8_8_8_8_REV
    self.GL_UNSIGNED_INT_10_10_10_2 = GL_UNSIGNED_INT_10_10_10_2
    self.GL_UNSIGNED_INT_2_10_10_10_REV = GL_UNSIGNED_INT_2_10_10_10_REV
    self.GL_LIGHT_MODEL_COLOR_CONTROL = GL_LIGHT_MODEL_COLOR_CONTROL
    self.GL_SINGLE_COLOR = GL_SINGLE_COLOR
    self.GL_SEPARATE_SPECULAR_COLOR = GL_SEPARATE_SPECULAR_COLOR
    self.GL_TEXTURE_MIN_LOD = GL_TEXTURE_MIN_LOD
    self.GL_TEXTURE_MAX_LOD = GL_TEXTURE_MAX_LOD
    self.GL_TEXTURE_BASE_LEVEL = GL_TEXTURE_BASE_LEVEL
    self.GL_TEXTURE_MAX_LEVEL = GL_TEXTURE_MAX_LEVEL
    self.GL_SMOOTH_POINT_SIZE_RANGE = GL_SMOOTH_POINT_SIZE_RANGE
    self.GL_SMOOTH_POINT_SIZE_GRANULARITY = GL_SMOOTH_POINT_SIZE_GRANULARITY
    self.GL_SMOOTH_LINE_WIDTH_RANGE = GL_SMOOTH_LINE_WIDTH_RANGE
    self.GL_SMOOTH_LINE_WIDTH_GRANULARITY = GL_SMOOTH_LINE_WIDTH_GRANULARITY
    self.GL_ALIASED_POINT_SIZE_RANGE = GL_ALIASED_POINT_SIZE_RANGE
    self.GL_ALIASED_LINE_WIDTH_RANGE = GL_ALIASED_LINE_WIDTH_RANGE
    self.GL_PACK_SKIP_IMAGES = GL_PACK_SKIP_IMAGES
    self.GL_PACK_IMAGE_HEIGHT = GL_PACK_IMAGE_HEIGHT
    self.GL_UNPACK_SKIP_IMAGES = GL_UNPACK_SKIP_IMAGES
    self.GL_UNPACK_IMAGE_HEIGHT = GL_UNPACK_IMAGE_HEIGHT
    self.GL_TEXTURE_3D = GL_TEXTURE_3D
    self.GL_PROXY_TEXTURE_3D = GL_PROXY_TEXTURE_3D
    self.GL_TEXTURE_DEPTH = GL_TEXTURE_DEPTH
    self.GL_TEXTURE_WRAP_R = GL_TEXTURE_WRAP_R
    self.GL_MAX_3D_TEXTURE_SIZE = GL_MAX_3D_TEXTURE_SIZE
    self.GL_TEXTURE_BINDING_3D = GL_TEXTURE_BINDING_3D
    self.GL_COLOR_TABLE = GL_COLOR_TABLE
    self.GL_POST_CONVOLUTION_COLOR_TABLE = GL_POST_CONVOLUTION_COLOR_TABLE
    self.GL_POST_COLOR_MATRIX_COLOR_TABLE = GL_POST_COLOR_MATRIX_COLOR_TABLE
    self.GL_PROXY_COLOR_TABLE = GL_PROXY_COLOR_TABLE
    self.GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
    self.GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
    self.GL_COLOR_TABLE_SCALE = GL_COLOR_TABLE_SCALE
    self.GL_COLOR_TABLE_BIAS = GL_COLOR_TABLE_BIAS
    self.GL_COLOR_TABLE_FORMAT = GL_COLOR_TABLE_FORMAT
    self.GL_COLOR_TABLE_WIDTH = GL_COLOR_TABLE_WIDTH
    self.GL_COLOR_TABLE_RED_SIZE = GL_COLOR_TABLE_RED_SIZE
    self.GL_COLOR_TABLE_GREEN_SIZE = GL_COLOR_TABLE_GREEN_SIZE
    self.GL_COLOR_TABLE_BLUE_SIZE = GL_COLOR_TABLE_BLUE_SIZE
    self.GL_COLOR_TABLE_ALPHA_SIZE = GL_COLOR_TABLE_ALPHA_SIZE
    self.GL_COLOR_TABLE_LUMINANCE_SIZE = GL_COLOR_TABLE_LUMINANCE_SIZE
    self.GL_COLOR_TABLE_INTENSITY_SIZE = GL_COLOR_TABLE_INTENSITY_SIZE
    self.GL_CONVOLUTION_1D = GL_CONVOLUTION_1D
    self.GL_CONVOLUTION_2D = GL_CONVOLUTION_2D
    self.GL_SEPARABLE_2D = GL_SEPARABLE_2D
    self.GL_CONVOLUTION_BORDER_MODE = GL_CONVOLUTION_BORDER_MODE
    self.GL_CONVOLUTION_FILTER_SCALE = GL_CONVOLUTION_FILTER_SCALE
    self.GL_CONVOLUTION_FILTER_BIAS = GL_CONVOLUTION_FILTER_BIAS
    self.GL_REDUCE = GL_REDUCE
    self.GL_CONVOLUTION_FORMAT = GL_CONVOLUTION_FORMAT
    self.GL_CONVOLUTION_WIDTH = GL_CONVOLUTION_WIDTH
    self.GL_CONVOLUTION_HEIGHT = GL_CONVOLUTION_HEIGHT
    self.GL_MAX_CONVOLUTION_WIDTH = GL_MAX_CONVOLUTION_WIDTH
    self.GL_MAX_CONVOLUTION_HEIGHT = GL_MAX_CONVOLUTION_HEIGHT
    self.GL_POST_CONVOLUTION_RED_SCALE = GL_POST_CONVOLUTION_RED_SCALE
    self.GL_POST_CONVOLUTION_GREEN_SCALE = GL_POST_CONVOLUTION_GREEN_SCALE
    self.GL_POST_CONVOLUTION_BLUE_SCALE = GL_POST_CONVOLUTION_BLUE_SCALE
    self.GL_POST_CONVOLUTION_ALPHA_SCALE = GL_POST_CONVOLUTION_ALPHA_SCALE
    self.GL_POST_CONVOLUTION_RED_BIAS = GL_POST_CONVOLUTION_RED_BIAS
    self.GL_POST_CONVOLUTION_GREEN_BIAS = GL_POST_CONVOLUTION_GREEN_BIAS
    self.GL_POST_CONVOLUTION_BLUE_BIAS = GL_POST_CONVOLUTION_BLUE_BIAS
    self.GL_POST_CONVOLUTION_ALPHA_BIAS = GL_POST_CONVOLUTION_ALPHA_BIAS
    self.GL_CONSTANT_BORDER = GL_CONSTANT_BORDER
    self.GL_REPLICATE_BORDER = GL_REPLICATE_BORDER
    self.GL_CONVOLUTION_BORDER_COLOR = GL_CONVOLUTION_BORDER_COLOR
    self.GL_COLOR_MATRIX = GL_COLOR_MATRIX
    self.GL_COLOR_MATRIX_STACK_DEPTH = GL_COLOR_MATRIX_STACK_DEPTH
    self.GL_MAX_COLOR_MATRIX_STACK_DEPTH = GL_MAX_COLOR_MATRIX_STACK_DEPTH
    self.GL_POST_COLOR_MATRIX_RED_SCALE = GL_POST_COLOR_MATRIX_RED_SCALE
    self.GL_POST_COLOR_MATRIX_GREEN_SCALE = GL_POST_COLOR_MATRIX_GREEN_SCALE
    self.GL_POST_COLOR_MATRIX_BLUE_SCALE = GL_POST_COLOR_MATRIX_BLUE_SCALE
    self.GL_POST_COLOR_MATRIX_ALPHA_SCALE = GL_POST_COLOR_MATRIX_ALPHA_SCALE
    self.GL_POST_COLOR_MATRIX_RED_BIAS = GL_POST_COLOR_MATRIX_RED_BIAS
    self.GL_POST_COLOR_MATRIX_GREEN_BIAS = GL_POST_COLOR_MATRIX_GREEN_BIAS
    self.GL_POST_COLOR_MATRIX_BLUE_BIAS = GL_POST_COLOR_MATRIX_BLUE_BIAS
    self.GL_POST_COLOR_MATRIX_ALPHA_BIAS = GL_POST_COLOR_MATRIX_ALPHA_BIAS
    self.GL_HISTOGRAM = GL_HISTOGRAM
    self.GL_PROXY_HISTOGRAM = GL_PROXY_HISTOGRAM
    self.GL_HISTOGRAM_WIDTH = GL_HISTOGRAM_WIDTH
    self.GL_HISTOGRAM_FORMAT = GL_HISTOGRAM_FORMAT
    self.GL_HISTOGRAM_RED_SIZE = GL_HISTOGRAM_RED_SIZE
    self.GL_HISTOGRAM_GREEN_SIZE = GL_HISTOGRAM_GREEN_SIZE
    self.GL_HISTOGRAM_BLUE_SIZE = GL_HISTOGRAM_BLUE_SIZE
    self.GL_HISTOGRAM_ALPHA_SIZE = GL_HISTOGRAM_ALPHA_SIZE
    self.GL_HISTOGRAM_LUMINANCE_SIZE = GL_HISTOGRAM_LUMINANCE_SIZE
    self.GL_HISTOGRAM_SINK = GL_HISTOGRAM_SINK
    self.GL_MINMAX = GL_MINMAX
    self.GL_MINMAX_FORMAT = GL_MINMAX_FORMAT
    self.GL_MINMAX_SINK = GL_MINMAX_SINK
    self.GL_TABLE_TOO_LARGE = GL_TABLE_TOO_LARGE
    self.GL_BLEND_EQUATION = GL_BLEND_EQUATION
    self.GL_MIN = GL_MIN
    self.GL_MAX = GL_MAX
    self.GL_FUNC_ADD = GL_FUNC_ADD
    self.GL_FUNC_SUBTRACT = GL_FUNC_SUBTRACT
    self.GL_FUNC_REVERSE_SUBTRACT = GL_FUNC_REVERSE_SUBTRACT
    self.GL_BLEND_COLOR = GL_BLEND_COLOR
    self.GL_TEXTURE0 = GL_TEXTURE0
    self.GL_TEXTURE1 = GL_TEXTURE1
    self.GL_TEXTURE2 = GL_TEXTURE2
    self.GL_TEXTURE3 = GL_TEXTURE3
    self.GL_TEXTURE4 = GL_TEXTURE4
    self.GL_ACTIVE_TEXTURE = GL_ACTIVE_TEXTURE
    self.GL_CLIENT_ACTIVE_TEXTURE = GL_CLIENT_ACTIVE_TEXTURE
    self.GL_MAX_TEXTURE_UNITS = GL_MAX_TEXTURE_UNITS
    self.GL_NORMAL_MAP = GL_NORMAL_MAP
    self.GL_REFLECTION_MAP = GL_REFLECTION_MAP
    self.GL_TEXTURE_CUBE_MAP = GL_TEXTURE_CUBE_MAP
    self.GL_TEXTURE_BINDING_CUBE_MAP = GL_TEXTURE_BINDING_CUBE_MAP
    self.GL_TEXTURE_CUBE_MAP_POSITIVE_X = GL_TEXTURE_CUBE_MAP_POSITIVE_X
    self.GL_TEXTURE_CUBE_MAP_NEGATIVE_X = GL_TEXTURE_CUBE_MAP_NEGATIVE_X
    self.GL_TEXTURE_CUBE_MAP_POSITIVE_Y = GL_TEXTURE_CUBE_MAP_POSITIVE_Y
    self.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
    self.GL_TEXTURE_CUBE_MAP_POSITIVE_Z = GL_TEXTURE_CUBE_MAP_POSITIVE_Z
    self.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
    self.GL_PROXY_TEXTURE_CUBE_MAP = GL_PROXY_TEXTURE_CUBE_MAP
    self.GL_MAX_CUBE_MAP_TEXTURE_SIZE = GL_MAX_CUBE_MAP_TEXTURE_SIZE
    self.GL_COMPRESSED_ALPHA = GL_COMPRESSED_ALPHA
    self.GL_COMPRESSED_LUMINANCE = GL_COMPRESSED_LUMINANCE
    self.GL_COMPRESSED_LUMINANCE_ALPHA = GL_COMPRESSED_LUMINANCE_ALPHA
    self.GL_COMPRESSED_INTENSITY = GL_COMPRESSED_INTENSITY
    self.GL_COMPRESSED_RGB = GL_COMPRESSED_RGB
    self.GL_COMPRESSED_RGBA = GL_COMPRESSED_RGBA
    self.GL_TEXTURE_COMPRESSION_HINT = GL_TEXTURE_COMPRESSION_HINT
    self.GL_TEXTURE_COMPRESSED_IMAGE_SIZE = GL_TEXTURE_COMPRESSED_IMAGE_SIZE
    self.GL_TEXTURE_COMPRESSED = GL_TEXTURE_COMPRESSED
    self.GL_NUM_COMPRESSED_TEXTURE_FORMATS = GL_NUM_COMPRESSED_TEXTURE_FORMATS
    self.GL_COMPRESSED_TEXTURE_FORMATS = GL_COMPRESSED_TEXTURE_FORMATS
    self.GL_MULTISAMPLE = GL_MULTISAMPLE
    self.GL_SAMPLE_ALPHA_TO_COVERAGE = GL_SAMPLE_ALPHA_TO_COVERAGE
    self.GL_SAMPLE_ALPHA_TO_ONE = GL_SAMPLE_ALPHA_TO_ONE
    self.GL_SAMPLE_COVERAGE = GL_SAMPLE_COVERAGE
    self.GL_SAMPLE_BUFFERS = GL_SAMPLE_BUFFERS
    self.GL_SAMPLES = GL_SAMPLES
    self.GL_SAMPLE_COVERAGE_VALUE = GL_SAMPLE_COVERAGE_VALUE
    self.GL_SAMPLE_COVERAGE_INVERT = GL_SAMPLE_COVERAGE_INVERT
    self.GL_MULTISAMPLE_BIT = GL_MULTISAMPLE_BIT
    self.GL_TRANSPOSE_MODELVIEW_MATRIX = GL_TRANSPOSE_MODELVIEW_MATRIX
    self.GL_TRANSPOSE_PROJECTION_MATRIX = GL_TRANSPOSE_PROJECTION_MATRIX
    self.GL_TRANSPOSE_TEXTURE_MATRIX = GL_TRANSPOSE_TEXTURE_MATRIX
    self.GL_TRANSPOSE_COLOR_MATRIX = GL_TRANSPOSE_COLOR_MATRIX
    self.GL_COMBINE = GL_COMBINE
    self.GL_COMBINE_RGB = GL_COMBINE_RGB
    self.GL_COMBINE_ALPHA = GL_COMBINE_ALPHA
    self.GL_SOURCE0_RGB = GL_SOURCE0_RGB
    self.GL_SOURCE1_RGB = GL_SOURCE1_RGB
    self.GL_SOURCE2_RGB = GL_SOURCE2_RGB
    self.GL_SOURCE0_ALPHA = GL_SOURCE0_ALPHA
    self.GL_SOURCE1_ALPHA = GL_SOURCE1_ALPHA
    self.GL_SOURCE2_ALPHA = GL_SOURCE2_ALPHA
    self.GL_OPERAND0_RGB = GL_OPERAND0_RGB
    self.GL_OPERAND1_RGB = GL_OPERAND1_RGB
    self.GL_OPERAND2_RGB = GL_OPERAND2_RGB
    self.GL_OPERAND0_ALPHA = GL_OPERAND0_ALPHA
    self.GL_OPERAND1_ALPHA = GL_OPERAND1_ALPHA
    self.GL_OPERAND2_ALPHA = GL_OPERAND2_ALPHA
    self.GL_RGB_SCALE = GL_RGB_SCALE
    self.GL_ADD_SIGNED = GL_ADD_SIGNED
    self.GL_INTERPOLATE = GL_INTERPOLATE
    self.GL_SUBTRACT = GL_SUBTRACT
    self.GL_CONSTANT = GL_CONSTANT
    self.GL_PRIMARY_COLOR = GL_PRIMARY_COLOR
    self.GL_PREVIOUS = GL_PREVIOUS
    self.GL_DOT3_RGB = GL_DOT3_RGB
    self.GL_DOT3_RGBA = GL_DOT3_RGBA
    self.GL_CLAMP_TO_BORDER = GL_CLAMP_TO_BORDER
    
  def glClearColor(self, float arg1, float arg2, float arg3, float arg4):
    glClearColor(arg1, arg2, arg3, arg4)
    
  def glPointSize(self, float arg):
    glPointSize(arg)

  def glLineWidth(self, float arg):
    glLineWidth(arg)

  def glEnable(self, int arg):
    glEnable(arg)

  def glDisable(self, int arg):
    glDisable(arg)

  def glLightModeli(self, int arg1, int arg2):
    glLightModeli(arg1, arg2)
    
    
  def glGetIntegerViewport(self):
    cdef int[4] viewport
    glGetIntegerv(GL_VIEWPORT, viewport)
    return viewport[0], viewport[1], viewport[2], viewport[3]
  
  def glRotatef(self, float angle,float x,float y,float z):
    glRotatef(angle,x,y,z)

  def glPushMatrix(self):
    glPushMatrix()

  def glPopMatrix(self):
    glPopMatrix()

  def glTranslatef(self, float x,float y,float z):
    glTranslatef(x,y,z)

  def glTranslated(self, float x,float y,float z):
    glTranslated(x,y,z)

  def glScalef(self, float x,float y,float z):
    glScalef(x,y,z)

  def glGenTextures(self, int n):
    cdef GLuint ret
    glGenTextures(n,&ret)
    return ret

  def glBindTexture(self, int target, unsigned int texture):
    glBindTexture(target,texture)

  def glPixelStorei(self, int pname, int param):
    glPixelStorei(pname,param)

  def glLoadIdentity(self):
    glLoadIdentity()

  def glAccum(self, int value, float coef):
    glAccum(value, coef)

  def glMatrixMode(self, int mode):
    glMatrixMode(mode)
    
  def glTexParameteri(self, int target, int param, int value):
    glTexParameteri(target, param, value)
    
  def glPolygonOffset(self, float factor, float units):
    glPolygonOffset(factor, units)
    
  def glOrtho(self, float x1, float x2, float y1, float y2, float z1, float z2):
    glOrtho(x1, x2, y1, y2, z1, z2)
    
  def glViewport(self, int x, int y, int width, int height):
    glViewport(x, y, width, height)
    
    
  #cdef GLuint _face_buffer, _vertex_buffer
  #cdef short* _faces
  #cdef float* _vertices
  cdef float  _current_normal  [3]
  cdef float  _current_texcoord[2]
  cdef float  _current_color   [4]
  cdef int    _has_normal, _has_texcoord, _has_color
  #cdef int    _nb_faces, _nb_vertices
  cdef int    _face_i, _vertex_i, _current_face_type
  
  def __init__(self):
    global _opengl
    self._current_face_type = 0
    self._init_consts()
    _opengl = self
    
#  cdef void _init_gl(self):
#    "OPENGL INITED GL"
    #self._face_buffer   = _tmp_face_buffer
    #self._faces         = _tmp_faces
    #self._vertex_buffer = _tmp_vertex_buffer
    #self._vertices      = _tmp_vertices
    #self._nb_faces      = 192
    #self._nb_vertices   = 192
    
  def glBegin(self, int face_type):
    self._current_face_type = face_type
    self._has_normal = self._has_texcoord = self._has_color = 0
    self._face_i = self._vertex_i = 0
    
  def glEnd(self):
    self._render_buffer()
    self._current_face_type = 0
    
  def glNormal3f(self, float x, float y, float z):
    self._has_normal        = 1
    self._current_normal[0] = x
    self._current_normal[1] = y
    self._current_normal[2] = z
    
  def glTexCoord2f(self, float u, float v):
    self._has_texcoord = 1
    self._current_texcoord[0] = u
    self._current_texcoord[1] = v
    
  def glColor4f(self, float r, float g, float b, float a):
    self._has_color = 1
    self._current_color[0] = r
    self._current_color[1] = g
    self._current_color[2] = b
    self._current_color[3] = a
    
    if self._current_face_type == 0: glColor4f(r, g, b, a)
    
  def glVertex3f(self, float x, float y, float z = 0.0):
    _tmp_vertices[12 * self._vertex_i    ] = x
    _tmp_vertices[12 * self._vertex_i + 1] = y
    _tmp_vertices[12 * self._vertex_i + 2] = z
    self._gl_vertex()
    
  cdef void _gl_vertex(self):
    memcpy(_tmp_vertices + 12 * self._vertex_i + 3, self._current_normal  , 3 * sizeof(float))
    memcpy(_tmp_vertices + 12 * self._vertex_i + 6, self._current_texcoord, 2 * sizeof(float))
    memcpy(_tmp_vertices + 12 * self._vertex_i + 8, self._current_color   , 4 * sizeof(float))
    
    if self._current_face_type == GL_QUADS:
      if self._vertex_i % 4 != 3:
        _tmp_faces[self._face_i] = self._vertex_i
        self._face_i = self._face_i + 1
      else:
        _tmp_faces[self._face_i    ] = self._vertex_i - 1
        _tmp_faces[self._face_i + 1] = self._vertex_i
        _tmp_faces[self._face_i + 2] = self._vertex_i - 3
        self._face_i = self._face_i + 3
        
    self._vertex_i = self._vertex_i + 1
    if (self._vertex_i >= 192) or (self._face_i >= 192): self._render()
    
  def _render_buffer(self):
    glBindBuffer(GL_ARRAY_BUFFER, _tmp_vertex_buffer)
    glBufferSubData(GL_ARRAY_BUFFER, 0, self._vertex_i * 12 * sizeof(float), _tmp_vertices)
    glEnableClientState(GL_VERTEX_ARRAY)
    glVertexPointer(3, GL_FLOAT, 12 * sizeof(float), BUFFER_OFFSET(0))
    
    if self._has_normal:
      glEnableClientState(GL_NORMAL_ARRAY)
      glNormalPointer(GL_FLOAT, 12 * sizeof(float), BUFFER_OFFSET(3 * sizeof(float)))
      
    if self._has_texcoord:
      glEnableClientState(GL_TEXTURE_COORD_ARRAY)
      glTexCoordPointer(2, GL_FLOAT, 12 * sizeof(float), BUFFER_OFFSET(6 * sizeof(float)))
      
    if self._has_color:
      glEnableClientState(GL_COLOR_ARRAY)
      glColorPointer(4, GL_FLOAT, 12 * sizeof(float), BUFFER_OFFSET(8 * sizeof(float)))
    else:
      glColor4fv(self._current_color)
      
    if self._current_face_type != GL_QUADS:
      glDrawArrays(self._current_face_type, 0, self._vertex_i)
    else:
      glBindBuffer   (GL_ELEMENT_ARRAY_BUFFER, _tmp_face_buffer)
      glBufferSubData(GL_ELEMENT_ARRAY_BUFFER, 0, self._face_i * sizeof(short), _tmp_faces)
      glDrawElements (GL_TRIANGLES, self._face_i, GL_UNSIGNED_SHORT, BUFFER_OFFSET(0))
      
    glDisableClientState(GL_VERTEX_ARRAY)
    if self._has_normal:   glDisableClientState(GL_NORMAL_ARRAY)
    if self._has_texcoord: glDisableClientState(GL_TEXTURE_COORD_ARRAY)
    if self._has_color:    glDisableClientState(GL_COLOR_ARRAY)
    glBindBuffer(GL_ARRAY_BUFFER, 0)
    if self._current_face_type == GL_QUADS: glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0)
    
    self._face_i = self._vertex_i = 0
    self._has_normal = self._has_texcoord = self._has_color = 0



class OpenGL(_OpenGL): pass
