# -*- coding: utf-8 -*-

# Soya 3D
# Copyright (C) 2001-2014 Jean-Baptiste LAMY
# http://www.lesfleursdunormal.fr/static/informatique/soya3d/index_en.html

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

cdef float _SPRITE_MATRIX[16]
_SPRITE_MATRIX[0] = _SPRITE_MATRIX[5] = _SPRITE_MATRIX[10] = _SPRITE_MATRIX[15] = 1.0
_SPRITE_MATRIX[1] = _SPRITE_MATRIX[2] = _SPRITE_MATRIX[3] = _SPRITE_MATRIX[4] = _SPRITE_MATRIX[6] = _SPRITE_MATRIX[7] = _SPRITE_MATRIX[8] = _SPRITE_MATRIX[9] = _SPRITE_MATRIX[11] = _SPRITE_MATRIX[12] = _SPRITE_MATRIX[13] = _SPRITE_MATRIX[14] = 0.0
cdef float _CYLINDER_SPRITE_MATRIX[16]
_CYLINDER_SPRITE_MATRIX[0] = _CYLINDER_SPRITE_MATRIX[5] = _CYLINDER_SPRITE_MATRIX[10] = _CYLINDER_SPRITE_MATRIX[15] = 1.0
_CYLINDER_SPRITE_MATRIX[1] = _CYLINDER_SPRITE_MATRIX[2] = _CYLINDER_SPRITE_MATRIX[3] = _CYLINDER_SPRITE_MATRIX[4] = _CYLINDER_SPRITE_MATRIX[6] = _CYLINDER_SPRITE_MATRIX[7] = _CYLINDER_SPRITE_MATRIX[8] = _CYLINDER_SPRITE_MATRIX[9] = _CYLINDER_SPRITE_MATRIX[11] = _CYLINDER_SPRITE_MATRIX[12] = _CYLINDER_SPRITE_MATRIX[13] = _CYLINDER_SPRITE_MATRIX[14] = 0.0

cdef class _Sprite(CoordSyst):
  #cdef float _width, _height
  #cdef float _color[4]
  #cdef _Material _material
  #cdef _Program  _program
  
  property width:
    def __get__(self):
      return self._width
    def __set__(self, float x):
      self._width = x
  
  property height:
    def __get__(self):
      return self._height
    def __set__(self, float x):
      self._height = x
  
  property color:
    def __get__(self):
      return self._color[0], self._color[1], self._color[2], self._color[3]
    def __set__(self, x):
      self._color[0], self._color[1], self._color[2], self._color[3] = x
  
  property material:
    def __get__(self):
      return self._material
    def __set__(self, _Material x not None):
      self._material = x
      
  property lit:
    def __get__(self):
      return not(self._option & SPRITE_NEVER_LIT)
    def __set__(self, int x):
      if x: self._option = self._option & ~SPRITE_NEVER_LIT
      else: self._option = self._option |  SPRITE_NEVER_LIT
      
  def __init__(self, _World parent = None, _Material material = None):
    CoordSyst.__init__(self, parent)
    self._material = material or _DEFAULT_MATERIAL
    self._color[0] = self._color[1] = self._color[2] = self._color[3] = 1.0
    self._width = self._height = 0.5
    
  cdef __getcstate__(self):
    cdef Chunk* chunk
    chunk = get_chunk()
    chunk_add_int_endian_safe   (chunk, self._option)
    chunk_add_floats_endian_safe(chunk, self._matrix, 19)
    chunk_add_float_endian_safe (chunk, self._width)
    chunk_add_float_endian_safe (chunk, self._height)
    chunk_add_floats_endian_safe(chunk, self._color, 4)
    return drop_chunk_to_string(chunk), self._material, self._mini_shaders
  
  cdef void __setcstate__(self, cstate):
    self._validity = COORDSYST_INVALID
    
    cdef Chunk* chunk
    cstate2, self._material, self._mini_shaders = cstate
    chunk = string_to_chunk(cstate2)
    chunk_get_int_endian_safe   (chunk, &self._option)
    chunk_get_floats_endian_safe(chunk,  self._matrix, 19)
    chunk_get_float_endian_safe (chunk, &self._width)
    chunk_get_float_endian_safe (chunk, &self._height)
    chunk_get_floats_endian_safe(chunk,  self._color, 4)
    drop_chunk(chunk)
    
  cdef void _invalidate_shaders(self):
    self._program = None
    
  cdef void _batch(self, CoordSyst coordsyst):
    cdef list      mini_shaders
    cdef CoordSyst ancestor
    
    if self._option & HIDDEN: return
    if self._option & SPRITE_RECEIVE_SHADOW:
      if self.option & SPRITE_ALPHA: renderer._batch(renderer.alpha,    self, None, NULL)
      else:                          renderer._batch(renderer.opaque,   self, None, NULL)
    else:                            renderer._batch(renderer.specials, self, None, NULL)
    
    if self._program is None:
      mini_shaders = self._material._mini_shaders[:]
      ancestor     = self
      while ancestor:
        for mini_shader in ancestor._mini_shaders: mini_shaders.insert(0, mini_shader)
        ancestor = ancestor._parent
      self._program = mini_shaders_2_program(mini_shaders)
      
  cdef void _render(self, CoordSyst coordsyst):
    global _tmp_face_buffer, _tmp_vertex_buffer, _tmp_faces, _tmp_vertices
    cdef float* a
    cdef float* b
    # compute render matrix
    b = self._parent._render_matrix
    a = &self._matrix[12]
    _SPRITE_MATRIX[12] = a[0] * b[0] + a[1] * b[4] + a[2] * b[ 8] + b[12]
    _SPRITE_MATRIX[13] = a[0] * b[1] + a[1] * b[5] + a[2] * b[ 9] + b[13]
    _SPRITE_MATRIX[14] = a[0] * b[2] + a[1] * b[6] + a[2] * b[10] + b[14]
    self._material._activate()
    glLoadMatrixf(_SPRITE_MATRIX)
    glDisable(GL_CULL_FACE)
    if self._option & SPRITE_NEVER_LIT: glDisable(GL_LIGHTING)
    else:
      glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE)
      glNormal3f(0.0, 0.0, -1.0)
    glColor4fv(self._color)
    
    glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, _tmp_face_buffer)
    glBindBuffer(GL_ARRAY_BUFFER        , _tmp_vertex_buffer)
    glEnableClientState(GL_VERTEX_ARRAY)
    glEnableClientState(GL_TEXTURE_COORD_ARRAY)
    glVertexPointer  (3, GL_FLOAT, 0, BUFFER_OFFSET(0))
    glTexCoordPointer(2, GL_FLOAT, 0, BUFFER_OFFSET(12 * sizeof(float)))
    
    self._program._activate()
    self._program._set_all_user_params(self._parent, self._mini_shaders, self._material._mini_shaders)
    
    _tmp_vertices[ 0] = -self._width
    _tmp_vertices[ 1] = -self._height
    _tmp_vertices[ 2] =  0.0
    _tmp_vertices[ 3] =  self._width
    _tmp_vertices[ 4] = -self._height
    _tmp_vertices[ 5] =  0.0
    _tmp_vertices[ 6] =  self._width
    _tmp_vertices[ 7] =  self._height
    _tmp_vertices[ 8] =  0.0
    _tmp_vertices[ 9] = -self._width
    _tmp_vertices[10] =  self._height
    _tmp_vertices[11] =  0.0
    
    _tmp_vertices[12] =  0.0
    _tmp_vertices[13] =  0.0
    _tmp_vertices[14] =  1.0
    _tmp_vertices[15] =  0.0
    _tmp_vertices[16] =  1.0
    _tmp_vertices[17] =  1.0
    _tmp_vertices[18] =  0.0
    _tmp_vertices[19] =  1.0
    
    _tmp_faces[0] = 0
    _tmp_faces[1] = 1
    _tmp_faces[2] = 2
    _tmp_faces[3] = 2
    _tmp_faces[4] = 3
    _tmp_faces[5] = 0
    
    glBufferSubData(GL_ARRAY_BUFFER        , 0, 4 * (3 + 2) * sizeof(float), _tmp_vertices)
    glBufferSubData(GL_ELEMENT_ARRAY_BUFFER, 0, 6           * sizeof(short), _tmp_faces)
    glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_SHORT, BUFFER_OFFSET(0))
    
    glDisableClientState(GL_VERTEX_ARRAY)
    glDisableClientState(GL_TEXTURE_COORD_ARRAY)
    glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0)
    glBindBuffer(GL_ARRAY_BUFFER        , 0)
    
    #glBegin(GL_QUADS)
    #glTexCoord2f(0.0, 0.0); glVertex3f(- self._width, - self._height, 0.0)
    #glTexCoord2f(1.0, 0.0); glVertex3f(  self._width, - self._height, 0.0)
    #glTexCoord2f(1.0, 1.0); glVertex3f(  self._width,   self._height, 0.0)
    #glTexCoord2f(0.0, 1.0); glVertex3f(- self._width,   self._height, 0.0)
    #glEnd()
    
    glEnable(GL_CULL_FACE)
    if self._option & SPRITE_NEVER_LIT: glEnable(GL_LIGHTING)
    else: glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)
    
  cdef void _compute_alpha(self):
    if self._material._option & (MATERIAL_ALPHA | MATERIAL_MASK):
      self._option = self._option | SPRITE_ALPHA
      return
    if self._color[3] < 1.0:
      self._option = self._option | SPRITE_ALPHA
      return
    self._option = self._option & ~SPRITE_ALPHA
    
    
cdef class _CylinderSprite(_Sprite):
  cdef __getcstate__(self):
    cdef Chunk* chunk
    chunk = get_chunk()
    chunk_add_int_endian_safe   (chunk, self._option)
    chunk_add_floats_endian_safe(chunk, self._matrix, 19)
    chunk_add_float_endian_safe (chunk, self._width)
    chunk_add_float_endian_safe (chunk, self._height)
    chunk_add_floats_endian_safe(chunk, self._color, 4)
    return drop_chunk_to_string(chunk), self._material, self._mini_shaders
  
  cdef void __setcstate__(self, cstate):
    self._validity = COORDSYST_INVALID
    
    cdef Chunk* chunk
    cstate2, self._material, self._mini_shaders = cstate
    chunk = string_to_chunk(cstate2)
    chunk_get_int_endian_safe   (chunk, &self._option)
    chunk_get_floats_endian_safe(chunk,  self._matrix, 19)
    chunk_get_float_endian_safe (chunk, &self._width)
    chunk_get_float_endian_safe (chunk, &self._height)
    chunk_get_floats_endian_safe(chunk,  self._color, 4)
    drop_chunk(chunk)
    
  cdef void _render(self, CoordSyst coordsyst):
    cdef float  x, y, f
    cdef float* a
    cdef float* m
    # compute render matrix
    m = self._parent._render_matrix
    a = &self._matrix[8]
    _CYLINDER_SPRITE_MATRIX[ 8] = a[0] * m[0] + a[1] * m[4] + a[2] * m[ 8]
    _CYLINDER_SPRITE_MATRIX[ 9] = a[0] * m[1] + a[1] * m[5] + a[2] * m[ 9]
    _CYLINDER_SPRITE_MATRIX[10] = a[0] * m[2] + a[1] * m[6] + a[2] * m[10]
    a = &self._matrix[12]
    _CYLINDER_SPRITE_MATRIX[12] = a[0] * m[0] + a[1] * m[4] + a[2] * m[ 8] + m[12]
    _CYLINDER_SPRITE_MATRIX[13] = a[0] * m[1] + a[1] * m[5] + a[2] * m[ 9] + m[13]
    _CYLINDER_SPRITE_MATRIX[14] = a[0] * m[2] + a[1] * m[6] + a[2] * m[10] + m[14]
    if _CYLINDER_SPRITE_MATRIX[10] == 0.0:
      x = _CYLINDER_SPRITE_MATRIX[8]
      y = _CYLINDER_SPRITE_MATRIX[9]
    else:
      f = _CYLINDER_SPRITE_MATRIX[14] / _CYLINDER_SPRITE_MATRIX[10]
      x = _CYLINDER_SPRITE_MATRIX[12] - f * _CYLINDER_SPRITE_MATRIX[8]
      y = _CYLINDER_SPRITE_MATRIX[13] - f * _CYLINDER_SPRITE_MATRIX[9]
      # sign of x, y ?
    if (x == 0.0) and (y == 0.0):
      _CYLINDER_SPRITE_MATRIX[4] = 0.0
      _CYLINDER_SPRITE_MATRIX[5] = 1.0
    else:
      f = <float> (1.0 / sqrt(x * x + y * y))
      _CYLINDER_SPRITE_MATRIX[5] = -x * f
      _CYLINDER_SPRITE_MATRIX[4] =  y * f
    _CYLINDER_SPRITE_MATRIX[0] =  _CYLINDER_SPRITE_MATRIX[5] * _CYLINDER_SPRITE_MATRIX[10] - _CYLINDER_SPRITE_MATRIX[6] * _CYLINDER_SPRITE_MATRIX[9]
    _CYLINDER_SPRITE_MATRIX[1] = -_CYLINDER_SPRITE_MATRIX[4] * _CYLINDER_SPRITE_MATRIX[10] + _CYLINDER_SPRITE_MATRIX[6] * _CYLINDER_SPRITE_MATRIX[8]
    _CYLINDER_SPRITE_MATRIX[2] =  _CYLINDER_SPRITE_MATRIX[4] * _CYLINDER_SPRITE_MATRIX[ 9] - _CYLINDER_SPRITE_MATRIX[5] * _CYLINDER_SPRITE_MATRIX[8]
    # render
    self._material._activate()
    glLoadMatrixf(_CYLINDER_SPRITE_MATRIX)
    glDisable(GL_CULL_FACE)
    if self._option & SPRITE_NEVER_LIT: glDisable(GL_LIGHTING)
    else:
      glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE)
      glNormal3f(1.0, 0.0, 0.0)
    glColor4fv(self._color)
    
    
    glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, _tmp_face_buffer)
    glBindBuffer(GL_ARRAY_BUFFER        , _tmp_vertex_buffer)
    glEnableClientState(GL_VERTEX_ARRAY)
    glEnableClientState(GL_TEXTURE_COORD_ARRAY)
    glVertexPointer  (3, GL_FLOAT, 0, BUFFER_OFFSET(0))
    glTexCoordPointer(2, GL_FLOAT, 0, BUFFER_OFFSET(12 * sizeof(float)))
    
    self._program._activate()
    self._program._set_all_user_params(self._parent, self._mini_shaders, self._material._mini_shaders)
    
    _tmp_vertices[ 0] =  0.0
    _tmp_vertices[ 1] = -self._height
    _tmp_vertices[ 2] = -self._width
    _tmp_vertices[ 3] =  0.0
    _tmp_vertices[ 4] =  self._height
    _tmp_vertices[ 5] = -self._width
    _tmp_vertices[ 6] =  0.0
    _tmp_vertices[ 7] =  self._height
    _tmp_vertices[ 8] =  self._width
    _tmp_vertices[ 9] =  0.0
    _tmp_vertices[10] = -self._height
    _tmp_vertices[11] =  self._width
    
    _tmp_vertices[12] =  0.0
    _tmp_vertices[13] =  0.0
    _tmp_vertices[14] =  1.0
    _tmp_vertices[15] =  0.0
    _tmp_vertices[16] =  1.0
    _tmp_vertices[17] =  1.0
    _tmp_vertices[18] =  0.0
    _tmp_vertices[19] =  1.0
    
    _tmp_faces[0] = 0
    _tmp_faces[1] = 1
    _tmp_faces[2] = 2
    _tmp_faces[3] = 2
    _tmp_faces[4] = 3
    _tmp_faces[5] = 0
    
    glBufferSubData(GL_ARRAY_BUFFER        , 0, 4 * (3 + 2) * sizeof(float), _tmp_vertices)
    glBufferSubData(GL_ELEMENT_ARRAY_BUFFER, 0, 6           * sizeof(short), _tmp_faces)
    glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_SHORT, BUFFER_OFFSET(0))
    
    glDisableClientState(GL_VERTEX_ARRAY)
    glDisableClientState(GL_TEXTURE_COORD_ARRAY)
    glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0)
    glBindBuffer(GL_ARRAY_BUFFER        , 0)

    #glBegin(GL_QUADS)
    #glTexCoord2f(0.0, 0.0); glVertex3f(0.0, - self._height, - self._width)
    #glTexCoord2f(1.0, 0.0); glVertex3f(0.0,   self._height, - self._width)
    #glTexCoord2f(1.0, 1.0); glVertex3f(0.0,   self._height,   self._width)
    #glTexCoord2f(0.0, 1.0); glVertex3f(0.0, - self._height,   self._width)
    #glEnd()
    
    
    glEnable(GL_CULL_FACE)
    if self._option & SPRITE_NEVER_LIT: glEnable(GL_LIGHTING)
    else: glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE)

