# Copyright (C) 2014 Daniel Lee <lee.daniel.1986@gmail.com>
#
# This file is part of StereoVision.
#
# StereoVision is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# StereoVision is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with StereoVision.  If not, see <http://www.gnu.org/licenses/>.

"""
Utilities for 3d reconstruction using stereo cameras.

Modules:

    * ``stereo_cameras`` - Camera interfaces
    * ``calibration`` - Tools for calibrating stereo cameras
    * ``blockmatchers`` - Blockmatching algorithm matchers
    * ``point_cloud`` - Point clouds
    * ``ui_utils`` - Utilities for user interaction
    * ``exceptions`` - Various exceptions

Import structure:

.. image:: packages_StereoVision.svg
    :width: 100%

Camera interfaces
*****************

.. automodule:: stereovision.stereo_cameras

Camera calibration
******************

.. automodule:: stereovision.calibration

Block matchers
**************

.. automodule:: stereovision.blockmatchers

Point clouds
************

.. automodule:: stereovision.point_cloud

User interface utilities
************************

.. automodule:: stereovision.ui_utils

Exceptions
**********

.. automodule:: stereovision.exceptions
"""
