import sys
import os
import pygame
from pygame.locals import *

sys.path.append(os.path.abspath('..'))
import stickysticks


# set up the colors
BLACK = (0, 0, 0)
GREEN = (0, 255, 0)
WHITE = (255, 255, 255)

SPEED = 4

# set up pygame
pygame.init()
mainClock = pygame.time.Clock()
displaySurf = pygame.display.set_mode((800, 600))

def getArm():
    arm = [stickysticks.Stick(0, 50, (400, 300))]
    for i in range(4):
        arm.append(stickysticks.Stick(0, 50, (arm[-1], 1.0)))
    return arm

fullArm = getArm()
DEBUG_SET = False


def drawScreen():
    # draw the black background onto the surface
    displaySurf.fill(BLACK)
    isGreen = False
    for stick in fullArm:
        c = GREEN if isGreen else WHITE
        pygame.draw.line(displaySurf, c, stick.start, stick.end)
        isGreen = not isGreen
    pygame.display.update()

mouseDown = False
while True:
    # check for the QUIT event
    for event in pygame.event.get():
        if event.type == MOUSEBUTTONDOWN:
            mouseDown = True
        elif event.type == MOUSEBUTTONUP:
            mouseDown = False
        elif event.type == MOUSEMOTION and mouseDown:
            fullArm[0].start = event.pos
        elif event.type == QUIT:
            pygame.quit()
            sys.exit()

    keyStates = pygame.key.get_pressed()
    if keyStates[ord('q')]:
        fullArm[0].rotate(-SPEED)
    if keyStates[ord('a')]:
        fullArm[0].rotate(SPEED)
    if keyStates[ord('w')]:
        fullArm[1].rotate(-SPEED)
    if keyStates[ord('s')]:
        fullArm[1].rotate(SPEED)
    if keyStates[ord('e')]:
        fullArm[2].rotate(-SPEED)
    if keyStates[ord('d')]:
        fullArm[2].rotate(SPEED)
    if keyStates[ord('r')]:
        fullArm[3].rotate(-SPEED)
    if keyStates[ord('f')]:
        fullArm[3].rotate(SPEED)
    if keyStates[ord('t')]:
        fullArm[4].rotate(-SPEED)
    if keyStates[ord('g')]:
        fullArm[4].rotate(SPEED)

    if keyStates[ord('z')]:
        fullArm[0].length += SPEED
    if keyStates[ord('x')]:
        fullArm[1].length += SPEED
    if keyStates[ord('c')]:
        fullArm[2].length += SPEED
    if keyStates[ord('v')]:
        fullArm[3].length += SPEED
    if keyStates[ord('b')]:
        fullArm[4].length += SPEED

    if keyStates[K_ESCAPE]:
        pygame.quit()
        sys.exit()
    if keyStates[K_BACKSPACE]:
        # reset the sticks
        fullArm = getArm()

    """
    if not DEBUG_SET and keyStates[ord('z')]:
        mainClock.tick(1)

        for i in range(4):
            fullArm[0].rotate(45) # TODO - figure out what's causing this double rotation.
            drawScreen()
            mainClock.tick(1)

        #fullArm[1].rotate(90)
        #drawScreen()
        #mainClock.tick(1)

        #fullArm[0].rotate(-90)
        #drawScreen()
        #mainClock.tick(1)

        DEBUG_SET = True
    """
    drawScreen()
    mainClock.tick(60)
