# StickyStick is a very limited 2D skeletal stick-and-joint system in Python.
# If you need 2D line segments that can be attached to each other and rotated as a system at any joint, this is the module for you.

# Al Sweigart al@inventwithpython.com
# BSD License

# THIS MODULE IS STILL UNDER DEVELOPMENT AND NOT SUITABLE FOR USE YET.

import math

__version__ = '0.1.1'
DEGREES_PER_RADIAN = math.pi / 180

class Stick(object):
    def __init__(self, degreesRotation=0.0, length=100, root=(0, 0)):
        """ TODO
        root can either be (x, y) or (Stick, 0.5)
        """
        self._length = length
        self._rotation = degreesRotation

        self._children = []

        assert len(root) == 2

        self.isRoot = type(root[0]) in (int, float) and type(root[1]) in (int, float)

        if self.isRoot:
            self._start = root
            self._parent = None
            self._attachPoint = None
        else:
            self._start = None
            self.connectTo(root[0], root[1])
        self._end = None

        self.recalculate()


    def recalculate(self):
        if not self.isRoot:
            self._start = getEndPoint(self._parent._start, self._parent._getAncestorRotationSum(), self._attachPoint * self._parent._length)
        self._end = getEndPoint(self._start, self._getAncestorRotationSum(), self._length)

        for childStick in self._children:
            childStick.recalculate()


    def connectTo(self, parent, attachPoint):
        assert 0.0 <= attachPoint <= 1.0
        self._parent = parent
        self._attachPoint = attachPoint
        self._parent._children.append(self)


    def __str__(self):
        return '%s-%s rot:%s len:%s' % (self._start, self._end, self._rotation, self._length)

    def __repr__(self):
        return '<' + str(self) + '>'

    def _getAncestorRotationSum(self):
        if self.isRoot:
            return self._rotation
        else:
            return self._parent._getAncestorRotationSum() + self._rotation

    def rotate(self, degreesToRotate):
        self.rotation += degreesToRotate

    def _propGetStart(self):
        return self._start
    def _propSetStart(self, value):
        assert len(value) == 2
        assert type(value[0] in (int, float))
        assert type(value[1] in (int, float))
        stick = self
        diffx = value[0] - self._start[0]
        diffy = value[1] - self._start[1]
        while stick.isRoot == False:
            stick = stick._parent
        stick._start = (stick._start[0] + diffx, stick._start[1] + diffy)
        stick.recalculate()

    def _propGetEnd(self):
        return self._end
    def _propSetEnd(self, value):
        assert len(value) == 2
        assert type(value[0] in (int, float))
        assert type(value[1] in (int, float))
        stick = self
        diffx = value[0] - self._end[0]
        diffy = value[1] - self._end[1]
        while stick.isRoot == False:
            stick = stick._parent
        stick._end = (stick._end[0] + diffx, stick._end[1] + diffy)
        stick.recalculate()

    def _propGetLength(self):
        return self._length
    def _propSetLength(self, value):
        assert type(value) in (int, float)
        self._length = value
        self.recalculate()

    def _propGetRotation(self):
        return self._rotation
    def _propSetRotation(self, value):
        # NOTE: This code seems complicated, but it's all here to keep the commutative property. Rounding errors mean that rotatin 45, 45, and -90 will not put you back at your original position. We have to redo all the of the positions from zero each time so that the rounding errors don't build up.
        self._rotation = value
        self.recalculate()

    start       = property(_propGetStart, _propSetStart)
    end         = property(_propGetEnd, _propSetEnd)
    length      = property(_propGetLength, _propSetLength)
    rotation    = property(_propGetRotation, _propSetRotation)




def getEndPoint(start, degreesRotation, length):
    if degreesRotation == 0:
        return (start[0] + length, start[1])
    elif degreesRotation == 90:
        return (start[0], start[1] + length)
    elif degreesRotation == 180:
        return (start[0] - length, start[1])
    elif degreesRotation == 270:
        return (start[0], start[1] - length)
    radiansRotation = degreesRotation * DEGREES_PER_RADIAN
    return (math.cos(radiansRotation) * length + start[0], math.sin(radiansRotation) * length + start[1])

