#! python3.3
import sys
import os
import pygame
import random
from pygame.locals import *

sys.path.append(os.path.abspath('..'))
import stickysticks


# set up pygame
pygame.init()
mainClock = pygame.time.Clock()

# set up the colors
BLACK = (0, 0, 0)
GREEN = (0, 255, 0)
WHITE = (255, 255, 255)

displaySurf = pygame.display.set_mode((800, 600))

rootStick = stickysticks.Stick(x=320, y=340, length=80)
rootStick.v = -2
rootStick.dir = 1

parentSticks = [[rootStick]]

for i in range(5):
    ps = parentSticks.pop()
    for s in ps:
        nextSticks = []
        for j in range(random.randint(2, 5)):
            stickLen = (60 - i * 10) + random.randint(-6, 10)

            newStick = stickysticks.Stick(shoulder=s, length=stickLen, startingTheta=random.randint(1, 360))
            newStick.v = random.randint(-20, 20) / 10.0
            newStick.dir = 1
            nextSticks.append(newStick)
        parentSticks.insert(0, nextSticks)




rootStick.pivot(-180)
while True:
    # check for the QUIT event
    for event in pygame.event.get():
        if event.type == QUIT:
            pygame.quit()
            sys.exit()

    for s in rootStick.getAllDescendents():
        s.pivot(s.v)
        if s.dir == 1:
            s.v += random.randint(0, 2) / 10.0
        else:
            s.v -= random.randint(0, 2) / 10.0
        if s.v >= 2:
            s.dir = -1
        if s.v <= -2:
            s.dir = 1

    #stick1.rotateArms(3)
    #stick2.rotateArms(2)

    # draw the black background onto the surface
    displaySurf.fill(BLACK)
    for line in rootStick.getAllDescendentCoordinates():
        pygame.draw.line(displaySurf, WHITE, line[0], line[1])



    # draw the window onto the screen
    pygame.display.update()
    mainClock.tick(60)
