import unittest
import sys
import os

sys.path.append(os.path.abspath('..'))
import stickysticks

class BasicTests(unittest.TestCase):
    def test_stickDefaults(self):
        st = stickysticks.Stick(0, 100, (0,0))
        self.assertEqual(st.start, (0, 0))
        self.assertEqual(st.end, (100, 0))
        self.assertEqual(st.length, 100)

        st2 = stickysticks.Stick(0, 100, (st, 1.0))
        self.assertEqual(st2.start, (100, 0))
        self.assertEqual(st2.end, (200, 0))
        self.assertEqual(st2.length, 100)

    def test_rotate(self):
        st1 = stickysticks.Stick()
        st2 = stickysticks.Stick(shoulder=st1)
        st3 = stickysticks.Stick(shoulder=st2)

        st1.rotate(90)
        self.assertEqual(st1.start, (0, 0))
        self.assertEqual(st1.end, (0, 100))

        self.assertEqual(st2.start, (0, 100))
        self.assertEqual(st2.end, (0, 200))

        self.assertEqual(st3.start, (0, 200))
        self.assertEqual(st3.end, (0, 300))

        st1.rotate(-90)
        self.assertEqual(st1.start, (0, 0))
        self.assertEqual(st1.end, (100, 0))

        self.assertEqual(st2.start, (100, 0))
        self.assertEqual(st2.end, (200, 0))

        self.assertEqual(st3.start, (200, 0))
        self.assertEqual(st3.end, (300, 0))

        st1.rotate(45)
        roundedEnd = (round(st1.end[0], 5), round(st1.end[1], 5))
        self.assertEqual(st1.start, (0, 0))
        self.assertEqual(roundedEnd, (70.71068, 70.71068))

        st1.rotate(-90)
        roundedEnd = (round(st1.end[0], 5), round(st1.end[1], 5))
        self.assertEqual(st1.start, (0, 0))
        self.assertEqual(roundedEnd, (70.71068, -70.71068))

    def test_rotateCommutative(self):
        st1 = stickysticks.Stick()
        st2 = stickysticks.Stick(shoulder=st1)
        st3 = stickysticks.Stick(shoulder=st2)

        for st1_i in range(5):
            st1.rotate(17) # just rotate it to a weird angle
            for st2_i in range(5):
                st2.rotate(17) # just rotate it to a weird angle

                lastPointStartsAt = st3.end

                st3.rotate(23)
                st3.rotate(31)
                st3.rotate(36)
                st3.rotate(-90) # rotate back to origin orientation

                self.assertEqual((st1_i, st2_i, lastPointStartsAt), (st1_i, st2_i, st3.end))

if __name__ == '__main__':
    unittest.main()
