model = """<?xml version="1.0" encoding="UTF-8"?>
<sbml xmlns="http://www.sbml.org/sbml/level2" level="2" version="1">
  <model id="AutoRegulatoryNetwork" name="Auto-regulatory network">
    <listOfUnitDefinitions>
      <unitDefinition id="substance">
        <listOfUnits>
          <unit kind="item" multiplier="1" offset="0"/>
        </listOfUnits>
      </unitDefinition>
    </listOfUnitDefinitions>
    <listOfCompartments>
      <compartment id="Cell"/>
    </listOfCompartments>
    <listOfSpecies>
      <species id="Gene" compartment="Cell" initialAmount="10" hasOnlySubstanceUnits="true"/>
      <species id="P2Gene" name="P2.Gene" compartment="Cell" initialAmount="0" hasOnlySubstanceUnits="true"/>
      <species id="Rna" compartment="Cell" initialAmount="0" hasOnlySubstanceUnits="true"/>
      <species id="P" compartment="Cell" initialAmount="0" hasOnlySubstanceUnits="true"/>
      <species id="P2" compartment="Cell" initialAmount="0" hasOnlySubstanceUnits="true"/>
    </listOfSpecies>
    <listOfReactions>
      <reaction id="RepressionBinding" name="Repression binding" reversible="false">
        <listOfReactants>
          <speciesReference species="Gene"/>
          <speciesReference species="P2"/>
        </listOfReactants>
        <listOfProducts>
          <speciesReference species="P2Gene"/>
        </listOfProducts>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k1 </ci>
              <ci> Gene </ci>
              <ci> P2 </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k1" value="1"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="ReverseRepressionBinding" name="Reverse repression binding" reversible="false">
        <listOfReactants>
          <speciesReference species="P2Gene"/>
        </listOfReactants>
        <listOfProducts>
          <speciesReference species="Gene"/>
          <speciesReference species="P2"/>
        </listOfProducts>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k1r </ci>
              <ci> P2Gene </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k1r" value="10"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="Transcription" reversible="false">
        <listOfReactants>
          <speciesReference species="Gene"/>
        </listOfReactants>
        <listOfProducts>
          <speciesReference species="Gene"/>
          <speciesReference species="Rna"/>
        </listOfProducts>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k2 </ci>
              <ci> Gene </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k2" value="0.01"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="Translation" reversible="false">
        <listOfReactants>
          <speciesReference species="Rna"/>
        </listOfReactants>
        <listOfProducts>
          <speciesReference species="Rna"/>
          <speciesReference species="P"/>
        </listOfProducts>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k3 </ci>
              <ci> Rna </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k3" value="10"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="Dimerisation" reversible="false">
        <listOfReactants>
          <speciesReference species="P" stoichiometry="2"/>
        </listOfReactants>
        <listOfProducts>
          <speciesReference species="P2"/>
        </listOfProducts>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k4 </ci>
              <cn> 0.5 </cn>
              <ci> P </ci>
              <apply>
                <minus/>
                <ci> P </ci>
                <cn type="integer"> 1 </cn>
              </apply>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k4" value="1"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="Dissociation" reversible="false">
        <listOfReactants>
          <speciesReference species="P2"/>
        </listOfReactants>
        <listOfProducts>
          <speciesReference species="P" stoichiometry="2"/>
        </listOfProducts>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k4r </ci>
              <ci> P2 </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k4r" value="1"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="RnaDegradation" name="RNA Degradation" reversible="false">
        <listOfReactants>
          <speciesReference species="Rna"/>
        </listOfReactants>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k5 </ci>
              <ci> Rna </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k5" value="0.1"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
      <reaction id="ProteinDegradation" name="Protein degradation" reversible="false">
        <listOfReactants>
          <speciesReference species="P"/>
        </listOfReactants>
        <kineticLaw>
          <math xmlns="http://www.w3.org/1998/Math/MathML">
            <apply>
              <times/>
              <ci> k6 </ci>
              <ci> P </ci>
            </apply>
          </math>
          <listOfParameters>
            <parameter id="k6" value="0.01"/>
          </listOfParameters>
        </kineticLaw>
      </reaction>
    </listOfReactions>
  </model>
</sbml>
"""

