/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.script;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.i18n.Strings;
import org.robotframework.abbot.script.Comment;
import org.robotframework.abbot.script.InvalidScriptException;
import org.robotframework.abbot.script.Resolver;
import org.robotframework.abbot.script.XMLConstants;
import org.robotframework.abbot.script.XMLifiable;
import org.robotframework.abbot.tester.ComponentTester;

public abstract class Step
implements XMLConstants,
XMLifiable,
Serializable {
    private String description = null;
    private Resolver resolver;
    private Throwable invalidScriptError = null;
    static /* synthetic */ Class class$abbot$script$Step;
    static /* synthetic */ Class class$abbot$script$Resolver;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;

    public Step(Resolver resolver, Map attributes) {
        this(resolver, "");
        Log.debug("Instantiating " + this.getClass());
        if (Log.isClassDebugEnabled(class$abbot$script$Step == null ? (class$abbot$script$Step = Step.class$("org.robotframework.abbot.script.Step")) : class$abbot$script$Step)) {
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Log.debug(key + "=" + attributes.get(key));
            }
        }
        this.parseStepAttributes(attributes);
    }

    public Step(Resolver resolver, String description) {
        if (resolver == null) {
            if (!(this instanceof Resolver)) {
                throw new Error("Resolver must be provided");
            }
            resolver = (Resolver)((Object)this);
        } else if (this instanceof Resolver) {
            resolver = (Resolver)((Object)this);
        }
        this.resolver = resolver;
        if ("".equals(description)) {
            description = null;
        }
        this.description = description;
    }

    protected final void parseStepAttributes(Map attributes) {
        Log.debug("Parsing attributes for " + this.getClass());
        this.description = (String)attributes.get("desc");
    }

    public final void run() throws Throwable {
        if (this.invalidScriptError != null) {
            throw this.invalidScriptError;
        }
        Log.debug("Running " + this.toString());
        this.runStep();
    }

    protected abstract void runStep() throws Throwable;

    public String getDescription() {
        return this.description != null ? this.description : this.getDefaultDescription();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public abstract String getXMLTag();

    public abstract String getUsage();

    public abstract String getDefaultDescription();

    protected void setScriptError(Throwable thr) {
        if (this.invalidScriptError == null) {
            this.invalidScriptError = thr;
        } else {
            Log.warn("More than one script error encountered: " + thr);
            Log.warn("Already have: " + this.invalidScriptError);
        }
    }

    protected void usage() {
        this.usage(null);
    }

    protected void usage(String details) {
        String msg = this.getUsage();
        if (details != null) {
            msg = Strings.get("step.usage", new Object[]{msg, details});
        }
        this.setScriptError(new InvalidScriptException(msg));
    }

    public Map getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.description != null && !this.description.equals(this.getDefaultDescription())) {
            map.put("desc", this.description);
        }
        return map;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    protected Element addContent(Element el) {
        return el;
    }

    protected Element addAttributes(Element el) {
        TreeMap atts = new TreeMap(this.getAttributes());
        Iterator iter = atts.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)atts.get(key);
            if (value == null) {
                Log.warn("Attribute '" + key + "' value was null in step " + this.getXMLTag());
                value = "";
            }
            el.setAttribute(key, value);
        }
        return el;
    }

    public String toEditableString() {
        return Step.toXMLString(this);
    }

    public static String toXMLString(XMLifiable obj) {
        if (obj instanceof Comment) {
            return "<!-- " + ((Comment)obj).getDescription() + " -->";
        }
        Element el = obj.toXML();
        StringWriter writer = new StringWriter();
        try {
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(el, (Writer)writer);
        }
        catch (IOException io) {
            Log.warn(io);
        }
        return writer.toString();
    }

    public Element toXML() {
        return this.addAttributes(this.addContent(new Element(this.getXMLTag())));
    }

    public static Step createStep(Resolver resolver, String str) throws InvalidScriptException, IOException {
        StringReader reader = new StringReader(str);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)reader);
            Element el = doc.getRootElement();
            return Step.createStep(resolver, el);
        }
        catch (JDOMException e) {
            throw new InvalidScriptException(e.getMessage());
        }
    }

    protected static Map createAttributeMap(Element el) {
        Log.debug("Creating attribute map for " + el);
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator iter = el.getAttributes().iterator();
        while (iter.hasNext()) {
            Attribute att = (Attribute)iter.next();
            attributes.put(att.getName(), att.getValue());
        }
        return attributes;
    }

    public static Step createStep(Resolver resolver, Element el) throws InvalidScriptException {
        String tag = el.getName();
        Map attributes = Step.createAttributeMap(el);
        String name = tag.substring(0, 1).toUpperCase() + tag.substring(1);
        if (tag.equals("wait")) {
            attributes.put("wait", "true");
            name = "Assert";
        }
        try {
            name = "org.robotframework.abbot.script." + name;
            Log.debug("Instantiating " + name);
            Class<?> cls = Class.forName(name);
            try {
                Class[] argTypes = new Class[]{class$abbot$script$Resolver == null ? (class$abbot$script$Resolver = Step.class$("org.robotframework.abbot.script.Resolver")) : class$abbot$script$Resolver, class$org$jdom$Element == null ? (class$org$jdom$Element = Step.class$("org.jdom.Element")) : class$org$jdom$Element, class$java$util$Map == null ? (class$java$util$Map = Step.class$("java.util.Map")) : class$java$util$Map};
                Constructor<?> ctor = cls.getConstructor(argTypes);
                return (Step)ctor.newInstance(resolver, el, attributes);
            }
            catch (NoSuchMethodException nsm) {
                Class[] argTypes = new Class[]{class$abbot$script$Resolver == null ? (class$abbot$script$Resolver = Step.class$("org.robotframework.abbot.script.Resolver")) : class$abbot$script$Resolver, class$java$util$Map == null ? (class$java$util$Map = Step.class$("java.util.Map")) : class$java$util$Map};
                Constructor<?> ctor = cls.getConstructor(argTypes);
                return (Step)ctor.newInstance(resolver, attributes);
            }
        }
        catch (ClassNotFoundException cnf) {
            String msg = Strings.get("step.unknown_tag", new Object[]{tag});
            throw new InvalidScriptException(msg);
        }
        catch (InvocationTargetException ite) {
            Log.warn(ite);
            throw new InvalidScriptException(ite.getTargetException().getMessage());
        }
        catch (Exception exc) {
            Log.warn(exc);
            throw new InvalidScriptException(exc.getMessage());
        }
    }

    protected String simpleClassName(Class cls) {
        return ComponentTester.simpleClassName(cls);
    }

    public String toString() {
        return this.getDescription();
    }

    public Class resolveClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getResolver().getContextClassLoader();
        return Class.forName(className, true, cl);
    }

    protected ComponentTester resolveTester(String className) throws ClassNotFoundException {
        Class testedClass;
        if ((class$java$awt$Component == null ? (class$java$awt$Component = Step.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(testedClass = this.resolveClass(className))) {
            return ComponentTester.getTester(testedClass);
        }
        if ((class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = Step.class$("org.robotframework.abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).isAssignableFrom(testedClass)) {
            try {
                return (ComponentTester)testedClass.newInstance();
            }
            catch (Exception e) {
                String msg = "Custom ComponentTesters must provide an accessible no-args Constructor: " + e.getMessage();
                throw new IllegalArgumentException(msg);
            }
        }
        String msg = "The given class '" + className + "' is neither a Component nor a ComponentTester";
        throw new IllegalArgumentException(msg);
    }

    private void writeObject(ObjectOutputStream out) {
        out = null;
    }

    private void readObject(ObjectInputStream in) {
        in = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

