/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.tester;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.tester.Robot;
import org.robotframework.abbot.util.AWT;
import org.robotframework.abbot.util.EventNormalizer;
import org.robotframework.abbot.util.SingleThreadedEventListener;

public class InputState {
    private static final int BUTTON_MASK = 28;
    private Point mouseLocation = new Point(0, 0);
    private Point mouseLocationOnScreen = new Point(0, 0);
    private Stack componentStack = new Stack();
    private Stack locationStack = new Stack();
    private Stack screenLocationStack = new Stack();
    private int buttonsDown;
    private int modifiersDown;
    private long lastEventTime;
    private int clickCount;
    private Component dragSource;
    private int dragX;
    private int dragY;
    private EventNormalizer normalizer;

    public InputState() {
        long mask = 56L;
        SingleThreadedEventListener listener = new SingleThreadedEventListener(){

            protected void processEvent(AWTEvent event) {
                InputState.this.update(event);
            }
        };
        this.normalizer = new EventNormalizer();
        this.normalizer.startListening(listener, mask);
    }

    public synchronized void clear() {
        this.componentStack.clear();
        this.locationStack.clear();
        this.buttonsDown = 0;
        this.modifiersDown = 0;
        this.lastEventTime = 0L;
        this.clickCount = 0;
        this.dragSource = null;
    }

    public void dispose() {
        this.normalizer.stopListening();
        this.normalizer = null;
    }

    void update(AWTEvent event) {
        if (event instanceof MouseEvent) {
            this.updateState((MouseEvent)event);
        } else if (event instanceof KeyEvent) {
            this.updateState((KeyEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateState(KeyEvent ke) {
        if (ke.getWhen() < this.lastEventTime) {
            return;
        }
        InputState inputState = this;
        synchronized (inputState) {
            this.setLastEventTime(ke.getWhen());
            this.setModifiers(ke.getModifiers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateState(MouseEvent me) {
        if (me.getWhen() < this.lastEventTime) {
            if (Log.isClassDebugEnabled(this.getClass())) {
                Log.debug("Ignoring " + Robot.toString(me));
            }
            return;
        }
        Point where = me.getPoint();
        Point eventScreenLoc = null;
        boolean screenLocationFound = true;
        try {
            eventScreenLoc = AWT.getLocationOnScreen(me.getComponent());
        }
        catch (IllegalComponentStateException e) {
            screenLocationFound = false;
        }
        InputState inputState = this;
        synchronized (inputState) {
            this.setLastEventTime(me.getWhen());
            int whichButton = me.getModifiers() & 0x1C;
            if (me.getID() == 502) {
                this.buttonsDown &= ~whichButton;
                this.modifiersDown &= ~whichButton;
            } else if (me.getID() == 501) {
                this.buttonsDown |= whichButton;
                this.modifiersDown |= whichButton;
            }
            this.clickCount = me.getClickCount();
            if (me.getID() == 501) {
                this.dragSource = me.getComponent();
                this.dragX = me.getX();
                this.dragY = me.getY();
            } else if (me.getID() == 502 || me.getID() == 503) {
                this.dragSource = null;
            }
            if (me.getID() == 504) {
                this.componentStack.push(new WeakReference<Component>(me.getComponent()));
                this.locationStack.push(me.getPoint());
                this.screenLocationStack.push(screenLocationFound ? eventScreenLoc : me.getPoint());
            } else if (me.getID() == 505) {
                if (this.componentStack.empty()) {
                    if (Log.isClassDebugEnabled(this.getClass())) {
                        Log.debug("Got " + Robot.toString(me) + " but component not on stack");
                    }
                } else {
                    this.componentStack.pop();
                    this.locationStack.pop();
                    this.screenLocationStack.pop();
                }
            }
            if (screenLocationFound) {
                this.mouseLocation = this.componentStack.empty() ? null : new Point(where);
                this.mouseLocationOnScreen.setLocation(eventScreenLoc);
                this.mouseLocationOnScreen.translate(where.x, where.y);
            }
        }
    }

    public static Component getComponentAt(Component parent, Point p) {
        Log.debug("Checking " + p + " in " + Robot.toString(parent));
        Component c = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
        Log.debug("Deepest is " + Robot.toString(c));
        return c;
    }

    public synchronized Component getUltimateMouseComponent() {
        Component c = this.getMouseComponent();
        if (c != null) {
            Point p = this.getMouseLocation();
            c = InputState.getComponentAt(c, p);
        }
        return c;
    }

    public synchronized Component getMouseComponent() {
        WeakReference ref;
        Component comp = null;
        if (!(this.componentStack.empty() || (comp = (Component)(ref = (WeakReference)this.componentStack.peek()).get()) != null && comp.isShowing())) {
            Log.debug("Discarding unavailable component");
            this.componentStack.pop();
            this.locationStack.pop();
            this.screenLocationStack.pop();
            comp = this.getMouseComponent();
            if (comp != null) {
                this.mouseLocation = (Point)this.locationStack.peek();
                this.mouseLocationOnScreen = (Point)this.screenLocationStack.peek();
            }
        }
        if (Log.isClassDebugEnabled(this.getClass())) {
            Log.debug("Current component is " + Robot.toString(comp));
        }
        return comp;
    }

    public synchronized boolean isDragging() {
        return this.dragSource != null;
    }

    public synchronized Component getDragSource() {
        return this.dragSource;
    }

    public synchronized void setDragSource(Component c) {
        this.dragSource = c;
    }

    public synchronized Point getDragOrigin() {
        return new Point(this.dragX, this.dragY);
    }

    public synchronized int getClickCount() {
        return this.clickCount;
    }

    protected synchronized void setClickCount(int count) {
        this.clickCount = count;
    }

    public synchronized long getLastEventTime() {
        return this.lastEventTime;
    }

    protected synchronized void setLastEventTime(long t) {
        this.lastEventTime = t;
    }

    public synchronized int getModifiers() {
        return this.modifiersDown;
    }

    protected synchronized void setModifiers(int m) {
        this.modifiersDown = m;
    }

    public synchronized int getKeyModifiers() {
        return this.modifiersDown & 0xFFFFFFE3;
    }

    public synchronized int getButtons() {
        return this.buttonsDown;
    }

    protected synchronized void setButtons(int b) {
        this.buttonsDown = b;
    }

    public synchronized Point getMouseLocation() {
        return this.mouseLocation != null ? new Point(this.mouseLocation) : null;
    }

    public synchronized Point getMouseLocationOnScreen() {
        return new Point(this.mouseLocationOnScreen);
    }

    public boolean isNativeDragActive() {
        try {
            Class<?> cls = Class.forName("sun.awt.dnd.SunDragSourceContextPeer");
            Method m = cls.getMethod("checkDragDropInProgress", null);
            try {
                m.invoke(null, null);
                return false;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InvalidDnDOperationException) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

