/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.tester;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Robot;
import java.awt.Window;
import org.robotframework.abbot.tester.WindowTracker;
import org.robotframework.abbot.util.Bugs;

public class RobotVerifier {
    private static final String WINDOW_NAME = "Abbot Robot Verification";

    private RobotVerifier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(Robot robot) {
        if (!Bugs.needsRobotVerification()) {
            return true;
        }
        int SIZE = 4;
        Frame f = new Frame(WINDOW_NAME);
        f.setName(WINDOW_NAME);
        Window w = new Window(f);
        Color color = new Color(0, 1, 2);
        w.setBackground(color);
        w.setName(WINDOW_NAME);
        w.pack();
        w.setSize(4, 4);
        w.setLocation(100, 100);
        w.setVisible(true);
        robot.waitForIdle();
        WindowTracker tracker = WindowTracker.getTracker();
        while (!tracker.isWindowReady(w)) {
            robot.delay(20);
        }
        try {
            Color sample = robot.getPixelColor(100, 100);
            boolean bl = sample.equals(color);
            return bl;
        }
        finally {
            w.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            boolean works = RobotVerifier.verify(new Robot());
            System.out.println("Robot is " + (works ? "" : "not ") + "functional");
        }
        catch (AWTException e) {
            System.out.println("Robot is not available");
        }
        System.exit(0);
    }
}

