/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.robotframework.abbot.Platform;

public class PathClassLoader
extends URLClassLoader {
    private String classPath;
    private static final Factory factory = new Factory();

    public PathClassLoader(String path) {
        this(path, null);
    }

    public PathClassLoader(String path, ClassLoader parent) {
        super(PathClassLoader.getURLs(path != null ? path : System.getProperty("java.class.path"), ":;"), parent, factory);
        this.classPath = path != null ? path : System.getProperty("java.class.path");
    }

    public String getClassPath() {
        return this.classPath;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        return super.loadClass(name, resolve);
    }

    static URL[] getURLs(String p, String separators) {
        String s = p != null ? p : System.getProperty("java.class.path");
        File[] files = s != null ? PathClassLoader.convertPathToFiles(s, separators) : new File[]{};
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = files[i].toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return urls;
    }

    public static String[] convertPathToFilenames(String path) {
        return PathClassLoader.convertPathToFilenames(path, ":;");
    }

    public static File[] convertPathToFiles(String path, String seps) {
        String[] names = PathClassLoader.convertPathToFilenames(path, ":;");
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < names.length; ++i) {
            files.add(new File(names[i]));
        }
        return files.toArray(new File[files.size()]);
    }

    static String[] convertPathToFilenames(String path, String seps) {
        if (path == null) {
            path = "";
        }
        boolean fixDrives = Platform.isWindows() && seps.indexOf(":") != -1;
        StringTokenizer st = new StringTokenizer(path, seps);
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            char ch;
            String fp = st.nextToken();
            if (fixDrives && fp.length() == 1 && st.hasMoreTokens() && ((ch = fp.charAt(0)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                fp = fp + ":" + st.nextToken();
            }
            names.add(fp);
        }
        return names.toArray(new String[names.size()]);
    }

    public String toString() {
        return super.toString() + " (classpath=" + this.classPath + ")";
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static final String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            String name = "sun.net.www.protocol." + protocol + ".Handler";
            try {
                Class<?> c = Class.forName(name);
                return (URLStreamHandler)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            throw new Error("could not load " + protocol + "system protocol handler");
        }
    }
}

