/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.laughingpanda.jretrofit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.robotframework.org.laughingpanda.jretrofit.AbstractMethodLookupHelper;
import org.robotframework.org.laughingpanda.jretrofit.AllMethodsNotImplementedException;
import org.robotframework.org.laughingpanda.jretrofit.RetrofitInvocationHandler;
import org.robotframework.org.laughingpanda.jretrofit.Retrofitter;

abstract class AbstractRetrofitter
implements Retrofitter {
    AbstractRetrofitter() {
    }

    private Class[] allInterfacesToImplement(Object object, Class[] classArray) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(Arrays.asList(classArray));
        arrayList.addAll(Arrays.asList(object.getClass().getInterfaces()));
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private void checkParameters(Object object, Class[] classArray) {
        if (object == null) {
            throw new IllegalArgumentException("Target object cannot be null!");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("Array of interfaces to implement cannot be null!");
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != null) continue;
            throw new IllegalArgumentException("Interface to implement cannot be null!");
        }
    }

    private void checkThatAllRequiredMethodsAreImplemented(Class[] classArray, AbstractMethodLookupHelper abstractMethodLookupHelper) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < classArray.length; ++i) {
            arrayList.addAll(Arrays.asList(classArray[i].getMethods()));
        }
        Method[] methodArray = arrayList.toArray(new Method[arrayList.size()]);
        ArrayList<Method> arrayList2 = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                abstractMethodLookupHelper.findMethodToCall(methodArray[i]);
                continue;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                arrayList2.add(methodArray[i]);
            }
        }
        if (!arrayList2.isEmpty()) {
            throw new AllMethodsNotImplementedException(arrayList2.toArray(new Method[arrayList2.size()]));
        }
    }

    public final Object complete(Object object, Class clazz) {
        return this.complete(object, new Class[]{clazz});
    }

    public final Object complete(Object object, Class[] classArray) {
        this.checkParameters(object, classArray);
        AbstractMethodLookupHelper abstractMethodLookupHelper = this.createMethodLookupHelper(object);
        this.checkThatAllRequiredMethodsAreImplemented(classArray, abstractMethodLookupHelper);
        return this.createProxy(object, classArray, abstractMethodLookupHelper);
    }

    protected abstract AbstractMethodLookupHelper createMethodLookupHelper(Object var1);

    private Object createProxy(Object object, Class[] classArray, AbstractMethodLookupHelper abstractMethodLookupHelper) {
        ClassLoader[] classLoaderArray = this.getCandidateClassLoaders(object, classArray);
        ArrayList<IllegalArgumentException> arrayList = new ArrayList<IllegalArgumentException>();
        for (int i = 0; i < classLoaderArray.length; ++i) {
            try {
                return Proxy.newProxyInstance(classLoaderArray[i], this.allInterfacesToImplement(object, classArray), (InvocationHandler)new RetrofitInvocationHandler(abstractMethodLookupHelper));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                arrayList.add(illegalArgumentException);
                continue;
            }
        }
        throw new RuntimeException("Could not find a suitable classloader for retrofitting! Exceptions when attempting to create proxy: " + arrayList);
    }

    private ClassLoader[] getCandidateClassLoaders(Object object, Class[] classArray) {
        ClassLoader[] classLoaderArray = new ClassLoader[classArray.length + 1];
        classLoaderArray[0] = object.getClass().getClassLoader();
        for (int i = 0; i < classArray.length; ++i) {
            classLoaderArray[i + 1] = classArray[i].getClassLoader();
        }
        return classLoaderArray;
    }

    public final Object partial(Object object, Class clazz) {
        return this.partial(object, new Class[]{clazz});
    }

    public final Object partial(Object object, Class[] classArray) {
        this.checkParameters(object, classArray);
        return this.createProxy(object, classArray, this.createMethodLookupHelper(object));
    }
}

