/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import org.robotframework.org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.robotframework.org.netbeans.jemmy.drivers.ScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JButtonOperator;
import org.robotframework.org.netbeans.jemmy.operators.JSpinnerOperator;

public class JSpinnerDriver
extends LightSupportiveDriver
implements ScrollDriver {
    public JSpinnerDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.JSpinnerOperator"});
    }

    public void scrollToMinimum(final ComponentOperator oper, int orientation) {
        Object minimum = ((JSpinnerOperator)oper).getMinimum();
        if (minimum == null) {
            throw new JSpinnerOperator.SpinnerModelException("Impossible to get a minimum of JSpinner model.", oper.getSource());
        }
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollOrientation() {
                return 1;
            }

            public String getDescription() {
                return "Spin to minimum";
            }

            public int getScrollDirection() {
                if (((JSpinnerOperator)oper).getModel().getPreviousValue() != null) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void scrollToMaximum(final ComponentOperator oper, int orientation) {
        Object maximum = ((JSpinnerOperator)oper).getMaximum();
        if (maximum == null) {
            throw new JSpinnerOperator.SpinnerModelException("Impossible to get a maximum of JSpinner model.", oper.getSource());
        }
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollOrientation() {
                return 1;
            }

            public String getDescription() {
                return "Spin to maximum";
            }

            public int getScrollDirection() {
                if (((JSpinnerOperator)oper).getModel().getNextValue() != null) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void scroll(ComponentOperator oper, ScrollAdjuster adj) {
        JButtonOperator increaseButton = ((JSpinnerOperator)oper).getIncreaseOperator();
        JButtonOperator decreaseButton = ((JSpinnerOperator)oper).getDecreaseOperator();
        if (adj.getScrollDirection() == 0) {
            return;
        }
        int originalDirection = adj.getScrollDirection();
        while (adj.getScrollDirection() == originalDirection) {
            if (originalDirection == 1) {
                increaseButton.push();
                continue;
            }
            decreaseButton.push();
        }
    }
}

