/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.development;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.keyword.development.ComponentOccurences;
import org.robotframework.swing.operator.ComponentWrapper;

@RobotKeywords
public class DevelopmentKeywords {
    private List<String> resultComponentList = new ArrayList<String>();

    @RobotKeyword(value="Prints components (their types and their internal names) from the selected context.\nThe internal name is set with component's setName method: http://java.sun.com/j2se/1.4.2/docs/api/java/awt/Component.html#setName(java.lang.String).\nSee keywords, `Select Window`, `Select Dialog` and `Select Context` for details about context.\n\nExample:\n| Select Main Window         |\n| List Components In Context |\n")
    public String listComponentsInContext() {
        ComponentWrapper operator = Context.getContext();
        new ContainerIteratorForListing((Container)operator.getSource()).iterate();
        return this.resultComponentList.toString();
    }

    private void printSpacesToFormatOutputAsTree(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("   ");
        }
    }

    private String componentToString(Component component) {
        String componentString = component.toString();
        int indexToStartOfDetails = componentString.indexOf(91);
        if (indexToStartOfDetails == -1) {
            return componentString;
        }
        return componentString.substring(0, indexToStartOfDetails);
    }

    private static abstract class ContainerIterator {
        private int level;
        private Container container;

        public ContainerIterator(Container container) {
            this.container = container;
        }

        public void iterate() {
            this.processComponent(this.container);
        }

        public abstract void operateOnComponent(Component var1, int var2);

        private void processComponent(Component component) {
            this.operateOnComponent(component, this.level);
            ++this.level;
            if (component instanceof Container) {
                Component[] subComponents = ((Container)component).getComponents();
                for (int i = 0; i < subComponents.length; ++i) {
                    this.processComponent(subComponents[i]);
                    --this.level;
                }
            }
        }
    }

    private class ContainerIteratorForListing
    extends ContainerIterator {
        private ComponentOccurences occurences;

        public ContainerIteratorForListing(Container container) {
            super(container);
            this.occurences = new ComponentOccurences();
        }

        public void operateOnComponent(Component component, int level) {
            DevelopmentKeywords.this.printSpacesToFormatOutputAsTree(level);
            String componentName = DevelopmentKeywords.this.componentToString(component);
            System.out.println(level + " " + componentName + " " + this.occurences.countIndexOf(component) + ": " + component.getName());
            DevelopmentKeywords.this.resultComponentList.add(componentName);
        }
    }
}

