/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.textcomponent;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.textcomponent.TextComponentOperator;
import org.robotframework.swing.textcomponent.TextComponentOperatorFactory;

@RobotKeywords
public class TextComponentKeywords {
    private OperatorFactory<TextComponentOperator> operatorFactory = new TextComponentOperatorFactory();

    @RobotKeyword(value="Inserts text into a text component (e.g. text field, password field, text area).\n\nExample:\n| Insert Into Textfield | _nameTextField_ | _John Doe_ |\n")
    @ArgumentNames(value={"identifier", "text"})
    public void insertIntoTextField(String identifier, String text) {
        TextComponentOperator operator = this.createOperator(identifier);
        if (this.notEditable(operator)) {
            throw new RuntimeException("Text field '" + identifier + "' is not editable.");
        }
        operator.setText(text);
    }

    private boolean notEditable(TextComponentOperator operator) {
        return !operator.isEditable() || !operator.isEnabled();
    }

    @RobotKeyword(value="Returns the value of a text component (e.g. text field, password field, text area).\n\nExample:\n| ${textFieldValue}= | Get Textfield Value | _nameTextField_       |\n| Should Be Equal    | _John Doe_          | _${textFieldValue}_ |\n")
    @ArgumentNames(value={"identifier"})
    public String getTextFieldValue(String identifier) {
        return this.createOperator(identifier).getText();
    }

    @RobotKeyword(value="Types text into a text component (e.g. text field, password field, text area).\nSame as `Insert Into Textfield` but sends real key events when setting text field contents.\nUseful if application expects real keyboard events instead of only setting the text of the textfield.\n\nExample:\n| Type Into Textfield | _nameTextField_ | _John Doe_ |\n")
    @ArgumentNames(value={"identifier", "text"})
    public void typeIntoTextField(String identifier, String text) {
        this.createOperator(identifier).typeText(text);
    }

    @RobotKeyword(value="Clears contents of text component (e.g. text field, password field, text area).\n\nExample:\n| Clear Textfield | _nameTextField_ |\n")
    @ArgumentNames(value={"identifier"})
    public void clearTextField(String identifier) {
        this.createOperator(identifier).clearText();
    }

    @RobotKeyword(value="Fails if text component (e.g. text field, password field, text area) is disabled.\n\nExample:\n| Textfield Should Be Enabled | _nameTextField_ |\n")
    @ArgumentNames(value={"identifier"})
    public void textFieldShouldBeEnabled(String identifier) {
        Assert.assertTrue("Textfield '" + identifier + "' is disabled.", this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if text component (e.g. text field, password field, text area) is enabled.\n\nExample:\n| Textfield Should Be Disabled | _nameTextField_ |\n")
    @ArgumentNames(value={"identifier"})
    public void textFieldShouldBeDisabled(String identifier) {
        Assert.assertFalse("Textfield '" + identifier + "' is enabled.", this.createOperator(identifier).isEnabled());
    }

    private TextComponentOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

