/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.robotframework.org.laughingpanda.jretrofit.Retrofit;
import org.robotframework.swing.chooser.WithText;
import org.robotframework.swing.common.SmoothInvoker;

public class NodeTextExtractor {
    private final JTree tree;

    public NodeTextExtractor(JTree tree) {
        this.tree = tree;
    }

    public String getText(Object node, String path) {
        TreePath treePath = new TreePath(path.split("\\|"));
        return this.getText(node, treePath);
    }

    public String getText(final Object node, final TreePath treePath) {
        SmoothInvoker<String> textExctractor = new SmoothInvoker<String>(){

            @Override
            public Object work() {
                return NodeTextExtractor.this.extractTextFromNode(node, treePath);
            }
        };
        return (String)textExctractor.invoke();
    }

    private String extractTextFromNode(Object node, TreePath treePath) {
        try {
            WithText componentWithText = this.getNodeComponentWithText(node, treePath);
            return componentWithText.getText();
        }
        catch (Exception e) {
            return node.toString();
        }
    }

    private WithText getNodeComponentWithText(Object node, TreePath treePath) {
        Component component = this.getNodeComponent(node, treePath);
        return this.coerceToWithText(component);
    }

    private Component getNodeComponent(Object node, TreePath treePath) {
        int row = this.tree.getRowForPath(treePath);
        boolean isLeaf = this.tree.getModel().isLeaf(node);
        boolean hasFocus = this.tree.getLeadSelectionRow() == row;
        boolean isSelected = this.tree.isRowSelected(row);
        boolean isExpanded = this.tree.isExpanded(row);
        TreeCellRenderer cellRenderer = this.tree.getCellRenderer();
        return cellRenderer.getTreeCellRendererComponent(this.tree, node, isSelected, isExpanded, isLeaf, row, hasFocus);
    }

    private WithText coerceToWithText(Component component) {
        return (WithText)Retrofit.partial((Object)component, WithText.class);
    }
}

