/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Platform {
    public static final int JAVA_1_0 = 4096;
    public static final int JAVA_1_1 = 4352;
    public static final int JAVA_1_2 = 4608;
    public static final int JAVA_1_3 = 4864;
    public static final int JAVA_1_4 = 5120;
    public static final int JAVA_1_5 = 5376;
    public static final int JAVA_1_6 = 5632;
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String JAVA_VERSION_STRING = System.getProperty("java.version");
    public static final int JAVA_VERSION = Platform.parse(JAVA_VERSION_STRING);
    private static boolean isWindows = OS_NAME.startsWith("Windows");
    private static boolean isWindows9X = isWindows && (OS_NAME.indexOf("95") != -1 || OS_NAME.indexOf("98") != -1 || OS_NAME.indexOf("ME") != -1);
    private static boolean isWindowsXP = isWindows && OS_NAME.indexOf("XP") != -1;
    private static boolean isMac = System.getProperty("mrj.version") != null;
    private static boolean isOSX = isMac && OS_NAME.indexOf("OS X") != -1;
    private static boolean isSunOS = OS_NAME.startsWith("SunOS") || OS_NAME.startsWith("Solaris");
    private static boolean isHPUX = OS_NAME.equals("HP-UX");
    private static boolean isLinux = OS_NAME.equals("Linux");

    private Platform() {
    }

    private static String strip(String number) {
        while (number.startsWith("0") && number.length() > 1) {
            number = number.substring(1);
        }
        return number;
    }

    static int parse(String vs) {
        int version = 0;
        try {
            StringTokenizer st = new StringTokenizer(vs, "._");
            version = Integer.parseInt(Platform.strip(st.nextToken())) * 4096;
            version += Integer.parseInt(Platform.strip(st.nextToken())) * 256;
            version += Integer.parseInt(Platform.strip(st.nextToken())) * 16;
            version += Integer.parseInt(Platform.strip(st.nextToken()));
        }
        catch (NumberFormatException nfe) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return version;
    }

    public static boolean isX11() {
        return !isOSX && !isWindows;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isWindows9X() {
        return isWindows9X;
    }

    public static boolean isWindowsXP() {
        return isWindowsXP;
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isOSX() {
        return isOSX;
    }

    public static boolean isSolaris() {
        return isSunOS;
    }

    public static boolean isHPUX() {
        return isHPUX;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void main(String[] args) {
        System.out.println("Java version is " + JAVA_VERSION_STRING);
        System.out.println("Version number is " + Integer.toHexString(JAVA_VERSION));
        System.out.println("os.name=" + OS_NAME);
    }
}

