/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.robotframework.javalib.org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static boolean arrayContains(String needle, String[] haystack) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static void assertArraysContainSame(String[] expected, String[] actual) {
        if (!new HashSet<String>(Arrays.asList(expected)).equals(new HashSet<String>(Arrays.asList(actual)))) {
            throw new AssertionError();
        }
    }

    public static <T> void assertArraysEquals(T[] expected, T[] actual) {
        if (!Arrays.equals(expected, actual)) {
            throw new AssertionError((Object)("Expected " + Arrays.asList(expected) + " but was " + Arrays.asList(actual)));
        }
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return ArrayUtil.copyOfRange(original, from, to, original.getClass());
    }

    public static <T> T[] add(T[] original, T ... newElements) {
        ArrayList results = new ArrayList(original.length + newElements.length);
        CollectionUtils.addAll(results, original);
        CollectionUtils.addAll(results, newElements);
        return results.toArray(original);
    }
}

