/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.robotframework.org.netbeans.jemmy.drivers.ScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;

public abstract class AbstractScrollDriver
extends LightSupportiveDriver
implements ScrollDriver {
    public static final int ADJUST_CLICK_COUNT = 10;

    public AbstractScrollDriver(String[] supported) {
        super(supported);
    }

    public void scroll(ComponentOperator oper, ScrollAdjuster adj) {
        if (this.canJump(oper)) {
            this.doJumps(oper, adj);
        }
        if (this.canDragAndDrop(oper)) {
            this.doDragAndDrop(oper, adj);
        }
        if (this.canPushAndWait(oper)) {
            this.doPushAndWait(oper, adj);
        }
        for (int i = 0; i < 10; ++i) {
            this.doSteps(oper, adj);
        }
    }

    protected abstract void step(ComponentOperator var1, ScrollAdjuster var2);

    protected abstract void jump(ComponentOperator var1, ScrollAdjuster var2);

    protected abstract void startPushAndWait(ComponentOperator var1, int var2, int var3);

    protected abstract void stopPushAndWait(ComponentOperator var1, int var2, int var3);

    protected abstract Point startDragging(ComponentOperator var1);

    protected abstract void drop(ComponentOperator var1, Point var2);

    protected abstract void drag(ComponentOperator var1, Point var2);

    protected abstract Timeout getScrollDeltaTimeout(ComponentOperator var1);

    protected abstract boolean canDragAndDrop(ComponentOperator var1);

    protected abstract boolean canJump(ComponentOperator var1);

    protected abstract boolean canPushAndWait(ComponentOperator var1);

    protected abstract int getDragAndDropStepLength(ComponentOperator var1);

    protected void doDragAndDrop(ComponentOperator oper, ScrollAdjuster adj) {
        int direction = adj.getScrollDirection();
        if (direction != 0) {
            Point pnt = this.startDragging(oper);
            while (adj.getScrollDirection() == direction) {
                pnt = this.increasePoint(oper, pnt, adj, direction);
                this.drag(oper, pnt);
            }
            this.drop(oper, pnt);
        }
    }

    protected void doJumps(ComponentOperator oper, ScrollAdjuster adj) {
        int direction = adj.getScrollDirection();
        if (direction != 0) {
            while (adj.getScrollDirection() == direction) {
                this.jump(oper, adj);
            }
        }
    }

    protected void doPushAndWait(ComponentOperator oper, ScrollAdjuster adj) {
        int direction = adj.getScrollDirection();
        int orientation = adj.getScrollOrientation();
        if (direction != 0) {
            Timeout delta = this.getScrollDeltaTimeout(oper);
            this.startPushAndWait(oper, direction, orientation);
            while (adj.getScrollDirection() == direction) {
                delta.sleep();
            }
            this.stopPushAndWait(oper, direction, orientation);
        }
    }

    protected void doSteps(ComponentOperator oper, ScrollAdjuster adj) {
        int direction = adj.getScrollDirection();
        if (direction != 0) {
            while (adj.getScrollDirection() == direction) {
                this.step(oper, adj);
            }
        }
    }

    private Point increasePoint(ComponentOperator oper, Point pnt, ScrollAdjuster adj, int direction) {
        return adj.getScrollOrientation() == 0 ? new Point(pnt.x + (direction == 1 ? 1 : -1) * this.getDragAndDropStepLength(oper), pnt.y) : new Point(pnt.x, pnt.y + (direction == 1 ? 1 : -1) * this.getDragAndDropStepLength(oper));
    }
}

