/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.operators;

import java.awt.Container;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentListener;
import org.robotframework.org.netbeans.jemmy.Action;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.ComponentSearcher;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.TestOut;
import org.robotframework.org.netbeans.jemmy.Timeoutable;
import org.robotframework.org.netbeans.jemmy.Timeouts;
import org.robotframework.org.netbeans.jemmy.Waitable;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.ScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;

public class ScrollbarOperator
extends ComponentOperator
implements Timeoutable,
Outputable {
    private static final long ONE_SCROLL_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private static final long BEFORE_DROP_TIMEOUT = 0L;
    private static final long DRAG_AND_DROP_SCROLLING_DELTA = 0L;
    private static final int MINIMAL_PAD_SIZE = 10;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private Timeouts timeouts;
    private TestOut output;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Scrollbar;

    public ScrollbarOperator(Scrollbar b) {
        super(b);
    }

    public ScrollbarOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((Scrollbar)cont.waitSubComponent(new ScrollbarFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public ScrollbarOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ScrollbarOperator(ContainerOperator cont, int index) {
        this((Scrollbar)ScrollbarOperator.waitComponent(cont, (ComponentChooser)new ScrollbarFinder(), index));
        this.copyEnvironment(cont);
    }

    public ScrollbarOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static Scrollbar findScrollbar(Container cont, ComponentChooser chooser, int index) {
        return (Scrollbar)ScrollbarOperator.findComponent(cont, new ScrollbarFinder(chooser), index);
    }

    public static Scrollbar findScrollbar(Container cont, ComponentChooser chooser) {
        return ScrollbarOperator.findScrollbar(cont, chooser, 0);
    }

    public static Scrollbar findScrollbar(Container cont, int index) {
        return ScrollbarOperator.findScrollbar(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th Scrollbar instance"), index);
    }

    public static Scrollbar findScrollbar(Container cont) {
        return ScrollbarOperator.findScrollbar(cont, 0);
    }

    public static Scrollbar waitScrollbar(Container cont, ComponentChooser chooser, int index) {
        return (Scrollbar)ScrollbarOperator.waitComponent(cont, (ComponentChooser)new ScrollbarFinder(chooser), index);
    }

    public static Scrollbar waitScrollbar(Container cont, ComponentChooser chooser) {
        return ScrollbarOperator.waitScrollbar(cont, chooser, 0);
    }

    public static Scrollbar waitScrollbar(Container cont, int index) {
        return ScrollbarOperator.waitScrollbar(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th Scrollbar instance"), index);
    }

    public static Scrollbar waitScrollbar(Container cont) {
        return ScrollbarOperator.waitScrollbar(cont, 0);
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), anotherOperator.getProperties());
    }

    public void scrollTo(Waitable w, Object waiterParam, boolean increase) {
        this.scrollTo(new WaitableChecker(w, waiterParam, increase, this));
    }

    public void scrollTo(final ScrollAdjuster adj) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollbarOperator.this.driver.scroll(ScrollbarOperator.this, adj);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToValue(int value) {
        this.output.printTrace("Scroll Scrollbar to " + Integer.toString(value) + " value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to " + Integer.toString(value) + " value");
        this.scrollTo(new ValueScrollAdjuster(value));
    }

    public void scrollToValue(double proportionalValue) {
        this.output.printTrace("Scroll Scrollbar to " + Double.toString(proportionalValue) + " proportional value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to " + Double.toString(proportionalValue) + " proportional value");
        this.scrollTo(new ValueScrollAdjuster((int)((double)this.getMinimum() + (double)(this.getMaximum() - this.getVisibleAmount() - this.getMinimum()) * proportionalValue)));
    }

    public void scrollToMinimum() {
        this.output.printTrace("Scroll Scrollbar to minimum value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to minimum value");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollbarOperator.this.driver.scrollToMinimum(ScrollbarOperator.this, ScrollbarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToMaximum() {
        this.output.printTrace("Scroll Scrollbar to maximum value\n" + this.toStringSource());
        this.output.printGolden("Scroll Scrollbar to maximum value");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollbarOperator.this.driver.scrollToMaximum(ScrollbarOperator.this, ScrollbarOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void addAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("addAdjustmentListener"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).addAdjustmentListener(adjustmentListener);
            }
        });
    }

    public int getBlockIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getBlockIncrement"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getBlockIncrement();
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getMinimum();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getOrientation();
            }
        });
    }

    public int getUnitIncrement() {
        return this.runMapping(new Operator.MapIntegerAction("getUnitIncrement"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getUnitIncrement();
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getValue();
            }
        });
    }

    public int getVisibleAmount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleAmount"){

            public int map() {
                return ((Scrollbar)ScrollbarOperator.this.getSource()).getVisibleAmount();
            }
        });
    }

    public void removeAdjustmentListener(final AdjustmentListener adjustmentListener) {
        this.runMapping(new Operator.MapVoidAction("removeAdjustmentListener"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).removeAdjustmentListener(adjustmentListener);
            }
        });
    }

    public void setBlockIncrement(final int i) {
        this.runMapping(new Operator.MapVoidAction("setBlockIncrement"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setBlockIncrement(i);
            }
        });
    }

    public void setMaximum(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setMaximum(i);
            }
        });
    }

    public void setMinimum(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setMinimum(i);
            }
        });
    }

    public void setOrientation(final int i) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setOrientation(i);
            }
        });
    }

    public void setUnitIncrement(final int i) {
        this.runMapping(new Operator.MapVoidAction("setUnitIncrement"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setUnitIncrement(i);
            }
        });
    }

    public void setValue(final int i) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setValue(i);
            }
        });
    }

    public void setValues(final int i, final int i1, final int i2, final int i3) {
        this.runMapping(new Operator.MapVoidAction("setValues"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setValues(i, i1, i2, i3);
            }
        });
    }

    public void setVisibleAmount(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVisibleAmount"){

            public void map() {
                ((Scrollbar)ScrollbarOperator.this.getSource()).setVisibleAmount(i);
            }
        });
    }

    static {
        Timeouts.initDefault("ScrollbarOperator.OneScrollClickTimeout", 0L);
        Timeouts.initDefault("ScrollbarOperator.WholeScrollTimeout", 60000L);
        Timeouts.initDefault("ScrollbarOperator.BeforeDropTimeout", 0L);
        Timeouts.initDefault("ScrollbarOperator.DragAndDropScrollingDelta", 0L);
    }

    public static class ScrollbarFinder
    extends Operator.Finder {
        public ScrollbarFinder(ComponentChooser sf) {
            super(class$java$awt$Scrollbar == null ? (class$java$awt$Scrollbar = ScrollbarOperator.class$("java.awt.Scrollbar")) : class$java$awt$Scrollbar, sf);
        }

        public ScrollbarFinder() {
            super(class$java$awt$Scrollbar == null ? (class$java$awt$Scrollbar = ScrollbarOperator.class$("java.awt.Scrollbar")) : class$java$awt$Scrollbar);
        }
    }

    private class WaitableChecker
    implements ScrollAdjuster {
        Waitable w;
        Object waitParam;
        boolean increase;
        boolean reached = false;
        ScrollbarOperator oper;

        public WaitableChecker(Waitable w, Object waitParam, boolean increase, ScrollbarOperator oper) {
            this.w = w;
            this.waitParam = waitParam;
            this.increase = increase;
            this.oper = oper;
        }

        public int getScrollDirection() {
            if (!this.reached && this.w.actionProduced(this.waitParam) != null) {
                this.reached = true;
            }
            if (this.reached) {
                return 0;
            }
            return this.increase ? 1 : -1;
        }

        public int getScrollOrientation() {
            return ScrollbarOperator.this.getOrientation();
        }

        public String getDescription() {
            return this.w.getDescription();
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int value) {
            this.value = value;
        }

        public int getScrollDirection() {
            if (ScrollbarOperator.this.getValue() == this.value) {
                return 0;
            }
            return ScrollbarOperator.this.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return ScrollbarOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }
}

