/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.dialog;

import java.awt.Component;
import javax.swing.JDialog;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.operators.DialogOperator;
import org.robotframework.org.netbeans.jemmy.operators.JDialogOperator;
import org.robotframework.org.netbeans.jemmy.util.RegExComparator;
import org.robotframework.swing.common.Identifier;
import org.robotframework.swing.operator.ComponentWrapper;
import org.robotframework.swing.util.ObjectUtils;

public class DialogOperator
extends JDialogOperator
implements ComponentWrapper {
    public static DialogOperator newOperatorFor(int index) {
        return new DialogOperator(index);
    }

    private DialogOperator(int index) {
        super(index);
    }

    public static DialogOperator newOperatorFor(String title) {
        Identifier identifier = new Identifier(title);
        if (identifier.isRegExp()) {
            return new DialogOperator(DialogOperator.createRegExpComponentChooser(identifier.asString()));
        }
        return new DialogOperator(DialogOperator.createByNameOrTitleComponentChooser(title));
    }

    private static ComponentChooser createByNameOrTitleComponentChooser(final String title) {
        return new ComponentChooser(){

            public String getDescription() {
                return "Dialog with name or title '" + title + "'";
            }

            public boolean checkComponent(Component comp) {
                if (!(comp instanceof JDialog)) {
                    return false;
                }
                return this.eq(title, comp) || ObjectUtils.nullSafeEquals(((JDialog)comp).getTitle(), title);
            }

            private boolean eq(String title2, Component comp) {
                return ObjectUtils.nullSafeEquals(comp.getName(), title2);
            }
        };
    }

    private static ComponentChooser createRegExpComponentChooser(String identifier) {
        return new JDialogOperator.JDialogFinder(new DialogOperator.DialogByTitleFinder(identifier, new RegExComparator()));
    }

    private DialogOperator(ComponentChooser chooser) {
        super(chooser);
    }

    private DialogOperator(String title) {
        super(title);
    }
}

