/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyboard;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.robotframework.abbot.tester.ComponentTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyEventSender {
    private ComponentTester componentTester = new ComponentTester();

    public void sendEvent(String keyCodeAsString, String[] modifiersAsString) {
        int keyCode = this.toKeyCode(keyCodeAsString);
        int modifiers = this.toModifiers(modifiersAsString);
        this.sendEvent(keyCode, modifiers);
    }

    private int toKeyCode(String keyCodeAsString) {
        return this.getIntValueFromField(KeyEvent.class, keyCodeAsString);
    }

    private int getIntValueFromField(Class<?> target, String fieldName) {
        try {
            return target.getField(fieldName).getInt(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("'" + fieldName + "' is invalid. See " + target.getName() + " for valid fields.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int toModifiers(String[] modifiersAsString) {
        int modifiers = 0;
        for (String modifierAsString : modifiersAsString) {
            modifiers |= this.toModifier(modifierAsString);
        }
        return modifiers;
    }

    private int toModifier(String modifierAsString) {
        return this.getIntValueFromField(InputEvent.class, modifierAsString);
    }

    private void sendEvent(int keyCode, int modifiers) {
        this.componentTester.actionKeyStroke(keyCode, modifiers);
    }
}

