/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.apache.commons.collections.CollectionUtils;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.list.ListOperator;
import org.robotframework.swing.list.ListOperatorFactory;
import org.robotframework.swing.util.SwingInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class ListKeywords
extends IdentifierSupport {
    private OperatorFactory<ListOperator> operatorFactory = new ListOperatorFactory();

    @RobotKeyword(value="Clears selection from list.\n\nExample:\n| Clear Selection From List | _myList_ |\n")
    @ArgumentNames(value={"identifier"})
    public void clearSelectionFromList(String identifier) {
        this.createOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Selects an item from the list.\n\nExamples:\n| Select From List | _myList_ | _myItem_ | # selects 'myItem'                   |\n| Select From List | _myList_ | _0_      | # selects the first item in the list |\n\n| Select From List | _myList_ | _myItem_ | _2_ | # doubleclicks on item |\nAny number of list item identifiers can be provided to select multiple items at once:\n| Select From List | _myList_ | _myItem_ | _anotherItem_ | _yetAnother_ |\n")
    @ArgumentNames(value={"identifier", "listItemIdentifier", "*additionalItemIdentifiers"})
    public void selectFromList(String identifier, final String listItemIdentifier, final String[] additionalItemIdentifiers) {
        final ListOperator operator = this.createOperator(identifier);
        SwingInvoker.invokeAndWait(new Runnable(){

            public void run() {
                operator.selectItems(ListKeywords.this.intoList(listItemIdentifier, additionalItemIdentifiers));
            }
        });
    }

    private List<String> intoList(final String listItemIdentifier, String[] additionalItemIdentifiers) {
        ArrayList<String> itemIdentifiers = new ArrayList<String>(){
            {
                this.add(listItemIdentifier);
            }
        };
        CollectionUtils.addAll((Collection)itemIdentifiers, additionalItemIdentifiers);
        return itemIdentifiers;
    }

    @RobotKeyword(value="Clicks on a list item.\n\nExamples:\n| Click On List Item | _myList_ | _myItem_ |\n| Click On List Item | _myList_ | _0_      | \n\nAn optional _click count_ parameter can be provided for example if a double click is required.\nDefault click count is one:\n| Click On List Item | _myList_ | _myItem_ | _2_ | # doubleclicks on item |\n")
    @ArgumentNames(value={"identifier", "listItemIdentifier", "clickCount=1"})
    public void clickOnListItem(String identifier, String listItemIdentifier, String[] clickCount) {
        this.createOperator(identifier).clickOnItem(listItemIdentifier, this.extractIntArgument(clickCount));
    }

    @RobotKeyword(value="Returns the item that's currently selected in the list.\n\nExample:\n| ${listItem}=    | Get Selected Value From List | _myList_      |\n| Should Be Equal | _Expected Item_              | _${listItem}_ |\n")
    @ArgumentNames(value={"identifier"})
    public Object getSelectedValueFromList(String identifier) {
        return this.createOperator(identifier).getSelectedValue();
    }

    @RobotKeyword(value="Returns the number of items contained in list.\n\nExample:\n| ${listItemCount}=    | Get List Item Count | _myList_      |\n| Should Be Equal As Integers | _2_ | _${listItemCount}_ |\n")
    @ArgumentNames(value={"identifier"})
    public int getListItemCount(String identifier) {
        return this.createOperator(identifier).getSize();
    }

    @RobotKeyword(value="Selects all list items.\n\nExample:\n| Select All List Items | _My List_ |\n")
    @ArgumentNames(value={"identifier"})
    public void selectAllListItems(String identifier) {
        this.createOperator(identifier).selectAll();
    }

    @RobotKeyword(value="Returns all values from a list.\n\nExample:\n| ${values}= | Get List Values | _myList_ |\n| Should Be Equal | ${values} | one, two, three |\n")
    @ArgumentNames(value={"identifier"})
    public List<String> getListValues(String identifier) {
        return this.createOperator(identifier).getListValues();
    }

    @RobotKeyword(value="Fails if value not in list.\n\nExample:\n| List Should Contain | _myList_ | item |\n")
    @ArgumentNames(value={"identifier", "value"})
    public void listShouldContain(String identifier, String value) {
        Assert.assertTrue("List " + identifier + " does not contain " + value, this.getListValues(identifier).contains(value));
    }

    @RobotKeyword(value="Fails if value is in list.\n\nExample:\n| List Should Not Contain | _myList_ | item |\n")
    @ArgumentNames(value={"identifier", "value"})
    public void listShouldNotContain(String identifier, String value) {
        Assert.assertTrue("List " + identifier + " contains " + value, !this.getListValues(identifier).contains(value));
    }

    private ListOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

