/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.radiobutton;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.button.AbstractButtonOperator;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.radiobutton.RadioButtonOperatorFactory;

@RobotKeywords
public class RadioButtonKeywords {
    private OperatorFactory<AbstractButtonOperator> operatorFactory = new RadioButtonOperatorFactory();

    @RobotKeyword(value="Uses current context to search for a radiobutton and when found, pushes it.\n\nExample:\n| Select Radio Button | _My Radio Button_ |\n")
    @ArgumentNames(value={"identifier"})
    public void pushRadioButton(String identifier) {
        this.createOperator(identifier).push();
    }

    @RobotKeyword(value="*DEPRECATED* Use keyword `Push Radio Button` instead.\n")
    @ArgumentNames(value={"identifier"})
    public void selectRadioButton(String identifier) {
        this.pushRadioButton(identifier);
    }

    @RobotKeyword(value="Fails if radiobutton is not selected.\n\nExample:\n| Radio Button Should Be Selected | _My Radio Button_ |\n")
    @ArgumentNames(value={"identifier"})
    public void radioButtonShouldBeSelected(String identifier) {
        boolean isSelected = this.createOperator(identifier).isSelected();
        Assert.assertTrue("Radio Button '" + identifier + "' is not selected.", isSelected);
    }

    @RobotKeyword(value="Fails if radiobutton is selected.\n\nExample:\n| Radio Button Should Not Be Selected | _My Radio Button_ |\n")
    @ArgumentNames(value={"identifier"})
    public void radioButtonShouldNotBeSelected(String identifier) {
        boolean isSelected = this.createOperator(identifier).isSelected();
        Assert.assertFalse("Radio Button '" + identifier + "' is selected.", isSelected);
    }

    @RobotKeyword(value="Fails if radiobutton is disabled.\n\nExample:\n| Radio Button Should Be Enabled | _My Radio Button_ |\n")
    @ArgumentNames(value={"identifier"})
    public void radioButtonShouldBeEnabled(String identifier) {
        boolean isEnabled = this.createOperator(identifier).isEnabled();
        Assert.assertTrue("Radio Button '" + identifier + "' is disabled.", isEnabled);
    }

    @RobotKeyword(value="Fails if radiobutton is enabled.\n\nExample:\n| Radio Button Should Be Disabled | _My Radio Button_ |\n")
    @ArgumentNames(value={"identifier"})
    public void radioButtonShouldBeDisabled(String identifier) {
        boolean isEnabled = this.createOperator(identifier).isEnabled();
        Assert.assertFalse("Radio Button '" + identifier + "' is enabled.", isEnabled);
    }

    private AbstractButtonOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

