/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.timeout;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;

@RobotKeywords
public class TimeoutKeywords {
    public static final String[] JEMMY_TIMEOUTS = new String[]{"DialogWaiter.WaitDialogTimeout", "FrameWaiter.WaitFrameTimeout", "WindowWaiter.WaitWindowTimeout", "ComponentOperator.WaitComponentTimeout", "JMenuOperator.WaitPopupTimeout", "JTreeOperator.WaitNodeExpandedTimeout", "JTreeOperator.WaitNextNodeTimeout", "JTreeOperator.WaitNodeVisibleTimeout", "ComponentOperator.WaitStateTimeout", "JComboBoxOperator.WaitListTimeout", "JComboboxOperator.WaitGetSelectedItemTimeout", "JListOperator.WaitFindItemIndexTimeout"};

    @RobotKeyword(value="Sets the jemmy timeout used for waiting a component to appear.\nTimeout names are listed here: http://jemmy.java.net/OperatorsEnvironment.html#timeouts\nReturns the old timeout setting value.\n\nExample:\n| Set Jemmy Timeout | DialogWaiter.WaitDialogTimeout | 3 |\n| ${oldSetting}= | Set Jemmy Timeout | DialogWaiter.WaitDialogTimeout | 3 |\n")
    @ArgumentNames(value={"timeoutName", "timeoutInSeconds"})
    public long setJemmyTimeout(String timeoutName, String timeoutInSeconds) {
        long oldTimeout = JemmyProperties.getCurrentTimeout(timeoutName);
        JemmyProperties.setCurrentTimeout(timeoutName, this.parseMillis(timeoutInSeconds));
        return oldTimeout / 1000L;
    }

    @RobotKeyword(value="Sets all relevant jemmy timeouts. \nBy default they are all set to 5 seconds.\n\nList of all the timeouts this keywords sets:\n| *Timeout Name* | *Description* |\n| DialogWaiter.WaitDialogTimeout | Time to wait dialog displayed |\n| FrameWaiter.WaitFrameTimeout | Time to wait frame displayed |\n| WindowWaiter.WaitWindowTimeout | Time to wait window displayed |\n| ComponentOperator.WaitComponentTimeout | Time to wait component displayed |\n| ComponentOperator.WaitStateTimeout | Used for example in combobox selection |\n| JComboboxOperator.WaitGetSelectedItemTimeout | Time to wait for combobox selected item fetching |\n| JComboBoxOperator.WaitListTimeout | Time to wait list opened | \n| JMenuOperator.WaitPopupTimeout | Time to wait popup displayed |\n| JTreeOperator.WaitNodeExpandedTimeout | Time to wait node expanded |\n| JTreeOperator.WaitNextNodeTimeout | Time to wait next node displayed |\n| JTreeOperator.WaitNodeVisibleTimeout | Time to wait node visible |\n| JListOperator.WaitFindItemIndexTimeout | Time to wait for list item to appear |\n\nExample:\n| Set Jemmy Timeouts | 3 |\n")
    @ArgumentNames(value={"timeoutInSeconds"})
    public void setJemmyTimeouts(String timeoutInSeconds) {
        for (String timeout : JEMMY_TIMEOUTS) {
            JemmyProperties.setCurrentTimeout(timeout, this.parseMillis(timeoutInSeconds));
        }
    }

    private long parseMillis(String timeoutInSeconds) {
        return Long.parseLong(timeoutInSeconds) * 1000L;
    }
}

