/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.tree.TreeNodeExistenceResolver;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeExistenceKeywords
extends TreeSupport {
    @RobotKeyword(value="Fails if the tree node does not exist.\n\nExample:\n| Tree Node Should Exist | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldExist(String identifier, String nodeIdentifier) {
        boolean treeNodeExists = this.createExistenceResolver(identifier).treeNodeExists(nodeIdentifier);
        Assert.assertTrue("Tree node '" + nodeIdentifier + "' doesn't exist.", treeNodeExists);
    }

    @RobotKeyword(value="Fails if the tree node exists.\n\nExample:\n| Tree Node Should Not Exist | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldNotExist(String identifier, String nodeIdentifier) {
        boolean treeNodeExists = this.createExistenceResolver(identifier).treeNodeExists(nodeIdentifier);
        Assert.assertFalse("Tree node '" + nodeIdentifier + "' exists.", treeNodeExists);
    }

    TreeNodeExistenceResolver createExistenceResolver(String treeIdentifier) {
        return new TreeNodeExistenceResolver(this.treeOperator(treeIdentifier));
    }
}

