/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodeVisibilityKeywords
extends TreeSupport {
    @RobotKeyword(value="Fails if the tree node is not visible.\n\nExample:\n| Tree Node Should Be Visible | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldBeVisible(String identifier, String nodePath) {
        Assert.assertTrue("Tree node '" + nodePath + "' is not visible.", this.isVisible(identifier, nodePath));
    }

    @RobotKeyword(value="Fails if the tree node is visible.\n\nExample:\n| Tree Node Should Not Be Visible | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldNotBeVisible(String identifier, String nodePath) {
        Assert.assertFalse("Tree node '" + nodePath + "' is visible.", this.isVisible(identifier, nodePath));
    }

    private boolean isVisible(String identifier, String nodePath) {
        this.verifyPath(nodePath);
        return this.treeOperator(identifier).isVisible(nodePath);
    }

    private void verifyPath(String nodePath) {
        if (this.isIndex(nodePath)) {
            throw new IllegalArgumentException("Node's visibility cannot be checked by it's index.");
        }
    }
}

