/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp.examplesut;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TodoListApplication {
    private JPanel panel;
    private JFrame frame;
    private JList todoItemsList;
    private boolean introduceBugs;
    private List<String> todoItems = new ArrayList<String>();

    public TodoListApplication(boolean introduceBugs) {
        this.introduceBugs = introduceBugs;
        this.createFrame();
        this.createMainPanel();
        this.addComponentsToMainPanel();
        this.addMainPanelToFrame();
    }

    public void display() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TodoListApplication.this.frame.pack();
                TodoListApplication.this.frame.setVisible(true);
            }
        });
    }

    private void createFrame() {
        this.frame = new JFrame("Todo List");
        this.frame.setPreferredSize(new Dimension(300, 300));
        this.frame.setDefaultCloseOperation(3);
    }

    private void addMainPanelToFrame() {
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.panel, "Center");
    }

    private void createMainPanel() {
        this.panel = new JPanel();
        this.panel.setName("Main Panel");
        this.panel.setLayout(new BorderLayout());
    }

    private void addComponentsToMainPanel() {
        this.createUsernameInput();
        this.createUsersList();
    }

    private void createUsernameInput() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(new JLabel("Description:  "));
        JTextField textField = this.usernameField();
        topPanel.add(textField);
        topPanel.add(this.submitButton(textField));
        this.panel.add((Component)topPanel, "North");
    }

    private JButton submitButton(final JTextField textField) {
        JButton submitButton = new JButton("Add Todo item"){
            {
                super(x0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        TodoListApplication.this.todoItems.add(textField.getText());
                        TodoListApplication.this.updateTodoItems();
                    }
                });
            }
        };
        submitButton.setName("add");
        return submitButton;
    }

    private void updateTodoItems() {
        this.todoItemsList.setListData(this.todoItems.toArray());
    }

    private JTextField usernameField() {
        JTextField textField = new JTextField();
        textField.setName("description");
        return textField;
    }

    private void createUsersList() {
        JPanel usersPanel = this.usersPanel();
        usersPanel.add((Component)this.usersList(), "Center");
        usersPanel.add((Component)this.deleteButton(), "South");
        this.panel.add((Component)usersPanel, "Center");
    }

    private JList usersList() {
        this.todoItemsList = new JList();
        this.todoItemsList.setName("todolist");
        this.updateTodoItems();
        return this.todoItemsList;
    }

    private JPanel usersPanel() {
        JPanel listPane = new JPanel();
        listPane.setLayout(new BorderLayout());
        listPane.add((Component)new JLabel("Todo items:"), "North");
        return listPane;
    }

    private JPanel deleteButton() {
        JPanel deleteButtonPane = new JPanel();
        deleteButtonPane.setLayout(new BorderLayout());
        JButton deleteButton = new JButton("Delete"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        TodoListApplication.this.removeTodoItem();
                    }
                });
            }
        };
        deleteButton.setName("delete");
        deleteButtonPane.add((Component)deleteButton, "East");
        return deleteButtonPane;
    }

    private void removeTodoItem() {
        Object possibleSelection = this.todoItemsList.getSelectedValue();
        if (this.introduceBugs || possibleSelection != null) {
            this.todoItems.remove(possibleSelection.toString());
            this.updateTodoItems();
        }
    }

    public static void main(String[] args) {
        new TodoListApplication(false).display();
    }
}

