/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.textcomponent;

import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.robotframework.org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.robotframework.swing.textcomponent.HtmlElement;
import org.robotframework.swing.textcomponent.LinkNotFoundException;

public class HyperlinkEventFactory {
    private final JEditorPane editorPane;
    private final HTMLDocument document;

    public HyperlinkEventFactory(JEditorPaneOperator editorPaneOperator) {
        this.editorPane = (JEditorPane)editorPaneOperator.getSource();
        this.document = (HTMLDocument)editorPaneOperator.getDocument();
    }

    public HyperlinkEvent createHyperLinkEvent(String linkText) {
        HtmlElement linkElement = this.findElement(linkText);
        URL url = linkElement.getUrl();
        String description = linkElement.getHref();
        return new HyperlinkEvent(this.editorPane, HyperlinkEvent.EventType.ACTIVATED, url, description, linkElement);
    }

    private HtmlElement findElement(String linkText) {
        Element[] rootElements;
        for (Element element : rootElements = this.document.getRootElements()) {
            try {
                this.findElement(new HtmlElement(element), linkText);
            }
            catch (ElementFound finding) {
                return finding.element;
            }
        }
        throw new LinkNotFoundException("Hyperlink '" + linkText + "' was not found");
    }

    private void findElement(HtmlElement element, String linkText) throws ElementFound {
        for (int i = 0; i < element.getElementCount(); ++i) {
            this.findElement(element.getChild(i), linkText);
        }
        if (linkText.equals(element.getText())) {
            throw new ElementFound(element);
        }
    }

    private static class ElementFound
    extends Exception {
        final HtmlElement element;

        public ElementFound(Element element) {
            this.element = new HtmlElement(element);
        }
    }
}

