/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.editor.widgets;

import org.robotframework.abbot.i18n.Strings;

public class TextFormat {
    public static final int TOOLTIP_WRAP = 50;
    public static final int DIALOG_WRAP = 60;

    public static String wordBreak(String phrase) {
        StringBuffer words = new StringBuffer(phrase);
        for (int i = 0; i < words.length() - 1; ++i) {
            char up = words.charAt(i + 1);
            if (!Character.isUpperCase(up) || i != words.length() - 2 && !Character.isLowerCase(words.charAt(i + 2))) continue;
            words.insert(++i, ' ');
        }
        return words.toString();
    }

    public static String wordWrap(String msg, int wrapAt, String lineSep) {
        if (msg == null) {
            return null;
        }
        int len = msg.length();
        StringBuffer sb = new StringBuffer(len * 3 / 2);
        for (int pos = 0; pos < len; ++pos) {
            int col;
            char ch;
            while (pos < len && Character.isWhitespace(ch = msg.charAt(pos))) {
                if (ch == '\n') {
                    sb.append(lineSep);
                }
                ++pos;
            }
            int lastWhite = -1;
            boolean nonwhite = false;
            for (col = 0; pos + col < len && col <= wrapAt; ++col) {
                ch = msg.charAt(pos + col);
                if (Character.isWhitespace(ch)) {
                    if (lastWhite == -1 || nonwhite) {
                        lastWhite = pos + col;
                    }
                    if (ch != '\n') continue;
                    break;
                }
                nonwhite = true;
            }
            if (pos + col == len) {
                while (pos < len) {
                    sb.append(msg.charAt(pos));
                    ++pos;
                }
                break;
            }
            if (lastWhite != -1) {
                while (pos < lastWhite) {
                    sb.append(msg.charAt(pos));
                    ++pos;
                }
            } else {
                while (pos < len && !Character.isWhitespace(ch = msg.charAt(pos))) {
                    sb.append(ch);
                    ++pos;
                }
                if (pos == len) break;
            }
            sb.append(lineSep);
        }
        return sb.toString();
    }

    public static String tooltip(String tip) {
        tip = tip.startsWith("<html>") ? tip.substring(6, tip.length() - 7) : TextFormat.wordWrap(tip, 50, "<br>");
        return Strings.get("TooltipFormat", new Object[]{tip});
    }

    public static String dialog(String msg) {
        msg = msg.startsWith("<html>") ? msg.substring(6, msg.length() - 7) : TextFormat.wordWrap(msg, 60, "<br>");
        return Strings.get("DialogFormat", new Object[]{msg});
    }
}

