/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.finder;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.robotframework.abbot.finder.AWTHierarchy;
import org.robotframework.abbot.finder.ComponentFinder;
import org.robotframework.abbot.finder.ComponentNotFoundException;
import org.robotframework.abbot.finder.Hierarchy;
import org.robotframework.abbot.finder.Matcher;
import org.robotframework.abbot.finder.MultiMatcher;
import org.robotframework.abbot.finder.MultipleComponentsFoundException;
import org.robotframework.abbot.i18n.Strings;

public class BasicFinder
implements ComponentFinder {
    private Hierarchy hierarchy;
    private static final ComponentFinder DEFAULT = new BasicFinder(new AWTHierarchy());

    public static ComponentFinder getDefault() {
        return DEFAULT;
    }

    public BasicFinder() {
        this(AWTHierarchy.getDefault());
    }

    public BasicFinder(Hierarchy h) {
        this.hierarchy = h;
    }

    protected Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Component find(Container root, Matcher m) throws ComponentNotFoundException, MultipleComponentsFoundException {
        Hierarchy h = root != null ? new SingleComponentHierarchy(root) : this.getHierarchy();
        return this.find(h, m);
    }

    public Component find(Matcher m) throws ComponentNotFoundException, MultipleComponentsFoundException {
        return this.find(this.getHierarchy(), m);
    }

    protected Component find(Hierarchy h, Matcher m) throws ComponentNotFoundException, MultipleComponentsFoundException {
        HashSet found = new HashSet();
        Iterator iter = h.getRoots().iterator();
        while (iter.hasNext()) {
            this.findMatches(h, m, (Component)iter.next(), found);
        }
        if (found.size() == 0) {
            String msg = Strings.get("finder.not_found", new Object[]{m.toString()});
            throw new ComponentNotFoundException(msg);
        }
        if (found.size() > 1) {
            Component[] list = found.toArray(new Component[found.size()]);
            if (!(m instanceof MultiMatcher)) {
                String msg = Strings.get("finder.multiple_found", new Object[]{m.toString()});
                throw new MultipleComponentsFoundException(msg, list);
            }
            return ((MultiMatcher)m).bestMatch(list);
        }
        return (Component)found.iterator().next();
    }

    protected void findMatches(Hierarchy h, Matcher m, Component c, Set found) {
        if (found.size() == 1 && !(m instanceof MultiMatcher)) {
            return;
        }
        Iterator iter = h.getComponents(c).iterator();
        while (iter.hasNext()) {
            this.findMatches(h, m, (Component)iter.next(), found);
        }
        if (m.matches(c)) {
            found.add(c);
        }
    }

    private class SingleComponentHierarchy
    implements Hierarchy {
        private Component root;
        private ArrayList list = new ArrayList();

        public SingleComponentHierarchy(Container root) {
            this.root = root;
            this.list.add(root);
        }

        public Collection getRoots() {
            return this.list;
        }

        public Collection getComponents(Component c) {
            return BasicFinder.this.getHierarchy().getComponents(c);
        }

        public Container getParent(Component c) {
            return BasicFinder.this.getHierarchy().getParent(c);
        }

        public boolean contains(Component c) {
            return BasicFinder.this.getHierarchy().contains(c) && SwingUtilities.isDescendingFrom(c, this.root);
        }

        public void dispose(Window w) {
            BasicFinder.this.getHierarchy().dispose(w);
        }
    }
}

