/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.util;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.Platform;
import org.robotframework.abbot.finder.AWTHierarchy;
import org.robotframework.abbot.finder.BasicFinder;
import org.robotframework.abbot.finder.ComponentSearchException;
import org.robotframework.abbot.finder.Hierarchy;
import org.robotframework.abbot.finder.Matcher;
import org.robotframework.abbot.finder.matchers.ClassMatcher;
import org.robotframework.abbot.tester.AWTConstants;
import org.robotframework.abbot.tester.Robot;
import org.robotframework.abbot.util.Bugs;
import org.robotframework.abbot.util.ExtendedComparator;
import org.robotframework.abbot.util.Properties;
import org.robotframework.abbot.util.Reflector;
import org.robotframework.abbot.util.Regexp;
import sun.awt.AppContext;

public class AWT {
    public static int POPUP_TIMEOUT = 5000;
    private static Hierarchy hierarchy = new AWTHierarchy();
    private static final Point RELATIVE_OFFSET;
    public static final String CONTAINS_HEAVYWEIGHT_COMPONENT = "containsHeavyweightComponent";
    public static final Point DEFAULT_CASCADE;
    private static final int SCREEN_MARGIN = 10;
    private static final boolean POPUP_ON_BUTTON2 = false;
    private static final PopupMenu[] NO_POPUPS;
    static final String ROOT_FRAME_CLASSNAME;
    private static final Matcher POPUP_MATCHER;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$AWTEvent;
    static /* synthetic */ Class class$javax$swing$SwingUtilities;
    static /* synthetic */ Class class$javax$swing$JPopupMenu;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$java$awt$event$InputEvent;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public static boolean onScreen(Point p) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = env.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            GraphicsConfiguration[] gc = gs[i].getConfigurations();
            for (int j = 0; j < gc.length; ++j) {
                Rectangle r = AWT.getVisibleBounds(gc[j]);
                if (!r.contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean onScreen(Window w) {
        return AWT.onScreen(w.getLocation()) || AWT.onScreen(new Point(w.getX() + w.getWidth() - 1, w.getY()));
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Point p) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = env.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            GraphicsConfiguration[] gc = gs[i].getConfigurations();
            Rectangle bounds = AWT.getVisibleBounds(gc[i]);
            if (!bounds.contains(p)) continue;
            return gc[i];
        }
        return null;
    }

    public static Rectangle getVirtualDisplayBounds(boolean includeInsets) {
        Rectangle bounds = null;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = env.getScreenDevices();
        for (int i = 0; i < gs.length; ++i) {
            GraphicsConfiguration[] gc = gs[i].getConfigurations();
            for (int j = 0; j < gc.length; ++j) {
                Rectangle r = includeInsets ? gc[j].getBounds() : AWT.getVisibleBounds(gc[j]);
                bounds = bounds == null ? r : bounds.union(r);
            }
        }
        return bounds;
    }

    public static Rectangle getVisibleBounds(GraphicsConfiguration gc) {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle r = gc.getBounds();
        r.x += insets.left;
        r.y += insets.top;
        r.width -= insets.left + insets.right;
        r.height -= insets.top + insets.bottom;
        return r;
    }

    public static void ensureOnScreen(Window w) {
        if (!AWT.onScreen(w)) {
            Rectangle bounds = AWT.getVirtualDisplayBounds(false);
            int x = w.getX();
            int y = w.getY();
            if (w.getX() + w.getWidth() < bounds.x + 10) {
                x = bounds.x + 10 - w.getWidth();
            }
            if (w.getX() > bounds.x + bounds.width + 10) {
                x = bounds.x + bounds.width - 10;
            }
            if (w.getY() < bounds.y + 10) {
                y = bounds.y + 10;
            }
            if (w.getY() > bounds.y + bounds.height + 10) {
                y = bounds.y + bounds.height - 10;
            }
            w.setLocation(x, y);
            if (!AWT.onScreen(w)) {
                AWT.centerOnScreen(w);
            }
        }
    }

    public static void setLocationByPlatform(Window w) {
        try {
            Method m = (class$java$awt$Window == null ? (class$java$awt$Window = AWT.class$("java.awt.Window")) : class$java$awt$Window).getDeclaredMethod("setLocationByPlatform", Boolean.TYPE);
            m.invoke((Object)w, Boolean.TRUE);
        }
        catch (Exception e) {
            AWT.centerOnScreen(w);
        }
    }

    public static void setHTMLPreferredWidth(JComponent c, int width) {
        c.addPropertyChangeListener("ancestor", new PropertyChangeListener(){
            final int PREF_WIDTH = 200;

            public void propertyChange(PropertyChangeEvent e) {
                JComponent c = (JComponent)e.getSource();
                c.removePropertyChangeListener("ancestor", this);
                final View view = (View)c.getClientProperty("html");
                if (view != null) {
                    final float prefx = view.getPreferredSpan(0);
                    final float prefy = view.getPreferredSpan(1);
                    view.setSize(Math.min(200.0f, prefx), prefy);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            view.setSize(prefx, prefy);
                        }
                    });
                }
            }
        });
    }

    public static Color combine(Color c1, Color c2) {
        return AWT.combine(c1, c2, 0.5f);
    }

    public static Color combine(Color c1, Color c2, float weight) {
        float w1 = (float)Math.max(Math.min((double)weight, 1.0), 0.0);
        float w2 = 1.0f - w1;
        return new Color((int)((float)c1.getRed() * w1 + (float)c2.getRed() * w2), (int)((float)c1.getGreen() * w1 + (float)c2.getGreen() * w2), (int)((float)c1.getBlue() * w1 + (float)c2.getBlue() * w2), (int)((float)c1.getAlpha() * w1 + (float)c2.getAlpha() * w2));
    }

    public static boolean isMenuActive(Component c) {
        JFrame frame;
        JMenuBar mb;
        Frame f = AWT.getFrame(c);
        if (f instanceof JFrame && (mb = (frame = (JFrame)f).getJMenuBar()) != null) {
            for (int i = 0; i < mb.getMenuCount(); ++i) {
                JMenu menu = mb.getMenu(i);
                if (menu == null || !menu.isSelected() && !menu.isPopupMenuVisible()) continue;
                return true;
            }
        }
        return false;
    }

    public static void showFrameRelative(Frame frame, Component relativeTo) {
        AWT.moveFrameRelativeTo(frame, relativeTo);
        if (frame.getState() == 1) {
            frame.setState(0);
        }
        frame.show();
    }

    public static void centerOnScreen(Window window) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Rectangle max = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int x = Math.max(center.x - Math.round((float)window.getWidth() / 2.0f), max.x);
        int y = Math.max(center.y - Math.round((float)window.getHeight() / 2.0f), max.y);
        window.setLocation(new Point(x, y));
    }

    public static void centerOnFrame(Window window, Frame frame) {
        int ww = window.getWidth();
        int wh = window.getHeight();
        int fw = frame.getWidth();
        int fh = frame.getHeight();
        int x = (int)Math.round((double)(fw - ww) / 2.0);
        int y = (int)Math.round((double)(fh - wh) / 2.0);
        Point location = frame.getLocationOnScreen();
        location.translate(x, y);
        window.setLocation(location);
        AWT.ensureOnScreen(window);
    }

    public static void moveFrameRelativeTo(Frame frame, Component relativeTo) {
        Point location = RELATIVE_OFFSET;
        Window reference = null;
        if (relativeTo != null) {
            reference = AWT.getWindow(relativeTo);
        }
        if (reference != null) {
            location = reference.getLocationOnScreen();
            location.translate(AWT.RELATIVE_OFFSET.x, AWT.RELATIVE_OFFSET.y);
        }
        frame.setLocation(location);
        AWT.ensureOnScreen(frame);
    }

    public static boolean containsFocus(Component c) {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component owner = mgr.getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    public static Window getFocusedWindow() {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return mgr.getFocusedWindow();
    }

    public static Window getActiveWindow() {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return mgr.getActiveWindow();
    }

    private static boolean containsHeavyweightComponent(Component root) {
        if (root instanceof Container) {
            if (root instanceof JComponent && Boolean.TRUE.equals(((JComponent)root).getClientProperty(CONTAINS_HEAVYWEIGHT_COMPONENT))) {
                return true;
            }
            Container c = (Container)root;
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (!AWT.containsHeavyweightComponent(c.getComponents()[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hierarchyHasHeavyweightComponent(Component base) {
        Window w = AWT.getWindow(base);
        return AWT.containsHeavyweightComponent(w);
    }

    public static Frame getFrame(Object o) {
        Window w;
        for (w = AWT.getWindow(o); !(w instanceof Frame) && w != null; w = (Window)w.getParent()) {
        }
        return w instanceof Frame ? (Frame)w : JOptionPane.getRootFrame();
    }

    public static Window getWindow(Object o) {
        if (o instanceof Component) {
            Component c = (Component)o;
            while (c instanceof JMenuItem) {
                c = c.getParent();
            }
            if (c instanceof JPopupMenu) {
                return AWT.getWindow(((JPopupMenu)c).getInvoker());
            }
            return c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
        }
        return JOptionPane.getRootFrame();
    }

    public static Color alpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Component find(Component root, final Class type) {
        return AWT.find(root, new ComponentPredicate(){

            public boolean evaluate(Component o) {
                return o != null && type.isAssignableFrom(o.getClass());
            }
        });
    }

    public static void cascade(Window w) {
        AWT.cascade(w, AWT.DEFAULT_CASCADE.x, AWT.DEFAULT_CASCADE.y);
    }

    public static void cascade(Window w, int xoff, int yoff) {
        Frame f = AWT.getFrame(AWT.getActiveWindow());
        if (f != null && f.isShowing()) {
            w.setLocation(f.getX() + xoff, f.getY() + yoff);
            AWT.ensureOnScreen(w);
        } else {
            AWT.centerOnScreen(w);
        }
    }

    public static Component find(Component root, ComponentPredicate test) {
        if (test.evaluate(root)) {
            return root;
        }
        if (root instanceof Container) {
            Component[] kids = ((Container)root).getComponents();
            for (int i = 0; i < kids.length; ++i) {
                Component c = AWT.find(kids[i], test);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public static RootPaneContainer findRootPaneContainer(Container c) {
        if (c instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)c);
        }
        Component[] kids = c.getComponents();
        for (int i = 0; i < kids.length; ++i) {
            RootPaneContainer rcp;
            if (kids[i] instanceof RootPaneContainer) {
                return (RootPaneContainer)((Object)kids[i]);
            }
            if (!(kids[i] instanceof Container) || (rcp = AWT.findRootPaneContainer((Container)kids[i])) == null) continue;
            return rcp;
        }
        return null;
    }

    private AWT() {
    }

    public static boolean hasDefaultName(Component c) {
        String name = AWT.getName(c);
        if (name == null) {
            return true;
        }
        if (c instanceof JComponent) {
            return c instanceof JLayeredPane && "null.layeredPane".equals(name) || c instanceof JPanel && ("null.glassPane".equals(name) || "null.contentPane".equals(name));
        }
        return c instanceof Button && Regexp.stringMatch("button[0-9]+", name) || c instanceof Canvas && Regexp.stringMatch("canvas[0-9]+", name) || c instanceof Checkbox && Regexp.stringMatch("checkbox[0-9]+", name) || c instanceof Choice && Regexp.stringMatch("choice[0-9]+", name) || c instanceof Dialog && Regexp.stringMatch("dialog[0-9]+", name) || c instanceof FileDialog && Regexp.stringMatch("filedlg[0-9]+", name) || c instanceof Frame && Regexp.stringMatch("frame[0-9]+", name) || c instanceof List && Regexp.stringMatch("list[0-9]+", name) || c instanceof Label && Regexp.stringMatch("label[0-9]+", name) || c instanceof Panel && Regexp.stringMatch("panel[0-9]+", name) || c instanceof Scrollbar && Regexp.stringMatch("scrollbar[0-9]+", name) || c instanceof ScrollPane && Regexp.stringMatch("scrollpane[0-9]+", name) || c instanceof TextArea && Regexp.stringMatch("text[0-9]+", name) || c instanceof TextField && Regexp.stringMatch("textfield[0-9]+", name) || c instanceof Window && Regexp.stringMatch("win[0-9]+", name);
    }

    public static void invokeAndWait(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            try {
                EventQueue.invokeAndWait(action);
            }
            catch (InterruptedException ie) {
                Log.warn(ie);
            }
            catch (InvocationTargetException ite) {
                Log.warn(ite);
            }
        }
    }

    public static void invokeAction(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            EventQueue.invokeLater(action);
        }
    }

    public static boolean isOnMenuBar(MenuComponent mc) {
        if (mc instanceof MenuBar) {
            return true;
        }
        return mc.getParent() instanceof MenuComponent && AWT.isOnMenuBar((MenuComponent)((Object)mc.getParent()));
    }

    public static Component getInvoker(MenuComponent mc) {
        if (AWT.isOnMenuBar(mc)) {
            return null;
        }
        MenuContainer parent = mc.getParent();
        while (parent instanceof MenuComponent) {
            parent = ((MenuComponent)((Object)parent)).getParent();
        }
        return parent instanceof Component ? (Component)parent : null;
    }

    public static Component getInvoker(Component comp) {
        if (comp instanceof JPopupMenu) {
            return ((JPopupMenu)comp).getInvoker();
        }
        return (comp = comp.getParent()) != null ? AWT.getInvoker(comp) : null;
    }

    public static Window getWindow(Component comp) {
        Component invoker;
        if (comp == null) {
            return null;
        }
        if (comp instanceof Window) {
            return (Window)comp;
        }
        if (comp instanceof MenuElement && (invoker = AWT.getInvoker(comp)) != null) {
            return AWT.getWindow(invoker);
        }
        return AWT.getWindow(hierarchy.getParent(comp));
    }

    public static boolean isAWTPopupMenuBlocking() {
        return Bugs.showAWTPopupMenuBlocks() && AWT.isAWTTreeLockHeld();
    }

    private static boolean isAWTTreeLockHeld() {
        return AWT.isAWTTreeLockHeld(Toolkit.getDefaultToolkit().getSystemEventQueue());
    }

    public static boolean isAWTTreeLockHeld(EventQueue eq) {
        Frame[] frames = Frame.getFrames();
        if (frames.length == 0) {
            return false;
        }
        ThreadStateChecker checker = new ThreadStateChecker(frames[0].getTreeLock());
        try {
            checker.start();
            int delay = Properties.getProperty("org.robotframework.abbot.treelock_wait", 100, 0, 60000);
            if (checker.isAlive()) {
                checker.join(delay);
            }
            return checker.isAlive();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void dismissAWTPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        java.awt.Robot robot = Robot.getRobot();
        if (robot != null) {
            Window w;
            Component c = AWT.getFocusOwner();
            if (c != null && (w = AWT.getWindow(c)) != null && w.isShowing()) {
                robot.keyPress(27);
                robot.keyRelease(27);
            }
        } else {
            Log.warn("The current system configuation can not automatically dismiss an AWT popup");
        }
    }

    public static boolean isOnPopup(MenuComponent mc) {
        MenuContainer parent = mc.getParent();
        while (parent instanceof MenuComponent) {
            if (parent instanceof MenuBar) {
                return false;
            }
            parent = ((MenuComponent)((Object)parent)).getParent();
        }
        return true;
    }

    public static boolean isOnPopup(Component comp) {
        boolean isWrapper = AWT.isTransientPopup(comp);
        Component invoker = AWT.getInvoker(comp);
        boolean isOnJMenu = invoker instanceof JMenu && invoker.getParent() instanceof JMenuBar;
        return isWrapper || invoker != null && !isOnJMenu;
    }

    public static boolean isHeavyweightPopup(Component c) {
        if (c instanceof Window && !(c instanceof Dialog) && !(c instanceof Frame)) {
            String name = AWT.getName(c);
            String cname = c.getClass().getName();
            return "###overrideRedirect###".equals(name) || "###focusableSwingPopup###".equals(name) || cname.indexOf("PopupFactory$WindowPopup") != -1 || cname.indexOf("HeavyWeightWindow") != -1;
        }
        return false;
    }

    private static String getName(Component c) {
        try {
            return c.getName();
        }
        catch (Throwable e) {
            Log.warn(e);
            return null;
        }
    }

    public static boolean isLightweightPopup(Component c) {
        if (c instanceof JPanel) {
            Window w = SwingUtilities.getWindowAncestor(c);
            if (w != null && AWT.isHeavyweightPopup(w)) {
                return false;
            }
            JPanel panel = (JPanel)c;
            Container parent = panel.getParent();
            if (parent != null && parent instanceof JLayeredPane) {
                int layer = JLayeredPane.POPUP_LAYER;
                if (JLayeredPane.getLayer(panel) == layer) {
                    return true;
                }
            }
            return panel.getComponentCount() == 1 && panel.getComponents()[0] instanceof JPopupMenu;
        }
        return false;
    }

    public static boolean isContentPane(Component c) {
        if (c.getParent() instanceof JLayeredPane) {
            JLayeredPane p = (JLayeredPane)c.getParent();
            if (p.getParent() instanceof JRootPane) {
                return ((JRootPane)p.getParent()).getContentPane() == c;
            }
            int layer = JLayeredPane.FRAME_CONTENT_LAYER;
            return p.getLayer(c) == layer && !(c instanceof JMenuBar);
        }
        return false;
    }

    public static boolean isGlassPane(Component c) {
        if (c.getParent() instanceof JRootPane) {
            JRootPane p = (JRootPane)c.getParent();
            return p.getGlassPane() == c;
        }
        return false;
    }

    public static boolean isTransientPopup(Component c) {
        return AWT.isLightweightPopup(c) || AWT.isHeavyweightPopup(c);
    }

    private static boolean containsToolTip(Component c) {
        if (c instanceof JToolTip) {
            return true;
        }
        if (c instanceof Container) {
            Component[] kids = ((Container)c).getComponents();
            for (int i = 0; i < kids.length; ++i) {
                if (!AWT.containsToolTip(kids[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isToolTip(Component c) {
        return AWT.isTransientPopup(c) && AWT.containsToolTip(c);
    }

    public static boolean isInternalFrameDecoration(Component c) {
        Container parent = c.getParent();
        return parent instanceof JInternalFrame && !(c instanceof JRootPane) || parent != null && parent.getParent() instanceof JInternalFrame && !(parent instanceof JRootPane);
    }

    public static int getPopupMask() {
        return 4;
    }

    public static int getTertiaryMask() {
        return 8;
    }

    public static boolean getPopupOnPress() {
        return !Platform.isWindows();
    }

    public static PopupMenu[] getPopupMenus(Component c) {
        try {
            Field field = (class$java$awt$Component == null ? (class$java$awt$Component = AWT.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredField("popups");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Vector popups = (Vector)field.get(c);
            field.setAccessible(accessible);
            if (popups != null) {
                return popups.toArray(new PopupMenu[popups.size()]);
            }
            return NO_POPUPS;
        }
        catch (NoSuchFieldException e) {
            throw new Error("No field named 'popups' in class Component");
        }
        catch (IllegalAccessException e) {
            throw new Error("Can't access popup for component " + c);
        }
    }

    public static MenuItem[] findAWTPopupMenuItems(Component parent, String path) {
        PopupMenu[] popups = AWT.getPopupMenus(parent);
        ArrayList list = new ArrayList();
        for (int i = 0; i < popups.length; ++i) {
            list.addAll(AWT.findMenuItems(popups[i], path, true));
        }
        return list.toArray(new MenuItem[list.size()]);
    }

    public static MenuItem[] findAWTMenuItems(Frame frame, String path) {
        MenuBar mb = frame.getMenuBar();
        if (mb != null) {
            Collection items = AWT.findMenuItems(mb, path, true);
            return items.toArray(new MenuItem[items.size()]);
        }
        return new MenuItem[0];
    }

    public static String getPath(MenuItem item) {
        String path = AWT.getPath(item, false);
        if (AWT.isOnPopup(item) && AWT.findAWTPopupMenuItems(AWT.getInvoker(item), path).length > 1) {
            path = AWT.getPath(item, true);
        }
        return path;
    }

    private static String getPath(MenuItem item, boolean includePopupName) {
        MenuContainer top;
        Component invoker = AWT.getInvoker(item);
        if (invoker == null) {
            top = item.getParent();
            while (top instanceof Menu && !(((Menu)top).getParent() instanceof MenuBar)) {
                top = ((Menu)top).getParent();
            }
            if (top == null) {
                throw new RuntimeException("MenuItem is not attached to the hierarchy");
            }
        } else {
            top = item.getParent();
            while (top instanceof Menu && !(((Menu)top).getParent() instanceof Component)) {
                top = ((Menu)top).getParent();
            }
        }
        String path = item.getLabel();
        MenuItem mi = item;
        while (mi.getParent() != top) {
            mi = (MenuItem)((Object)mi.getParent());
            path = mi.getLabel() + "|" + path;
        }
        if (top instanceof PopupMenu) {
            if (includePopupName) {
                String name = ((PopupMenu)top).getName();
                if (Regexp.stringMatch("popup[0-9]+", name)) {
                    PopupMenu[] all = AWT.getPopupMenus(invoker);
                    for (int i = 0; i < all.length; ++i) {
                        if (all[i] != top) continue;
                        name = "popup#" + i;
                        break;
                    }
                }
                path = name + "|" + path;
            }
        } else {
            path = ((Menu)top).getLabel() + "|" + path;
        }
        Log.debug("Path for " + item + " is " + path);
        return path;
    }

    private static Collection findMenuItems(MenuContainer mc, String path, boolean matchPath) {
        ArrayList<MenuItem> list;
        block6: {
            block5: {
                if (matchPath) {
                    Log.debug("Searching for '" + path + "' on '" + mc);
                }
                list = new ArrayList<MenuItem>();
                if (!(mc instanceof MenuBar)) break block5;
                for (int i = 0; i < ((MenuBar)mc).getMenuCount(); ++i) {
                    Menu menu = ((MenuBar)mc).getMenu(i);
                    Log.debug("Scanning '" + menu + "'");
                    list.addAll(AWT.findMenuItems(menu, path, matchPath));
                }
                break block6;
            }
            if (!(mc instanceof Menu)) break block6;
            for (int i = 0; i < ((Menu)mc).getItemCount(); ++i) {
                MenuItem mi = ((Menu)mc).getItem(i);
                if (mi instanceof MenuContainer) {
                    Log.debug("Scanning '" + mi + "'");
                    list.addAll(AWT.findMenuItems((MenuContainer)((Object)mi), path, matchPath));
                    continue;
                }
                if (path.equals(mi.getLabel())) {
                    Log.debug("Found '" + mi + "'");
                    list.add(mi);
                    continue;
                }
                if (!matchPath || !ExtendedComparator.stringsMatch(path, AWT.getPath(mi, false)) && !ExtendedComparator.stringsMatch(path, AWT.getPath(mi, true))) continue;
                Log.debug("Found (path) '" + mi + "'");
                list.add(mi);
            }
        }
        return list;
    }

    public static Component getFocusOwner() {
        try {
            Class<?> cls = Class.forName("java.awt.KeyboardFocusManager");
            Field field = cls.getDeclaredField("focusOwner");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Component c = (Component)field.get(null);
            field.setAccessible(accessible);
            return c;
        }
        catch (Exception e) {
            Window w;
            if (!(e instanceof ClassNotFoundException)) {
                Log.log(e);
            }
            Iterator iter = new AWTHierarchy().getRoots().iterator();
            Component focus = null;
            while (iter.hasNext() && (!(w = (Window)iter.next()).isShowing() || (focus = AWT.getFocusOwner(w)) == null)) {
            }
            return focus;
        }
    }

    private static Component getFocusOwner(Window w) {
        Component focus = w.getFocusOwner();
        if (focus == null) {
            Window[] owned = w.getOwnedWindows();
            for (int i = 0; i < owned.length; ++i) {
                focus = owned[i].getFocusOwner();
                if (focus == null) continue;
                return focus;
            }
        }
        return focus;
    }

    public static AppContext getAppContext(Component c) {
        try {
            Field field = (class$java$awt$Component == null ? (class$java$awt$Component = AWT.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredField("appContext");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            AppContext appContext = (AppContext)field.get(c);
            field.setAccessible(accessible);
            return appContext;
        }
        catch (Exception e) {
            Log.warn(e);
            return null;
        }
    }

    public static boolean eventTypeEnabled(Component c, int id) {
        if (c instanceof Choice) {
            return true;
        }
        try {
            AWTEvent ev = new AWTEvent(c, id){};
            Method m = (class$java$awt$Component == null ? (class$java$awt$Component = AWT.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredMethod("eventEnabled", class$java$awt$AWTEvent == null ? (class$java$awt$AWTEvent = AWT.class$("java.awt.AWTEvent")) : class$java$awt$AWTEvent);
            m.setAccessible(true);
            Boolean b = (Boolean)m.invoke((Object)c, ev);
            return b;
        }
        catch (Exception e) {
            Log.warn(e);
            return true;
        }
    }

    public static boolean isSharedInvisibleFrame(Component c) {
        return c instanceof Frame && (c == JOptionPane.getRootFrame() || c.getClass().getName().startsWith(ROOT_FRAME_CLASSNAME));
    }

    public static boolean isAppletViewerFrame(Component c) {
        return c.getClass().getName().equals("sun.applet.AppletViewer");
    }

    public static JPopupMenu getActivePopupMenu() {
        try {
            return (JPopupMenu)BasicFinder.getDefault().find(POPUP_MATCHER);
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    public static JPopupMenu findActivePopupMenu() {
        JPopupMenu popup = AWT.getActivePopupMenu();
        if (popup == null && !SwingUtilities.isEventDispatchThread()) {
            long now = System.currentTimeMillis();
            while ((popup = AWT.getActivePopupMenu()) == null && System.currentTimeMillis() - now <= (long)POPUP_TIMEOUT) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        return popup;
    }

    public static Point getLocationOnScreen(Component c) {
        if (AWT.isAWTTreeLockHeld()) {
            if (!c.isShowing()) {
                throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
            }
            Point loc = new Point(c.getLocation());
            if (!(c instanceof Window)) {
                Container parent = c.getParent();
                if (parent == null) {
                    throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
                }
                Point ploc = AWT.getLocationOnScreen(parent);
                loc.translate(ploc.x, ploc.y);
            }
            return loc;
        }
        return new Point(c.getLocationOnScreen());
    }

    public static boolean isTransientDialog(Component c) {
        if (c instanceof Window) {
            Container contentPane;
            Component[] kids;
            if (c instanceof JDialog && (kids = (contentPane = ((JDialog)c).getContentPane()).getComponents()).length == 1) {
                return kids[0] instanceof JOptionPane || kids[0] instanceof JFileChooser || kids[0] instanceof JColorChooser;
            }
        } else if (!(c instanceof JOptionPane || c instanceof JFileChooser || c instanceof JColorChooser)) {
            Container parent = c.getParent();
            return parent != null && AWT.isTransientDialog(parent);
        }
        return false;
    }

    public static Applet findAppletDescendent(Container c) {
        try {
            return (Applet)BasicFinder.getDefault().find(c, new ClassMatcher(class$java$applet$Applet == null ? (class$java$applet$Applet = AWT.class$("java.applet.Applet")) : class$java$applet$Applet));
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    public static boolean isTertiaryButton(int mods) {
        return (mods & 0x1C) != 16 && (mods & AWTConstants.POPUP_MASK) == 0;
    }

    public static int getModifiers(String mods) {
        int value = 0;
        if (mods != null && !mods.equals("")) {
            StringTokenizer st = new StringTokenizer(mods, "| ");
            while (st.hasMoreTokens()) {
                String flag = st.nextToken();
                if (!flag.endsWith("_MASK")) {
                    flag = flag + "_MASK";
                }
                if (AWTConstants.POPUP_MODIFIER.equals(flag)) {
                    value |= AWTConstants.POPUP_MASK;
                    continue;
                }
                if (AWTConstants.TERTIARY_MODIFIER.equals(flag)) {
                    value |= AWTConstants.TERTIARY_MASK;
                    continue;
                }
                if (flag.equals("0")) continue;
                value |= Reflector.getFieldValue(class$java$awt$event$InputEvent == null ? AWT.class$("java.awt.event.InputEvent") : class$java$awt$event$InputEvent, flag);
            }
        }
        return value;
    }

    private static String getModifiers(int flags, boolean isMouse) {
        int macModifiers = 14;
        boolean isMacButton = isMouse && Platform.isMacintosh() && (flags & macModifiers) != 0;
        String mods = "";
        String or = "";
        if ((flags & 0x20) != 0) {
            mods = mods + or + "ALT_GRAPH_MASK";
            or = "|";
            flags &= 0xFFFFFFDF;
        }
        if ((flags & 0x10) != 0 && !isMacButton) {
            mods = mods + or + "BUTTON1_MASK";
            or = "|";
            flags &= 0xFFFFFFEF;
        }
        if ((flags & 8) != 0 && !isMacButton && !isMouse) {
            mods = mods + or + "ALT_MASK";
            or = "|";
            flags &= 0xFFFFFFF7;
        }
        if ((flags & 2) != 0 && !isMacButton) {
            mods = mods + or + "CTRL_MASK";
            or = "|";
            flags &= 0xFFFFFFFD;
        }
        if ((flags & 4) != 0 && !isMacButton && !isMouse) {
            mods = mods + or + "META_MASK";
            or = "|";
            flags &= 0xFFFFFFFB;
        }
        if ((flags & AWTConstants.POPUP_MASK) != 0) {
            mods = mods + or + "POPUP_MASK";
            or = "|";
            flags &= ~AWTConstants.POPUP_MASK;
        }
        if ((flags & AWTConstants.TERTIARY_MASK) != 0) {
            mods = mods + or + "TERTIARY_MASK";
            or = "|";
            flags &= ~AWTConstants.TERTIARY_MASK;
        }
        if ((flags & 1) != 0) {
            mods = mods + or + "SHIFT_MASK";
            or = "|";
            flags &= 0xFFFFFFFE;
        }
        if ("".equals(mods)) {
            mods = "0";
        }
        return mods;
    }

    public static String getKeyModifiers(int flags) {
        return AWT.getModifiers(flags, false);
    }

    public static String getMouseModifiers(int flags) {
        return AWT.getModifiers(flags, true);
    }

    public static String getModifiers(InputEvent event) {
        return AWT.getModifiers(event.getModifiers(), event instanceof MouseEvent);
    }

    public static String getKeyCode(int keycode) {
        return Reflector.getFieldName(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = AWT.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent, keycode, "VK_");
    }

    public static int getKeyCode(String code) {
        return Reflector.getFieldValue(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = AWT.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent, code);
    }

    public static boolean isModifier(int keycode) {
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    public static int keyCodeToMask(int code) {
        switch (code) {
            case 157: {
                return 4;
            }
            case 18: {
                return 8;
            }
            case 65406: {
                return 32;
            }
            case 17: {
                return 2;
            }
            case 16: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Keycode is not a modifier: " + code);
    }

    public static int maskToKeyCode(int mask) {
        switch (mask) {
            case 4: {
                return 157;
            }
            case 8: {
                return 18;
            }
            case 32: {
                return 65406;
            }
            case 2: {
                return 17;
            }
            case 1: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Unrecognized mask '" + mask + "'");
    }

    public static Component retargetMouseEvent(Component comp, int id, Point pt) {
        Point where = pt;
        while (!(comp instanceof Window) && !AWT.eventTypeEnabled(comp, id)) {
            Log.debug("Retargeting event, " + Robot.toString(comp) + " not interested");
            where = SwingUtilities.convertPoint(comp, where.x, where.y, comp.getParent());
            comp = comp.getParent();
        }
        pt.setLocation(where);
        return comp;
    }

    public static Insets getInsets(Container c) {
        try {
            Insets insets = c.getInsets();
            if (insets != null) {
                return insets;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new Insets(0, 0, 0, 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String to = System.getProperty("org.robotframework.abbot.finder.popup_timeout");
        if (to != null) {
            try {
                POPUP_TIMEOUT = Integer.parseInt(to);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RELATIVE_OFFSET = new Point(10, 10);
        DEFAULT_CASCADE = new Point(15, 15);
        NO_POPUPS = new PopupMenu[0];
        ROOT_FRAME_CLASSNAME = (class$javax$swing$SwingUtilities == null ? (class$javax$swing$SwingUtilities = AWT.class$("javax.swing.SwingUtilities")) : class$javax$swing$SwingUtilities).getName() + "$";
        POPUP_MATCHER = new ClassMatcher(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = AWT.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu, true);
    }

    private static class ThreadStateChecker
    extends Thread {
        public boolean started;
        private Object lock;

        public ThreadStateChecker(Object lock) {
            super("thread state checker");
            this.setDaemon(true);
            this.lock = lock;
        }

        public synchronized void start() {
            super.start();
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                this.started = true;
                this.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
                this.setName(super.getName());
            }
        }
    }

    public static interface ComponentPredicate {
        public boolean evaluate(Component var1);
    }
}

