/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy;

import java.awt.Component;
import java.awt.Container;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.QueueTool;
import org.robotframework.org.netbeans.jemmy.TestOut;

public class ComponentSearcher
implements Outputable {
    private int ordinalIndex;
    private Container container;
    private TestOut out;
    private QueueTool queueTool;
    private String containerToString;

    public ComponentSearcher(Container c) {
        this.container = c;
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.queueTool = new QueueTool();
    }

    public static ComponentChooser getTrueChooser(String description) {
        class TrueChooser
        implements ComponentChooser {
            private String description;

            public TrueChooser(String desc) {
                this.description = desc;
            }

            public boolean checkComponent(Component comp) {
                return true;
            }

            public String getDescription() {
                return this.description;
            }
        }
        return new TrueChooser(description);
    }

    public void setOutput(TestOut output) {
        this.out = output;
    }

    public TestOut getOutput() {
        return this.out;
    }

    private String containerToString() {
        if (this.containerToString == null) {
            this.containerToString = this.container == null ? "null" : (String)this.queueTool.invokeSmoothly(new QueueTool.QueueAction("container.toString()"){

                public Object launch() {
                    return ComponentSearcher.this.container.toString();
                }
            });
        }
        return this.containerToString;
    }

    public Component findComponent(ComponentChooser chooser, int index) {
        this.ordinalIndex = 0;
        final Component result = this.findComponentInContainer(this.container, chooser, index);
        if (result != null) {
            String resultToString = (String)this.queueTool.invokeSmoothly(new QueueTool.QueueAction("result.toString()"){

                public Object launch() {
                    return result.toString();
                }
            });
            this.out.printTrace("Component " + chooser.getDescription() + "\n    was found in container " + this.containerToString() + "\n    " + resultToString);
            this.out.printGolden("Component \"" + chooser.getDescription() + "\" was found");
        } else {
            this.out.printTrace("Component " + chooser.getDescription() + "\n    was not found in container " + this.containerToString());
            this.out.printGolden("Component \"" + chooser.getDescription() + "\" was not found");
        }
        return result;
    }

    public Component findComponent(ComponentChooser chooser) {
        return this.findComponent(chooser, 0);
    }

    private Component findComponentInContainer(Container cont, ComponentChooser chooser, int index) {
        Component[] components = cont.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component target;
            if (components[i] == null) continue;
            if (chooser.checkComponent(components[i])) {
                if (this.ordinalIndex == index) {
                    return components[i];
                }
                ++this.ordinalIndex;
            }
            if (!(components[i] instanceof Container) || (target = this.findComponentInContainer((Container)components[i], chooser, index)) == null) continue;
            return target;
        }
        return null;
    }
}

