/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.input;

import java.awt.Component;
import java.awt.event.MouseEvent;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.drivers.MouseDriver;
import org.robotframework.org.netbeans.jemmy.drivers.input.EventDriver;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;

public class MouseEventDriver
extends EventDriver
implements MouseDriver {
    public MouseEventDriver(String[] supported) {
        super(supported);
    }

    public MouseEventDriver() {
    }

    public void pressMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
        this.dispatchEvent(oper.getSource(), 501, modifiers, x, y, 1, mouseButton);
    }

    public void releaseMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
        this.dispatchEvent(oper.getSource(), 502, modifiers, x, y, 1, mouseButton);
    }

    public void moveMouse(ComponentOperator oper, int x, int y) {
        this.dispatchEvent(oper.getSource(), 503, 0, x, y, 0, Operator.getDefaultMouseButton());
    }

    public void clickMouse(ComponentOperator oper, int x, int y, int clickCount, int mouseButton, int modifiers, Timeout mouseClick) {
        this.moveMouse(oper, x, y);
        this.dispatchEvent(oper.getSource(), 504, 0, x, y, 0, Operator.getDefaultMouseButton());
        this.dispatchEvent(oper.getSource(), 501, modifiers, x, y, 1, mouseButton);
        for (int i = 1; i < clickCount; ++i) {
            this.dispatchEvent(oper.getSource(), 502, modifiers, x, y, i, mouseButton);
            this.dispatchEvent(oper.getSource(), 500, modifiers, x, y, i, mouseButton);
            this.dispatchEvent(oper.getSource(), 501, modifiers, x, y, i + 1, mouseButton);
        }
        mouseClick.sleep();
        this.dispatchEvent(oper.getSource(), 502, modifiers, x, y, clickCount, mouseButton);
        this.dispatchEvent(oper.getSource(), 500, modifiers, x, y, clickCount, mouseButton);
        this.exitMouse(oper);
    }

    public void dragMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
        this.dispatchEvent(oper.getSource(), 506, modifiers, x, y, 1, mouseButton);
    }

    public void dragNDrop(ComponentOperator oper, int start_x, int start_y, int end_x, int end_y, int mouseButton, int modifiers, Timeout before, Timeout after) {
        this.dispatchEvent(oper.getSource(), 504, 0, start_x, start_y, 0, Operator.getDefaultMouseButton());
        this.dispatchEvent(oper.getSource(), 501, modifiers, start_x, start_y, 1, mouseButton);
        before.sleep();
        this.dragMouse(oper, end_x, end_y, mouseButton, modifiers);
        after.sleep();
        this.dispatchEvent(oper.getSource(), 502, modifiers, end_x, end_y, 1, mouseButton);
        this.exitMouse(oper);
    }

    public void enterMouse(ComponentOperator oper) {
        this.dispatchEvent(oper.getSource(), 504, 0, oper.getCenterX(), oper.getCenterY(), 0, Operator.getDefaultMouseButton());
    }

    public void exitMouse(ComponentOperator oper) {
        this.dispatchEvent(oper.getSource(), 505, 0, oper.getCenterX(), oper.getCenterY(), 0, Operator.getDefaultMouseButton());
    }

    protected void dispatchEvent(Component comp, int id, int modifiers, int x, int y, int clickCount, int mouseButton) {
        this.dispatchEvent(comp, new MouseEvent(comp, id, System.currentTimeMillis(), modifiers | mouseButton, x, y, clickCount, mouseButton == Operator.getPopupMouseButton() && id == 501));
    }
}

