/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.menus;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.TimeoutExpiredException;
import org.robotframework.org.netbeans.jemmy.drivers.DescriptablePathChooser;
import org.robotframework.org.netbeans.jemmy.drivers.MenuDriver;
import org.robotframework.org.netbeans.jemmy.drivers.PathChooser;
import org.robotframework.org.netbeans.jemmy.drivers.input.RobotDriver;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;

public class AppleMenuDriver
extends RobotDriver
implements MenuDriver {
    public AppleMenuDriver() {
        super(new Timeout("apple.system.menu.delay", 100L), new String[]{"org.robotframework.org.netbeans.jemmy.operators.JMenuBarOperator"});
    }

    public Object pushMenu(ComponentOperator oper, PathChooser chooser) {
        MenuElement menuObject;
        Timeout maxTime = oper.getTimeouts().create("ComponentOperator.WaitComponentTimeout");
        JMenuBar bar = (JMenuBar)oper.getSource();
        this.activateMenu(bar);
        maxTime.start();
        while (!chooser.checkPathComponent(0, menuObject = AppleMenuDriver.getSelectedElement(bar))) {
            this.pressKey(39, 0);
            this.releaseKey(39, 0);
            if (!maxTime.expired()) continue;
            throw new TimeoutExpiredException("AppleMenuDriver: can not find an appropriate menu!");
        }
        for (int depth = 1; depth < chooser.getDepth(); ++depth) {
            int i;
            int elementIndex = AppleMenuDriver.getDesiredElementIndex(menuObject, chooser, depth);
            if (elementIndex == -1) {
                throw new JemmyException("Unable to find menu (menuitem): " + ((DescriptablePathChooser)chooser).getDescription());
            }
            int n = i = depth == 1 ? 0 : 1;
            while (i <= elementIndex) {
                this.pressKey(40, 0);
                this.releaseKey(40, 0);
                ++i;
            }
            if (depth == chooser.getDepth() - 1) {
                this.pressKey(10, 0);
                this.releaseKey(10, 0);
                return null;
            }
            this.pressKey(39, 0);
            this.releaseKey(39, 0);
            menuObject = menuObject.getSubElements()[0].getSubElements()[elementIndex];
        }
        return menuObject;
    }

    private void activateMenu(JMenuBar bar) {
        if (AppleMenuDriver.getSelectedElement(bar) == null) {
            this.tryToActivate();
            if (AppleMenuDriver.getSelectedElement(bar) == null) {
                this.tryToActivate();
            }
        }
    }

    private void tryToActivate() {
        this.moveMouse(0, 0);
        this.pressMouse(Operator.getDefaultMouseButton(), 0);
        this.releaseMouse(Operator.getDefaultMouseButton(), 0);
        this.pressKey(39, 0);
        this.releaseKey(39, 0);
        this.pressKey(39, 0);
        this.releaseKey(39, 0);
    }

    private static MenuElement getSelectedElement(MenuElement bar) {
        MenuElement[] subElements = bar.getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            if (subElements[i] instanceof JMenu && ((JMenu)subElements[i]).isSelected()) {
                return subElements[i];
            }
            if (!(subElements[i] instanceof JMenuItem) || !((JMenuItem)subElements[i]).isSelected()) continue;
            return subElements[i];
        }
        return null;
    }

    private static int getDesiredElementIndex(MenuElement bar, PathChooser chooser, int depth) {
        MenuElement[] subElements = bar.getSubElements()[0].getSubElements();
        int realIndex = 0;
        for (int i = 0; i < subElements.length; ++i) {
            if (!(subElements[i] instanceof JMenu) || !((JMenuItem)subElements[i]).isVisible() || !((JMenuItem)subElements[i]).isEnabled()) continue;
            if (chooser.checkPathComponent(depth, subElements[i])) {
                return realIndex;
            }
            ++realIndex;
        }
        return -1;
    }
}

