/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.robotframework.org.netbeans.jemmy.QueueTool;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JScrollBarOperator;

public class JScrollBarAPIDriver
extends AbstractScrollDriver {
    private static final int SMALL_INCREMENT = 1;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private static final int RELATIVE_DRAG_STEP_LENGTH = 20;
    private QueueTool queueTool = new QueueTool();

    public JScrollBarAPIDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.JScrollBarOperator"});
    }

    public void scrollToMinimum(ComponentOperator oper, int orientation) {
        JScrollBarOperator scroll = (JScrollBarOperator)oper;
        this.setValue(oper, scroll.getMinimum());
    }

    public void scrollToMaximum(ComponentOperator oper, int orientation) {
        JScrollBarOperator scroll = (JScrollBarOperator)oper;
        this.setValue(oper, scroll.getMaximum() - scroll.getVisibleAmount());
    }

    protected void step(ComponentOperator oper, ScrollAdjuster adj) {
        JScrollBarOperator scroll = (JScrollBarOperator)oper;
        int newValue = -1;
        if (adj.getScrollDirection() == -1) {
            newValue = scroll.getValue() > scroll.getMinimum() + scroll.getUnitIncrement() ? scroll.getValue() - scroll.getUnitIncrement() : scroll.getMinimum();
        } else if (adj.getScrollDirection() == 1) {
            newValue = scroll.getValue() < scroll.getMaximum() - scroll.getVisibleAmount() - scroll.getUnitIncrement() ? scroll.getValue() + scroll.getUnitIncrement() : scroll.getMaximum();
        }
        this.setValue(oper, newValue);
    }

    private void setValue(ComponentOperator oper, int value) {
        if (value != -1) {
            ((JScrollBarOperator)oper).setValue(value);
        }
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator oper) {
        return oper.getTimeouts().create("JScrollBarOperator.DragAndDropScrollingDelta");
    }

    protected void jump(ComponentOperator oper, ScrollAdjuster adj) {
        JScrollBarOperator scroll = (JScrollBarOperator)oper;
        int newValue = -1;
        if (adj.getScrollDirection() == -1) {
            newValue = scroll.getValue() > scroll.getMinimum() + scroll.getBlockIncrement() ? scroll.getValue() - scroll.getBlockIncrement() : scroll.getMinimum();
        } else if (adj.getScrollDirection() == 1) {
            newValue = scroll.getValue() < scroll.getMaximum() - scroll.getVisibleAmount() - scroll.getBlockIncrement() ? scroll.getValue() + scroll.getBlockIncrement() : scroll.getMaximum();
        }
        this.setValue(oper, newValue);
    }

    protected void startPushAndWait(ComponentOperator oper, int direction, int orientation) {
    }

    protected void stopPushAndWait(ComponentOperator oper, int direction, int orientation) {
    }

    protected Point startDragging(ComponentOperator oper) {
        return null;
    }

    protected void drop(ComponentOperator oper, Point pnt) {
    }

    protected void drag(ComponentOperator oper, Point pnt) {
    }

    protected boolean canDragAndDrop(ComponentOperator oper) {
        return false;
    }

    protected boolean canJump(ComponentOperator oper) {
        return this.isSmallIncrement((JScrollBarOperator)oper);
    }

    protected boolean canPushAndWait(ComponentOperator oper) {
        return false;
    }

    protected int getDragAndDropStepLength(ComponentOperator oper) {
        return 1;
    }

    private boolean isSmallIncrement(JScrollBarOperator oper) {
        return oper.getUnitIncrement(-1) <= 1 && oper.getUnitIncrement(1) <= 1;
    }
}

