/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.operators;

import java.awt.Container;
import java.util.Hashtable;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.TestOut;
import org.robotframework.org.netbeans.jemmy.Timeoutable;
import org.robotframework.org.netbeans.jemmy.Timeouts;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JTextComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;

public class JTextAreaOperator
extends JTextComponentOperator
implements Timeoutable,
Outputable {
    public static final String COLUMN_COUNT_DPROP = "Column count";
    public static final String ROW_COUNT_DPROP = "Row count";
    private Timeouts timeouts;
    private TestOut output;
    private boolean pageNavigation = false;
    static /* synthetic */ Class class$javax$swing$JTextArea;

    public JTextAreaOperator(JTextArea b) {
        super(b);
    }

    public JTextAreaOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JTextArea)cont.waitSubComponent(new JTextAreaFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JTextAreaOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JTextAreaOperator(ContainerOperator cont, String text, int index) {
        this((JTextArea)JTextAreaOperator.waitComponent(cont, (ComponentChooser)new JTextAreaFinder(new JTextComponentOperator.JTextComponentByTextFinder(text, cont.getComparator())), index));
        this.copyEnvironment(cont);
    }

    public JTextAreaOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JTextAreaOperator(ContainerOperator cont, int index) {
        this((JTextArea)JTextAreaOperator.waitComponent(cont, (ComponentChooser)new JTextAreaFinder(), index));
        this.copyEnvironment(cont);
    }

    public JTextAreaOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JTextArea findJTextArea(Container cont, ComponentChooser chooser, int index) {
        return (JTextArea)JTextAreaOperator.findJTextComponent(cont, new JTextAreaFinder(chooser), index);
    }

    public static JTextArea findJTextArea(Container cont, ComponentChooser chooser) {
        return JTextAreaOperator.findJTextArea(cont, chooser, 0);
    }

    public static JTextArea findJTextArea(Container cont, String text, boolean ce, boolean ccs, int index) {
        return JTextAreaOperator.findJTextArea(cont, new JTextAreaFinder(new JTextComponentOperator.JTextComponentByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs))), index);
    }

    public static JTextArea findJTextArea(Container cont, String text, boolean ce, boolean ccs) {
        return JTextAreaOperator.findJTextArea(cont, text, ce, ccs, 0);
    }

    public static JTextArea waitJTextArea(Container cont, ComponentChooser chooser, int index) {
        return (JTextArea)JTextAreaOperator.waitJTextComponent(cont, new JTextAreaFinder(chooser), index);
    }

    public static JTextArea waitJTextArea(Container cont, ComponentChooser chooser) {
        return JTextAreaOperator.waitJTextArea(cont, chooser, 0);
    }

    public static JTextArea waitJTextArea(Container cont, String text, boolean ce, boolean ccs, int index) {
        return JTextAreaOperator.waitJTextArea(cont, new JTextAreaFinder(new JTextComponentOperator.JTextComponentByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs))), index);
    }

    public static JTextArea waitJTextArea(Container cont, String text, boolean ce, boolean ccs) {
        return JTextAreaOperator.waitJTextArea(cont, text, ce, ccs, 0);
    }

    public void setTimeouts(Timeouts times) {
        this.timeouts = times;
        super.setTimeouts(this.timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void usePageNavigationKeys(boolean yesOrNo) {
        this.pageNavigation = yesOrNo;
    }

    public void changeCaretRow(int row) {
        this.changeCaretPosition(row, this.getCaretPosition() - this.getLineStartOffset(this.getLineOfOffset(this.getCaretPosition())));
    }

    public void changeCaretPosition(int row, int column) {
        int startOffset = this.getLineStartOffset(row);
        int endOffset = this.getLineEndOffset(row);
        super.changeCaretPosition(this.getLineStartOffset(row) + (column <= endOffset - startOffset ? column : endOffset - startOffset));
    }

    public void typeText(String text, int row, int column) {
        if (!this.hasFocus()) {
            this.makeComponentVisible();
        }
        this.changeCaretPosition(row, column);
        this.typeText(text);
    }

    public void selectText(int startRow, int startColumn, int endRow, int endColumn) {
        int endPos;
        int startPos;
        block5: {
            block4: {
                startPos = 0;
                try {
                    startPos = this.getLineStartOffset(startRow) + startColumn;
                }
                catch (JemmyException e) {
                    if (e.getInnerException() instanceof BadLocationException) break block4;
                    throw e;
                }
            }
            endPos = this.getText().length();
            try {
                endPos = this.getLineStartOffset(endRow) + endColumn;
            }
            catch (JemmyException e) {
                if (e.getInnerException() instanceof BadLocationException) break block5;
                throw e;
            }
        }
        this.selectText(startPos, endPos);
    }

    public void selectLines(int startLine, int endLine) {
        if (!this.hasFocus()) {
            this.makeComponentVisible();
        }
        this.selectText(startLine, 0, endLine + 1, 0);
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(COLUMN_COUNT_DPROP, Integer.toString(((JTextArea)this.getSource()).getRows()));
        result.put(ROW_COUNT_DPROP, Integer.toString(((JTextArea)this.getSource()).getColumns()));
        return result;
    }

    public void append(final String string) {
        this.runMapping(new Operator.MapVoidAction("append"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).append(string);
            }
        });
    }

    public int getColumns() {
        return this.runMapping(new Operator.MapIntegerAction("getColumns"){

            public int map() {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getColumns();
            }
        });
    }

    public int getLineCount() {
        return this.runMapping(new Operator.MapIntegerAction("getLineCount"){

            public int map() {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getLineCount();
            }
        });
    }

    public int getLineEndOffset(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("getLineEndOffset"){

            public int map() throws BadLocationException {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getLineEndOffset(i);
            }
        });
    }

    public int getLineOfOffset(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("getLineOfOffset"){

            public int map() throws BadLocationException {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getLineOfOffset(i);
            }
        });
    }

    public int getLineStartOffset(final int i) {
        return this.runMapping(new Operator.MapIntegerAction("getLineStartOffset"){

            public int map() throws BadLocationException {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getLineStartOffset(i);
            }
        });
    }

    public boolean getLineWrap() {
        return this.runMapping(new Operator.MapBooleanAction("getLineWrap"){

            public boolean map() {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getLineWrap();
            }
        });
    }

    public int getRows() {
        return this.runMapping(new Operator.MapIntegerAction("getRows"){

            public int map() {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getRows();
            }
        });
    }

    public int getTabSize() {
        return this.runMapping(new Operator.MapIntegerAction("getTabSize"){

            public int map() {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getTabSize();
            }
        });
    }

    public boolean getWrapStyleWord() {
        return this.runMapping(new Operator.MapBooleanAction("getWrapStyleWord"){

            public boolean map() {
                return ((JTextArea)JTextAreaOperator.this.getSource()).getWrapStyleWord();
            }
        });
    }

    public void insert(final String string, final int i) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).insert(string, i);
            }
        });
    }

    public void replaceRange(final String string, final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("replaceRange"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).replaceRange(string, i, i1);
            }
        });
    }

    public void setColumns(final int i) {
        this.runMapping(new Operator.MapVoidAction("setColumns"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).setColumns(i);
            }
        });
    }

    public void setLineWrap(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setLineWrap"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).setLineWrap(b);
            }
        });
    }

    public void setRows(final int i) {
        this.runMapping(new Operator.MapVoidAction("setRows"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).setRows(i);
            }
        });
    }

    public void setTabSize(final int i) {
        this.runMapping(new Operator.MapVoidAction("setTabSize"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).setTabSize(i);
            }
        });
    }

    public void setWrapStyleWord(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setWrapStyleWord"){

            public void map() {
                ((JTextArea)JTextAreaOperator.this.getSource()).setWrapStyleWord(b);
            }
        });
    }

    public static class JTextAreaFinder
    extends Operator.Finder {
        public JTextAreaFinder(ComponentChooser sf) {
            super(class$javax$swing$JTextArea == null ? (class$javax$swing$JTextArea = JTextAreaOperator.class$("javax.swing.JTextArea")) : class$javax$swing$JTextArea, sf);
        }

        public JTextAreaFinder() {
            super(class$javax$swing$JTextArea == null ? (class$javax$swing$JTextArea = JTextAreaOperator.class$("javax.swing.JTextArea")) : class$javax$swing$JTextArea);
        }
    }
}

