/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.button;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.button.ButtonOperator;
import org.robotframework.swing.button.ButtonOperatorFactory;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.keyword.button.ButtonOperatorWrapper;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class ButtonKeywords {
    private final IdentifierParsingOperatorFactory<ButtonOperator> operatorFactory = new ButtonOperatorFactory();
    private final IComponentConditionResolver buttonExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Uses current context to search for a button and when found, pushes it.\n\nExample:\n| Push Button | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void pushButton(String identifier) {
        new ButtonOperatorWrapper(this.createOperator(identifier)).push();
    }

    @RobotKeyword(value="Uses current context to search for a button and when found, returns the text it is labeled with.\n\nExample:\n| ${buttonText}=  | Get Button Text | _myButton_    |\n| Should Be Equal | _My Button_     | _${buttonText}_ |\n")
    @ArgumentNames(value={"identifier"})
    public String getButtonText(String identifier) {
        return this.createOperator(identifier).getText();
    }

    @RobotKeyword(value="Fails if button does not exist within current context.\n\nExample:\n| Button Should Exist | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void buttonShouldExist(String identifier) {
        Assert.assertTrue("Button '" + identifier + "' doesn't exist", this.buttonExists(identifier));
    }

    @RobotKeyword(value="Fails if button exists within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`.\n\nExample:\n| Set Jemmy Timeouts      | _1_  |\n| Button Should Not Exist | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void buttonShouldNotExist(String identifier) {
        Assert.assertFalse("Button '" + identifier + "' exists", this.buttonExists(identifier));
    }

    @RobotKeyword(value="Fails if button is disabled\n\nExample:\n| Button Should Be Enabled | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void buttonShouldBeEnabled(String identifier) {
        Assert.assertTrue("Button was disabled.", this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if button is enabled\n\nExample:\n| Button Should Be Disabled | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void buttonShouldBeDisabled(String identifier) {
        Assert.assertFalse("Button was enabled.", this.createOperator(identifier).isEnabled());
    }

    private ButtonOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    private boolean buttonExists(String identifier) {
        return this.buttonExistenceResolver.satisfiesCondition(identifier);
    }
}

