/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.combobox;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.combobox.ComboBoxOperator;
import org.robotframework.swing.combobox.ComboBoxOperatorFactory;
import org.robotframework.swing.factory.OperatorFactory;

@RobotKeywords
public class ComboBoxKeywords {
    private OperatorFactory<ComboBoxOperator> operatorFactory = new ComboBoxOperatorFactory();

    @RobotKeyword(value="Selects an item from a combobox.\nThe item selection is verified by default and can be disabled using the optional _verifySelection_ parameter with any value.\n\n*N.B* If the _comboItemIdentifier_ is a numerical value it vill be interpreted as index.\n\n*N.B.* If the combobox changes its items on selection, disable the verification and optionally check the selection using the keyword `Get Selected Item From Combo Box`.\n\nExample:\n| Select From Combo Box | _myComboBox_ | _myItem_ | # Selects _'myItem'_ from combobox |\n| Select From Combo Box | _myComboBox_ | _0_      | # Selects the first item from combobox |\n| Select From Combo Box | _myComboBox_ | _myItem_ | _don't verify_ | # Selects _'myItem'_ from combobox and doesn't verify that myItem is selected |\n")
    @ArgumentNames(value={"identifier", "comboItemIdentifier", "*verifySelection"})
    public void selectFromComboBox(String identifier, String comboItemIdentifier, String[] verifySelection) {
        this.createOperator(identifier, verifySelection).selectItem(comboItemIdentifier);
    }

    private ComboBoxOperator createOperator(String identifier, String[] verifySelection) {
        if (this.isVerificationDisabled(verifySelection)) {
            return this.createNonVerifyingOperator(identifier);
        }
        return this.createOperator(identifier);
    }

    private ComboBoxOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    private boolean isVerificationDisabled(String[] verifySelection) {
        return verifySelection != null && verifySelection.length > 0 && verifySelection[0] != null && verifySelection[0].length() > 0;
    }

    @RobotKeyword(value="Alias for `Select From Combobox` keyword.\n")
    @ArgumentNames(value={"menuIdentifier", "menuItemIdentifier", "*verificationDisabled"})
    public void selectFromDropdownMenu(String menuIdentifier, String menuItemIdentifier, String[] verificationDisabled) {
        this.selectFromComboBox(menuIdentifier, menuItemIdentifier, verificationDisabled);
    }

    @RobotKeyword(value="Returns an item from a combobox.\n\nExample:\n| ${selectedItem}= | Get Selected Item From Combobox | _myComboBox_      |\n| Should Be Equal  | _item three_                    | _${selectedItem}_ |\n")
    @ArgumentNames(value={"identifier"})
    public Object getSelectedItemFromComboBox(String identifier) {
        ComboBoxOperator op = this.createOperator(identifier);
        return op.isEnabled() ? op.getSelectedItem() : op.getSelectedItemFromDisabledComboBox();
    }

    @RobotKeyword(value="Alias for `Get Selected Item From Combobox` keyword.\n")
    @ArgumentNames(value={"identifier"})
    public Object getSelectedItemFromDropdownMenu(String identifier) {
        return this.getSelectedItemFromComboBox(identifier);
    }

    @RobotKeyword(value="Fails if combobox is disabled\n\nExample:\n| Combobox Should Be Enabled | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void comboBoxShouldBeEnabled(String identifier) {
        Assert.assertTrue("Combobox '" + identifier + "' was disabled.", this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Fails if combobox is enabled\n\nExample:\n| Combobox Should Be Disabled | _OK_ |\n")
    @ArgumentNames(value={"identifier"})
    public void comboBoxShouldBeDisabled(String identifier) {
        Assert.assertFalse("Combobox '" + identifier + "' was enabled.", this.createOperator(identifier).isEnabled());
    }

    @RobotKeyword(value="Types text into a combobox.\nExample:\n| Type Into Combobox | _myCombobox_ | _someValue_ |\n")
    @ArgumentNames(value={"identifier", "text"})
    public void typeIntoCombobox(String identifier, String text) {
        this.createOperator(identifier).typeText(text);
    }

    @RobotKeyword(value="Returns a list containing all the values of a combobox.\n\n*N.B* This keyword will return the values contained by _javax.swing.ComboBoxModel_,\nthis is not necessarily what is displayed on the GUI.\n\nExample:\n| _${comboboxValues}=_ | Get Combobox Values | _myCombobox_ |\n| Should Contain  | _${expectedValue}_ | _${comboboxValues}_ |\n")
    @ArgumentNames(value={"identifier"})
    public Object[] getComboboxValues(String identifier) {
        return this.createOperator(identifier).getValues();
    }

    private ComboBoxOperator createNonVerifyingOperator(String identifier) {
        ComboBoxOperator operator = this.operatorFactory.createOperator(identifier);
        operator.disableVerification();
        return operator;
    }
}

