/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.dialog;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;
import org.robotframework.org.netbeans.jemmy.TimeoutExpiredException;
import org.robotframework.org.netbeans.jemmy.operators.JDialogOperator;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.dialog.DialogOperator;
import org.robotframework.swing.dialog.DialogOperatorFactory;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class DialogKeywords {
    private final IdentifierParsingOperatorFactory<DialogOperator> operatorFactory = new DialogOperatorFactory();
    private final IComponentConditionResolver dialogExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Selects a dialog as current context and sets focus to it.\n\n*N.B.* Regular expression can be used to select the dialog by prefixing the identifier with 'regexp='.\nPlease learn more about java reqular expressions at http://java.sun.com/docs/books/tutorial/essential/regex/ \n and patterns http://java.sun.com/javase/7/docs/api/java/util/regex/Pattern.html \n\nExample:\n| Select Dialog  | _About_ |\n| Select Dialog  | _regexp=^A.*_ | Selects a dialog starting with 'A' | \n")
    @ArgumentNames(value={"identifier"})
    public void selectDialog(String identifier) {
        DialogOperator operator = this.operatorFactory.createOperator(identifier);
        operator.getFocus();
        Context.setContext(operator);
    }

    @RobotKeyword(value="Closes a dialog.\n\n*N.B.* Regular expression can be used to close the dialog by prefixing the identifier with 'regexp='.\nPlease see more about regexp usage at `Select Dialog` keyword.\n\nExample:\n| Close Dialog | _About_ |\n| Close Dialog  | _regexp=^A.*_ | Closes a dialog starting with 'A' | \n")
    @ArgumentNames(value={"identifier"})
    public void closeDialog(String identifier) {
        this.operatorFactory.createOperator(identifier).close();
    }

    @RobotKeyword(value="Fails if the dialog is not open.\n\nExample:\n| Dialog Should Be Open | _About_ |\n")
    @ArgumentNames(value={"identifier"})
    public void dialogShouldBeOpen(String identifier) {
        Assert.assertTrue("Dialog '" + identifier + "' is not open", this.dialogExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if the dialog is open.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`.\n\nExample:\n| Set Jemmy Timeouts | _2_ |\n| Dialog Should Not Be Open | _About_ |\n")
    @ArgumentNames(value={"identifier"})
    public void dialogShouldNotBeOpen(String identifier) {
        Assert.assertFalse("Dialog '" + identifier + "' is open", this.dialogExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Closes all the dialogs that are open.")
    public void closeAllDialogs() {
        String timeout = "DialogWaiter.WaitDialogTimeout";
        long originalTimeout = JemmyProperties.getCurrentTimeout(timeout);
        JemmyProperties.setCurrentTimeout(timeout, 100L);
        while (this.closePossibleDialog()) {
        }
        JemmyProperties.setCurrentTimeout(timeout, originalTimeout);
    }

    private boolean closePossibleDialog() {
        JDialogOperator operator;
        try {
            operator = new JDialogOperator();
        }
        catch (TimeoutExpiredException e) {
            return false;
        }
        System.out.println("Closed dialog '" + operator.getTitle() + "'.");
        operator.close();
        return true;
    }
}

