/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.internalframe;

import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.internalframe.InternalFrameOperator;
import org.robotframework.swing.internalframe.InternalFrameOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class InternalFrameKeywords {
    private final IdentifierParsingOperatorFactory<InternalFrameOperator> operatorFactory = new InternalFrameOperatorFactory();
    private final IComponentConditionResolver existenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Closes internal frame.\n\nExample:\nExample:\n| Close Internal Frame  | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void closeInternalFrame(String identifier) {
        ((JInternalFrame)this.createOperator(identifier).getSource()).doDefaultCloseAction();
    }

    @RobotKeyword(value="Iconifies internal frame.\n\nExample:\n| Close Internal Frame  | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void iconifyInternalFrame(String identifier) {
        this.iconify(identifier, true);
    }

    @RobotKeyword(value="De-iconifies internal frame.\n\nExample:\n| Close Internal Frame  | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void deIconifyInternalFrame(String identifier) {
        this.iconify(identifier, false);
    }

    private void iconify(String identifier, boolean shouldIconify) {
        try {
            ((JInternalFrame)this.createOperator(identifier).getSource()).setIcon(shouldIconify);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
    }

    @RobotKeyword(value="Maximizes internal frame.\n\nExample:\n| Close Internal Frame  | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void maximizeInternalFrame(String identifier) {
        this.maximize(identifier, true);
    }

    @RobotKeyword(value="Minimizes internal.\n\nExample:\n| Minimize Internal Frame  | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void minimizeInternalFrame(String identifier) {
        this.maximize(identifier, false);
    }

    private void maximize(String identifier, boolean shouldMaximize) {
        try {
            ((JInternalFrame)this.createOperator(identifier).getSource()).setMaximum(shouldMaximize);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
    }

    @RobotKeyword(value="Fails if the internal frame doesn't exist in the current context.\n\nExample:\n| Internal Frame Should Exist | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void internalFrameShouldExist(String identifier) {
        Assert.assertTrue("Internal frame '" + identifier + "' doesn't exist.", this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if the internal frame exists in the current context.\n\nExample:\n| Internal Frame Should Not Exist | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void internalFrameShouldNotExist(String identifier) {
        Assert.assertFalse("Internal frame '" + identifier + "' exists.", this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if the internal frame is *not* open.\n\nExample:\n| Internal Frame Should Be Open | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void internalFrameShouldBeOpen(String identifier) {
        Assert.assertTrue("Internal frame '" + identifier + "' is not open.", this.createOperator(identifier).isVisible());
    }

    @RobotKeyword(value="Fails if the internal frame *is* open.\n\nExample:\n| Internal Frame Should Not Be Open | _My Internal Frame_ |\n")
    @ArgumentNames(value={"identifier"})
    public void internalFrameShouldNotBeOpen(String identifier) {
        Assert.assertFalse("Internal frame '" + identifier + "' is open.", this.createOperator(identifier).isVisible());
    }

    private InternalFrameOperator createOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }
}

