/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.menu;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.keyword.menu.MenuKeywords;
import org.robotframework.swing.keyword.window.WindowKeywords;
import org.robotframework.swing.menu.MenuSupport;

@RobotKeywords
public class MainMenuKeywords
extends MenuSupport {
    private WindowKeywords windowKeywords = new WindowKeywords();
    private MenuKeywords menuKeywords = new MenuKeywords();

    @RobotKeyword(value="Selects an item from the menu of the window that was opened first.\nShortcut for:\n| Select Window    | _0_ |\n| Select From Menu | _Tools|Testing|MyTestTool_ |\n\nExample:\n| Select From Main Menu | _Tools|Testing|MyTestTool_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void selectFromMainMenu(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuKeywords.selectFromMenu(menuPath);
    }

    @RobotKeyword(value="Selects an item from the menu of the window that was opened first and waits for action to finish.\nShortcut for:\n| Select Window             | _0_                        |\n| Select From Menu And Wait | _Tools|Testing|MyTestTool_ |\n\nThis keyword will not work, for example, if the menu item opens a dialog.\n\nExample:\n| Select From Main Menu And Wait | _Tools|Testing|MyTestTool_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void selectFromMainMenuAndWait(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuKeywords.selectFromMenuAndWait(menuPath);
    }

    @RobotKeyword(value="Selects an item from the menu of the window that was opened first and returns it's name.\n\nExample:\n| ${mainMenuItemName}= | Get Main Menu Item Name | _0_                   |\n| Should Be Equal      | _File_                  | _${mainMenuItemName}_ |\n")
    @ArgumentNames(value={"index"})
    public String getMainMenuItemName(String index) {
        if (!this.isIndex(index)) {
            throw new UnsupportedOperationException("The argument must be an index.");
        }
        return this.menubarOperator().getMenu(this.asIndex(index)).getText();
    }

    @RobotKeyword(value="Fails if menu item doesn't exist in the window that was opened first.\nShortcut for:\n| Select Window    | _0_ |\n| Menu Item Should Exist | _Tools|Testing|MyTestTool_ |\n\nExample:\n| Main Menu Item Should Exist | _Tools|Testing|Test Tool_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void mainMenuItemShouldExist(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuKeywords.menuItemShouldExist(menuPath);
    }

    @RobotKeyword(value="Fails if menu item exists in the window that was opened first.\nShortcut for:\n| Select Window    | _0_ |\n| Menu Item Should Not Exist | _Tools|Testing|MyTestTool_ |\n\nExample:\n| Main Menu Item Should Not Exist | _Tools|Testing|Test Tool_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void mainMenuItemShouldNotExist(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuKeywords.menuItemShouldNotExist(menuPath);
    }
}

