/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.spinner;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.spinner.SpinnerOperator;
import org.robotframework.swing.spinner.SpinnerOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class SpinnerKeywords {
    private IdentifierParsingOperatorFactory<SpinnerOperator> operatorFactory = new SpinnerOperatorFactory();
    private IComponentConditionResolver existenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Fails if spinner does not exist within current context.\n\nExample:\n| Spinner Should Exist | _dateSpinner_ |\n")
    @ArgumentNames(value={"identifier"})
    public void spinnerShouldExist(String identifier) {
        Assert.assertTrue("Spinner '" + identifier + "' doesn't exist.", this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if spinner exists within current context.\n\nExample:\n| Spinner Should Not Exist | _dateSpinner_ |\n")
    @ArgumentNames(value={"identifier"})
    public void spinnerShouldNotExist(String identifier) {
        Assert.assertFalse("Spinner '" + identifier + "' exists.", this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Scrolls spinner button up.\nThe number of notches to scroll can be given as a second argument.\n\nExample:\n| Increase Spinner Value | _mySpinner_ |   | # scrolls spinner button up a notch |\n| Increase Spinner Value | _mySpinner_ | 4 | # scrolls spinner button up four notches |\n")
    @ArgumentNames(value={"identifier", "times=1"})
    public void increaseSpinnerValue(String identifier, String[] times) {
        this.increase(this.operatorFactory.createOperator(identifier), this.getNotches(times));
    }

    private int getNotches(String[] times) {
        return times.length == 0 ? 1 : Integer.parseInt(times[0]);
    }

    private void increase(SpinnerOperator spinnerOperator, int numberOfIncreases) {
        for (int i = 0; i < numberOfIncreases; ++i) {
            spinnerOperator.increase();
        }
    }

    @RobotKeyword(value="Scrolls spinner button down.\nThe number of notches to scroll can be given as a second argument.\n\nExample:\n| Decrease Spinner Value | _mySpinner_ |   | # scrolls spinner button down a notch |\n| Decrease Spinner Value | _mySpinner_ | 4 | # scrolls spinner button down four notches |\n")
    @ArgumentNames(value={"identifier", "times=1"})
    public void decreaseSpinnerValue(String identifier, String[] times) {
        this.decrease(this.operatorFactory.createOperator(identifier), this.getNotches(times));
    }

    private void decrease(SpinnerOperator spinnerOperator, int numberOfDecreases) {
        for (int i = 0; i < numberOfDecreases; ++i) {
            spinnerOperator.decrease();
        }
    }

    @RobotKeyword(value="Uses current context to search for a spinner button and when found, returns its current value.\n\nExample:\n| ${spinnerValue}=  | Get Spinner Value | _mySpinner_    |\n| Should Be Equal As Integers | _12_     | _${spinnerValue}_ |\n")
    @ArgumentNames(value={"identifier"})
    public Object getSpinnerValue(String identifier) {
        return this.operatorFactory.createOperator(identifier).getValue();
    }

    @RobotKeyword(value="Sets the string value for the spinner found from the current context.\n\nExample:\n| Set Spinner String Value | _mySpinner_  | _January_  |\n")
    @ArgumentNames(value={"identifier", "value"})
    public void setSpinnerStringValue(String identifier, String value) {
        this.operatorFactory.createOperator(identifier).setValue(value);
    }

    @RobotKeyword(value="Sets the number value for the spinner found from the current context.\n\nExample:\n| Set Spinner Number Value | _mySpinner_  | _100_  |\n| Set Spinner Number Value | _mySpinner_  | _7.5_  |\n")
    @ArgumentNames(value={"identifier", "value"})
    public void setSpinnerNumberValue(String identifier, String value) {
        this.operatorFactory.createOperator(identifier).setValue(this.asNumber(value));
    }

    private Object asNumber(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ignored) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Can't convert '" + value + "' to a number.");
            }
        }
    }
}

