/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.table;

import java.util.Map;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.org.netbeans.jemmy.operators.JMenuItemOperator;
import org.robotframework.org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.factory.OperatorFactory;
import org.robotframework.swing.keyword.table.OptionalArgsForTableCellClicking;
import org.robotframework.swing.table.TableOperator;
import org.robotframework.swing.table.TableOperatorFactory;

@RobotKeywords
public class TableKeywords
extends IdentifierSupport {
    private final OperatorFactory<TableOperator> operatorFactory = new TableOperatorFactory();

    @RobotKeyword(value="Selects a cell in a table.\n\nExample:\n| Select Table Cell | _myTable_ | _0_ | _2_       | # Selects cell from first row and third column |\n| Select Table Cell | _myTable_ | _1_ | _Keyword_ | # Selects cell from second row and column with header 'Keyword' |\n")
    @ArgumentNames(value={"identifier", "row", "cellIdentifier"})
    public void selectTableCell(String identifier, String row, String cellIdentifier) {
        this.createTableOperator(identifier).selectCell(row, cellIdentifier);
    }

    @RobotKeyword(value="Selects a cell in a table and adds it to the selection.\nDoes not clear earlier selections.\n\nExample:\n| Select Table Cell | _myTable_ | _0_ | _2_       | # Selects cell from first row and third column |\n| Select Table Cell | _myTable_ | _1_ | _Keyword_ | # Selects cell from second row and column with header 'Keyword' |\n")
    @ArgumentNames(value={"identifier", "row", "cellIdentifier"})
    public void addTableCellSelection(String identifier, String row, String cellIdentifier) {
        this.createTableOperator(identifier).addTableCellSelection(row, cellIdentifier);
    }

    @RobotKeyword(value="Selects a cell area in a table.\nDoes not clear earlier selections.\n\nExample:\n| Select Table Cell Area | _myTable_ | _0_ | _2_ | _0_ | _2_ | # Selects cells from first to third row and first to third column |\n")
    @ArgumentNames(value={"identifier", "startRow", "endRow", "startColumn", "endColumn"})
    public void selectTableCellArea(String identifier, String startRow, String endRow, String startColumn, String endColumn) {
        this.createTableOperator(identifier).selectCellArea(startRow, endRow, startColumn, endColumn);
    }

    @RobotKeyword(value="Clears selection from a table.\n\nExample:\n| Clear Table Selection | _myTable_ |\n")
    @ArgumentNames(value={"identifier"})
    public void clearTableSelection(String identifier) {
        this.createTableOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Fails if given table cell is not editable in a table.\n\nExample:\n| Table Cell Should Be Editable | _myTable_ | _0_ | _2_       |\n| Table Cell Should Be Editable | _myTable_ | _1_ | _Keyword_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier"})
    public void tableCellShouldBeEditable(String identifier, String row, String columnIdentifier) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        Assert.assertTrue("Cell '" + row + "', '" + columnIdentifier + "' is not editable.", tableOperator.isCellEditable(row, columnIdentifier));
    }

    @RobotKeyword(value="Fails if given table cell is editable in a table.\n\nExample:\n| Table Cell Should Not Be Editable | _myTable_ | _0_ | _2_       |\n| Table Cell Should Not Be Editable | _myTable_ | _1_ | _Keyword_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier"})
    public void tableCellShouldNotBeEditable(String identifier, String row, String columnIdentifier) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        Assert.assertFalse("Cell '" + row + "', '" + columnIdentifier + "' is editable.", tableOperator.isCellEditable(row, columnIdentifier));
    }

    @RobotKeyword(value="Fails if given table cell is not selected in a table.\n\nExample:\n| Table Cell Should Be Selected | _myTable_ | _0_ | _2_       |\n| Table Cell Should Be Selected | _myTable_ | _1_ | _Keyword_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier"})
    public void tableCellShouldBeSelected(String identifier, String row, String columnIdentifier) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        Assert.assertTrue("Cell '" + row + "', '" + columnIdentifier + "' is not selected.", tableOperator.isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Fails if given table cell is selected in a table.\n\nExample:\n| Table Cell Should Be Selected | _myTable_ | _0_ | _2_       |\n| Table Cell Should Be Selected | _myTable_ | _1_ | _Keyword_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier"})
    public void tableCellShouldNotBeSelected(String identifier, String row, String columnIdentifier) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        Assert.assertFalse("Cell '" + row + "', '" + columnIdentifier + "' is selected.", tableOperator.isCellSelected(row, columnIdentifier));
    }

    @RobotKeyword(value="Returns cell's value from a table.\n\nStarting from SwingLibrary 1.1.4, value from cell rendered with check box is string true/false.\n\nExample:\n| ${cellValue}=   | Get Table Cell Value | _myTable_ | _0_            | _2_ |\n| Should Be Equal | _tuesday_            |           | _${cellValue}_ |     |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier"})
    public String getTableCellValue(String identifier, String row, String columnIdentifier) {
        return this.createTableOperator(identifier).getCellValue(row, columnIdentifier).toString();
    }

    @RobotKeyword(value="Returns selected cell's value from a table.\n\nExample:\n| ${cellValue}=   | Get Selected Table Cell Value   | _myTable_      |\n| Should Be Equal | _tuesday_                       | _${cellValue}_ |\n")
    @ArgumentNames(value={"identifier"})
    public Object getSelectedTableCellValue(String identifier) {
        return this.createTableOperator(identifier).getSelectedCellValue().toString();
    }

    @RobotKeyword(value="Sets cell value in a table.\n\nExample:\n| Set Table Cell Value | _1_ | _2_ | _New value_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier", "newValue"})
    public void setTableCellValue(String identifier, String row, String columnIdentifier, String newValue) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        if (!tableOperator.isCellEditable(row, columnIdentifier)) {
            throw new RuntimeException("Cell '" + row + "', '" + columnIdentifier + "' is not editable.");
        }
        tableOperator.setCellValue(newValue, row, columnIdentifier);
    }

    @RobotKeyword(value="Types a string into a table cell.\nUses real keyboard events, this is useful when processing need to be triggered by input events.\n\nExample:\n| Type Into Table Cell | _1_ | _2_ | _New value_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier", "newValue"})
    public void typeIntoTableCell(String identifier, String row, String columnIdentifier, String newValue) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        tableOperator.typeIntoCell(newValue, row, columnIdentifier);
    }

    @RobotKeyword(value="Returns the number of columns from a table.\n\nExample:\n| ${columnCount}= | Get Table Column Count | _myTable_ |\n| Should Be Equal As Integers | _4_ | _${columnCount}_ |\n")
    @ArgumentNames(value={"identifier"})
    public int getTableColumnCount(String identifier) {
        return this.createTableOperator(identifier).getColumnCount();
    }

    @RobotKeyword(value="Returns the number of rows from a table.\n\nExample:\n| ${rowCount}= | Get Table Row Count | _myTable_ |\n| Should Be Equal As Integers | _4_ | _${rowCount}_ |\n")
    @ArgumentNames(value={"identifier"})
    public int getTableRowCount(String identifier) {
        return this.createTableOperator(identifier).getRowCount();
    }

    @RobotKeyword(value="Clears table cell contents.\n\nExample:\n| Clear Table Cell Value | _myTable_ | _1_ | _2_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier"})
    public void clearTableCell(String identifier, String row, String columnIdentifier) {
        this.createTableOperator(identifier).clearCell(row, columnIdentifier);
    }

    @RobotKeyword(value="Finds the first row index that has a cell  that contains the given _text_.\nThis is useful when we want to operate on cells which location can change.\n\nExample:\n| ${row}= | Find Table Row | _myTable_ | _Some Value_ |\n| Select From Table Cell Popup Menu | _myTable_ | _${row}_ | _2_ | _Activate_ |\n| ${row}= | Find Table Row | _myTable_ | _Some Value_ | _Some Column_ | # Searches the _'Some Value'_ from the specified  _'Some Column'_  | \n")
    @ArgumentNames(value={"identifier", "text", "columnIdentifier="})
    public int findTableRow(String identifier, String text, String[] columnIdentifier) {
        if (this.isProvided(columnIdentifier)) {
            return this.createTableOperator(identifier).findCellRow(text, columnIdentifier[0]);
        }
        return this.createTableOperator(identifier).findCellRow(text);
    }

    private boolean isProvided(String[] column) {
        return column != null && column.length > 0 && column[0] != null && column[0].length() > 0;
    }

    @RobotKeyword(value="Selects an item from a table cell popup.\nSeparator for items is '|'.\n\nExample:\n| Select From Table Cell Popup Menu | _myTable_ | _1_ | _3_ | _Cell Actions|Clear Cell Value_ | ")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier", "menuPath"})
    public void selectFromTableCellPopupMenu(String identifier, String row, String columnIdentifier, String menuPath) {
        JMenuItemOperator menuItem = this.getPopupMenuItem(identifier, row, columnIdentifier, menuPath);
        menuItem.push();
    }

    @RobotKeyword(value="Selects an item from a table cell popup on the table cells that are selected.\nSeparator for items is '|'.\n\nExample:\n| Select From Table Cell Popup Menu On Selected Cells | _myTable_ | _Cell Actions|Clear Cell Value_ | ")
    @ArgumentNames(value={"identifier", "menuPath"})
    public void selectFromTableCellPopupMenuOnSelectedCells(String identifier, String menuPath) {
        this.createTableOperator(identifier).callPopupMenuItemOnSelectedCells(menuPath);
    }

    @RobotKeyword(value="Fails if the given table cell popup menu is disabled.\nSeparator for items is '|'.\n\nExample:\n| Table Cell Popup Menu Should Be Enabled | _myTable_ | _1_ | _3_ | _Cell Actions|Clear Cell Value_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier", "menuPath"})
    public void tableCellPopupMenuShouldBeEnabled(String identifier, String row, String columnIdentifier, String menuPath) {
        JMenuItemOperator menuItem = this.getPopupMenuItem(identifier, row, columnIdentifier, menuPath);
        String errorMessage = "Menuitem '" + menuPath + "' at '" + row + ", " + columnIdentifier + "' is disabled.";
        Assert.assertTrue(errorMessage, menuItem.isEnabled());
    }

    @RobotKeyword(value="Fails if the given table cell popup menu is enabled.\nSeparator for items is '|'.\n\nExample:\n| Table Cell Popup Menu Should Be Disabled | _myTable_ | _1_ | _3_ | _Cell Actions|Clear Cell Value_ |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier", "menuPath"})
    public void tableCellPopupMenuShouldBeDisabled(String identifier, String row, String columnIdentifier, String menuPath) {
        JMenuItemOperator menuItem = this.getPopupMenuItem(identifier, row, columnIdentifier, menuPath);
        String errorMessage = "Menuitem '" + menuPath + "' at '" + row + ", " + columnIdentifier + "' is enabled.";
        Assert.assertFalse(errorMessage, menuItem.isEnabled());
    }

    @RobotKeyword(value="Returns table's header names.\n\nExample:\n| @{headers}= | Get Table Headers | _myTable_ |\n")
    @ArgumentNames(value={"identifier"})
    public String[] getTableHeaders(String identifier) {
        return this.createTableOperator(identifier).getTableHeaders();
    }

    @RobotKeyword(value="Returns a list containing all the values of a table column.\n\nExample:\n| _${columnValues}=_ | Get Table Column Values | _myTable_ | _columnTwo_ |\n| Should Contain  | _${expectedValue}_ | _${columnValues}_ |\n")
    @ArgumentNames(value={"identifier", "columnIdentifier"})
    public Object[] getTableColumnValues(String identifier, String columnIdentifier) {
        return this.createTableOperator(identifier).getColumnValues(columnIdentifier);
    }

    @RobotKeyword(value="Returns the property of the table cell.\n\nExample:\n| _${background}=_ | Get Table Cell Properties | _myTable_ | _1_ | _2_ | _background_ |\n| Should Be Equal As Integers | _255_ | _${background.getRed()}_ | | | |\n")
    @ArgumentNames(value={"identifier", "row", "columnIdentifier", "propertyName"})
    public Object getTableCellProperty(String identifier, String row, String columnIdentifier, String propertyName) {
        Map<String, Object> properties = this.createTableOperator(identifier).getCellProperties(row, columnIdentifier);
        return properties.get(propertyName);
    }

    private TableOperator createTableOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    private JMenuItemOperator getPopupMenuItem(String identifier, String row, String columnIdentifier, String menuPath) {
        TableOperator tableOperator = this.createTableOperator(identifier);
        JPopupMenuOperator popupMenuOperator = tableOperator.callPopupOnCell(row, columnIdentifier);
        return popupMenuOperator.showMenuItem(menuPath, (Operator.StringComparator)new EqualsStringComparator());
    }

    @RobotKeyword(value="Clicks on a cell in a table, optionally using click count, a specific mouse button and keyboard modifiers.\n\nThe codes used for mouse button and key modifiers are the field names from java.awt.event.InputEvent.For example BUTTON1_MASK, CTRL_MASK, ALT_MASK, ALT_GRAPH_MASK, SHIFT_MASK, and META_MASK.\n\nNote! Some keys have more convinient case insensitive aliases that can be used: LEFT BUTTON, RIGHT BUTTON, SHIFT, CTRL, ALT, META\n\nExamples:\n| Click On Table Cell | _myTable_ | _0_ | _2_ | # Double clicks with mouse button 2 on the cell in the first row and third column... |\n| ... | _2_ | _RIGHT BUTTON_ | _ALT_ | # ... while holding down the ALT key |\n| Click On Table Cell | _myTable_ | _1_ | _Header_ | # Single click on the cell in the second row and column with header 'Header'... |\n| ... | _1_ | _BUTTON1_MASK_ | _CTRL_MASK_ | _SHIFT_MASK_ | # ... while holding down the CTRL and SHIFT keys |\n")
    @ArgumentNames(value={"identifier", "row", "column", "clickCountString=1", "buttonString=BUTTON1_MASK", "*keyModifierStrings"})
    public void clickOnTableCell(String identifier, String row, String column, String[] optionalArgs) {
        OptionalArgsForTableCellClicking optArgs = new OptionalArgsForTableCellClicking(optionalArgs);
        this.createTableOperator(identifier).clickOnCell(row, column, optArgs.clickCount(), optArgs.button(), optArgs.keyModifiers());
    }

    @RobotKeyword(value="Clicks on table header of the given column.\n\nColumn can be identified either by index or by column title. Indexes start at 0\nExamples:\n| Click Table Header | myTable | 2 | # Click the third column |\n| Click Table Header | myTable | amount | # Click the column that has title 'amount' |")
    @ArgumentNames(value={"identifier", "columnIdentifier"})
    public void clickTableHeader(String tableIdentifier, String columnIdentifier) {
        this.createTableOperator(tableIdentifier).headerOperator().clickColumn(columnIdentifier);
    }
}

