/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.tree.TreeOperator;
import org.robotframework.swing.tree.TreePathAction;
import org.robotframework.swing.tree.TreeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class TreeNodeKeywords
extends TreeSupport {
    @RobotKeyword(value="Clears selections from a tree.\n\nExample:\n| Clear Tree Selection | _myTree_ |\n")
    @ArgumentNames(value={"identifier"})
    public void clearTreeSelection(String identifier) {
        this.treeOperator(identifier).clearSelection();
    }

    @RobotKeyword(value="Collapses a node in a tree.\n\nSee `Expand Tree Node` for information about `nodeIdentifier`Examples:\n| Collapse Tree Node | _myTree_ | _Root|Folder_ |\n| Collapse Tree Node | _myTree_ | _3_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void collapseTreeNode(String identifier, String nodeIdentifier) {
        this.treeOperator(identifier).collapse(nodeIdentifier);
    }

    @RobotKeyword(value="Expands a node in a tree.\n\n`nodeIdentifier` can be either tree path (i.e visible labels of nodes to be expanded), or index of the expanded node element. Nested structures can onle be expanded using the tree path syntax. Examples:\n| Expand Tree Node | _myTree_ | _Root|Folder_ |\n| Expand Tree Node | _myTree_ | _3_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void expandTreeNode(String identifier, String nodeIdentifier) {
        this.treeOperator(identifier).expand(nodeIdentifier);
    }

    @RobotKeyword(value="Collapses all nodes in a tree.\n\nExample:\n| Collapse All Tree Nodes | _myTree_ |\n")
    @ArgumentNames(value={"identifier"})
    public void collapseAllTreeNodes(String identifier) {
        final TreeOperator treeOperator = this.treeOperator(identifier);
        treeOperator.operateOnAllNodes(new TreePathAction(){

            public void operate(TreePath path) {
                treeOperator.collapse(path);
            }
        });
    }

    @RobotKeyword(value="Expands all nodes in a tree.\n\nExample:\n| Expand All Tree Nodes | _myTree_ |\n")
    @ArgumentNames(value={"identifier"})
    public void expandAllTreeNodes(String identifier) {
        final TreeOperator treeOperator = this.treeOperator(identifier);
        treeOperator.operateOnAllNodes(new TreePathAction(){

            public void operate(TreePath path) {
                treeOperator.expand(path);
            }
        });
    }

    @RobotKeyword(value="Sets a node as selected in a tree.\nDoes not clear earlier selections.\nIf several nodes have the same path then *only the first* of those nodes is selected.\n\nExample:\n| Select Tree Node | _myTree_ | _Root|Folder_ |\nAny number of node identifiers can be provided to select multiple nodes at once:\n| Select Tree Node | _myTree_ | _Root|Folder_ | _Root|Folder2_ | _Root|Folder3_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "*additionalNodeIdentifiers"})
    public void selectTreeNode(String identifier, String nodeIdentifier, String[] additionalNodeIdentifiers) {
        TreeOperator treeOperator = this.treeOperator(identifier);
        treeOperator.addSelection(nodeIdentifier);
        for (String node : additionalNodeIdentifiers) {
            treeOperator.addSelection(node);
        }
    }

    @RobotKeyword(value="Clicks on a tree node.\n\nExamples:\n| Click On Tree Node | _myTree_ | _Root|Folder_ |\n| Click On Tree Node | _myTree_ | _0_      | \n\nAn optional _click count_ parameter can be provided for example if a double click is required.\nDefault click count is one:\n| Click On Tree Node | _myTree_ | _Root|Folder_ | _2_ | # doubleclicks on node |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "*clickCount"})
    public void clickOnTreeNode(String identifier, String nodeIdentifier, String[] clickCount) {
        this.treeOperator(identifier).clickOnNode(nodeIdentifier, this.extractIntArgument(clickCount));
    }

    @RobotKeyword(value="Fails if the tree node is collapsed.\n\nExample:\n| Tree Node Should Be Expanded | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldBeExpanded(String identifier, String nodeIdentifier) {
        boolean isExpanded = this.treeOperator(identifier).isExpanded(nodeIdentifier);
        Assert.assertTrue("Tree node '" + nodeIdentifier + "' is not expanded.", isExpanded);
    }

    @RobotKeyword(value="Fails if the tree node is expanded.\n\nExample:\n| Tree Node Should Be Collapsed | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldBeCollapsed(String identifier, String nodeIdentifier) {
        boolean isCollapsed = this.treeOperator(identifier).isCollapsed(nodeIdentifier);
        Assert.assertTrue("Tree node '" + nodeIdentifier + "' is not collapsed.", isCollapsed);
    }

    @RobotKeyword(value="Sets a tree node as unselected.\n\nExample:\n| Unselect Tree Node | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void unselectTreeNode(String identifier, String nodeIdentifier) {
        this.treeOperator(identifier).removeSelection(nodeIdentifier);
    }

    @RobotKeyword(value="Fails if the node has child nodes.\nAssumes current context is a tree.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Be Leaf | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldBeLeaf(String identifier, String nodeIdentifier) {
        boolean isLeaf = this.treeOperator(identifier).isLeaf(nodeIdentifier);
        Assert.assertTrue("Tree node '" + nodeIdentifier + "' is not leaf.", isLeaf);
    }

    @RobotKeyword(value="Fails if the node doesn't have child nodes.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Tree Node Should Not Be Leaf | _myTree_ | _Root|Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public void treeNodeShouldNotBeLeaf(String identifier, String nodeIdentifier) {
        boolean isLeaf = this.treeOperator(identifier).isLeaf(nodeIdentifier);
        Assert.assertFalse("Tree node '" + nodeIdentifier + "' is leaf.", isLeaf);
    }

    @RobotKeyword(value="Returns the count of all visible nodes.\n\nExample:\n| ${nodeCount}= | Get Tree Node Count | _myTree_ |\n| Should Be Equal As Integers | _3_ | _${nodeCount}_ |\n")
    @ArgumentNames(value={"identifier"})
    public int getTreeNodeCount(String identifier) {
        return this.treeOperator(identifier).getRowCount();
    }

    @RobotKeyword(value="Returns the node name.\nNodeIndex must be a number and it is counted from visible nodes (index starts from 0).\n\nExample:\n| ${nodeLabel}= | Get Tree Node Label | _myTree_ | _3_ |\n| Should Be Equal | _Element1_ | _${nodeLabel}_ |\n")
    @ArgumentNames(value={"identifier", "nodeIndex"})
    public String getTreeNodeLabel(String identifier, String nodeIndex) {
        TreeOperator treeOperator = this.treeOperator(identifier);
        return treeOperator.getTreeNodeLabel(this.asIndex(nodeIndex));
    }

    @RobotKeyword(value="Returns the node index.\nNodePath must be a string of form _path|to|node_.\n\nExample:\n| ${nodeIndex}= | Get Tree Node Index | _myTree_ | _Root|Folder|ElementX_ |\n| Should Be Equal As Integers | _4_ | _${nodeIndex}_ |\n")
    @ArgumentNames(value={"identifier", "nodePath"})
    public int getTreeNodeIndex(String identifier, String nodePath) {
        return this.treeOperator(identifier).getTreeNodeIndex(nodePath);
    }

    @RobotKeyword(value="Returns a list with all the child node names of the specified node.\n\nExample:\n| ${expectedElements}= | Create List | _someElement_ | _otherElement_ |\n| ${actualElements}=   | Get Tree Node Child Names | _myTree_ | _Element Folder_ |\n| Lists Should Be Equal | _${expectedElements}_ | _${actualElements}_ | # This keyword comes from Collections library |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier"})
    public List<String> getTreeNodeChildNames(String identifier, String nodeIdentifier) {
        Collection<String> childNames = this.treeOperator(identifier).getTreeNodeChildNames(nodeIdentifier);
        return new ArrayList<String>(childNames);
    }
}

