/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.window;

import java.awt.Component;
import java.awt.Window;
import org.robotframework.abbot.tester.WindowTester;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.AbstractContextVerifier;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.window.FrameOperator;
import org.robotframework.swing.window.FrameOperatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class WindowKeywords
extends AbstractContextVerifier {
    private final IdentifierParsingOperatorFactory<FrameOperator> operatorFactory = new FrameOperatorFactory();

    public WindowKeywords() {
        super("To use this keyword you must first select a window as context using the 'Select Window'-keyword.");
    }

    @RobotKeyword(value="Selects the window that was opened first as current context.\n\nExample:\n| Select Main Window |\n")
    public void selectMainWindow() {
        this.setContext(this.operatorFactory.createOperatorByIndex(0));
    }

    @RobotKeyword(value="Selects a window as current context and sets focus to it.\n\n*N.B.* Regular expression can be used to select the window by prefixing the identifier with 'regexp='.\nPlease learn more about java reqular expressions at http://java.sun.com/docs/books/tutorial/essential/regex/ \n and patterns http://java.sun.com/javase/7/docs/api/java/util/regex/Pattern.html \n\nExample:\n| Select Window | _Help_ |\n| Select Window | _regexp=^H.*_ | Selects a window starting with letter H. |\n")
    @ArgumentNames(value={"identifier"})
    public void selectWindow(String identifier) {
        FrameOperator operator = this.operatorFactory.createOperator(identifier);
        this.setContext(operator);
    }

    @RobotKeyword(value="Closes a window.\n\n*N.B.* Regular expression can be used to close the window by prefixing the identifier with 'regexp='.\nPlease learn more about java reqular expressions at http://java.sun.com/docs/books/tutorial/essential/regex/ \n and patterns http://java.sun.com/javase/7/docs/api/java/util/regex/Pattern.html \n\nExample:\n| Close Window | _Help_ |\n| Close Window | _regexp=^H.*_ | Closes a window starting with letter H. |\n")
    @ArgumentNames(value={"identifier"})
    public void closeWindow(String identifier) {
        FrameOperator operator = this.operatorFactory.createOperator(identifier);
        operator.setDefaultCloseOperation(2);
        new WindowTester().actionClose(operator.getSource());
    }

    @RobotKeyword(value="Returns the title of the selected window.\nAssumes current context is window.\n\nExample:\n| ${title}=     | Get Selected Window Title |            |\n| Should Be Equal | _Help Contents_           | _${title}_ |\n")
    public String getSelectedWindowTitle() {
        return this.frameOperator().getTitle();
    }

    @Override
    protected Class<? extends Component>[] getExpectedClasses() {
        return new Class[]{Window.class};
    }

    private void setContext(FrameOperator frameOperator) {
        frameOperator.getFocus();
        Context.setContext(frameOperator);
    }

    private FrameOperator frameOperator() {
        this.verifyContext();
        return (FrameOperator)Context.getContext();
    }
}

