/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.list;

import org.robotframework.org.netbeans.jemmy.Waitable;
import org.robotframework.swing.list.CellTextExtractor;

public class ListFindItemIndexWaitable
implements Waitable {
    private String itemIdentifier;
    private CellTextExtractor itemTextExtractor;

    public ListFindItemIndexWaitable(CellTextExtractor itemTextExtractor, String itemIdentifier) {
        this.itemTextExtractor = itemTextExtractor;
        this.itemIdentifier = itemIdentifier;
    }

    public Object actionProduced(Object obj) {
        int index = this.findItemIndexWithRenderer(this.itemIdentifier);
        if (index == -1) {
            return null;
        }
        return new Integer(index);
    }

    private int findItemIndexWithRenderer(String expectedText) {
        int itemCount = this.itemTextExtractor.itemCount();
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            String text = this.itemTextExtractor.getTextFromRenderedComponent(itemIndex);
            if (!expectedText.equals(text)) continue;
            return itemIndex;
        }
        throw new RuntimeException("Couldn't find text '" + expectedText + "'");
    }

    public String getDescription() {
        return "Couldn't find item: '" + this.itemIdentifier + "' from the list.";
    }
}

