/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.list;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.Waiter;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JListOperator;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.common.TimeoutCopier;
import org.robotframework.swing.list.CellTextExtractor;
import org.robotframework.swing.list.ListFindItemIndexWaitable;
import org.robotframework.swing.operator.ComponentWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOperator
extends IdentifierSupport
implements ComponentWrapper {
    private JListOperator jListOperator;
    private CellTextExtractor itemTextExtractor;

    public ListOperator(ContainerOperator container, ComponentChooser chooser) {
        this(new JListOperator(container, chooser));
    }

    public ListOperator(ContainerOperator container, int index) {
        this(new JListOperator(container, index));
    }

    public ListOperator(JListOperator jListOperator) {
        this(jListOperator, new CellTextExtractor(jListOperator));
    }

    public ListOperator(JListOperator jListOperator, CellTextExtractor itemTextExtractor) {
        this.jListOperator = jListOperator;
        this.itemTextExtractor = itemTextExtractor;
    }

    public void clickOnItem(String itemIdentifier, int clickCount) {
        this.jListOperator.clickOnItem(this.findIndex(itemIdentifier), clickCount);
    }

    public void clearSelection() {
        this.jListOperator.clearSelection();
    }

    public Object getSelectedValue() {
        int selectedIndex = this.jListOperator.getSelectedIndex();
        return this.itemTextExtractor.getTextFromRenderedComponent(selectedIndex);
    }

    @Override
    public Component getSource() {
        return this.jListOperator.getSource();
    }

    public int getSize() {
        return this.jListOperator.getModel().getSize();
    }

    public void selectAll() {
        this.jListOperator.setSelectionInterval(0, this.getSize() - 1);
    }

    public void selectItems(List<String> itemIdentifiers) {
        int[] indices = this.findIndices(itemIdentifiers);
        this.jListOperator.selectItems(indices);
    }

    protected int[] findIndices(List<String> itemIdentifiers) {
        int[] indices = new int[itemIdentifiers.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.findIndex(itemIdentifiers.get(i));
        }
        return indices;
    }

    protected int findIndex(String itemIdentifier) {
        if (this.isIndex(itemIdentifier)) {
            return this.asIndex(itemIdentifier);
        }
        return this.findIndexWithWait(itemIdentifier);
    }

    private int findIndexWithWait(String itemIdentifier) {
        try {
            Waiter waiter = this.listIndexWaiterFor(this.itemTextExtractor, this.jListOperator, itemIdentifier);
            return (Integer)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Waiter listIndexWaiterFor(CellTextExtractor textExtractor, JListOperator listOperator, String itemIdentifier) {
        Waiter waiter = new Waiter(new ListFindItemIndexWaitable(textExtractor, itemIdentifier));
        waiter.setTimeouts(new TimeoutCopier(listOperator, "JListOperator.WaitFindItemIndexTimeout").getTimeouts());
        return waiter;
    }

    public List<String> getListValues() {
        ListModel model = this.jListOperator.getModel();
        ArrayList<String> items = new ArrayList<String>();
        int itemCount = model.getSize();
        for (int i = 0; i < itemCount; ++i) {
            items.add((String)model.getElementAt(i));
        }
        return items;
    }
}

