/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.table;

import java.awt.Point;
import java.util.Enumeration;
import javax.swing.table.TableColumn;
import org.robotframework.org.netbeans.jemmy.operators.JTableHeaderOperator;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableHeaderOperator
extends IdentifierSupport {
    private final JTableHeaderOperator headerOperator;

    public TableHeaderOperator(JTableHeaderOperator jTableHeaderOperator) {
        this.headerOperator = jTableHeaderOperator;
    }

    public void clickColumn(String identifier) {
        this.click(this.coordinatesOfTableHeaderWith(identifier));
    }

    private Point coordinatesOfTableHeaderWith(String identifier) {
        return this.headerOperator.getPointToClick(this.columnIndex(identifier));
    }

    private void click(Point point) {
        this.headerOperator.clickMouse(point.x, point.y, 1);
    }

    private int columnIndex(String identifier) {
        if (this.isIndex(identifier) && this.validIndex(this.asIndex(identifier))) {
            return this.asIndex(identifier);
        }
        return this.indexOfColumnLabel(identifier);
    }

    public int indexOfColumnLabel(String label) {
        Enumeration<TableColumn> columns = this.columns();
        int i = 0;
        while (columns.hasMoreElements()) {
            if (ObjectUtils.nullSafeEquals(this.nextHeaderValue(columns), label)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("The specified column identifier '" + label + "' is invalid.");
    }

    public Object nextHeaderValue(Enumeration<TableColumn> columns) {
        return columns.nextElement().getHeaderValue();
    }

    public Enumeration<TableColumn> columns() {
        return this.headerOperator.getColumnModel().getColumns();
    }

    private boolean validIndex(int index) {
        return index >= 0 && index < this.headerOperator.getColumnModel().getColumnCount();
    }
}

